---
generated_at: 2026-01-15 18:52:00
metrics:
  claims_total: 25
  claims_with_evidence: 25
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：機能一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：25 / 25、根拠なし：0
- 優先レビュー（高）
  - 該当なし：全ての主張に根拠が存在します

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/stdArray.cls` - 動的配列クラスのソースコード
- E-02: `src/stdEnumerator.cls` - イテレータクラスのソースコード
- E-03: `src/stdLambda.cls` - ラムダ関数クラスのソースコード
- E-04: `src/stdCallback.cls` - コールバッククラスのソースコード
- E-05: `src/stdICallable.cls` - 呼び出し可能インターフェースのソースコード
- E-06: `src/stdRefArray.cls` - 参照配列クラスのソースコード
- E-07: `src/stdQuadTree.cls` - Quadtreeクラスのソースコード
- E-08: `src/stdJSON.cls` - JSONクラスのソースコード
- E-09: `src/stdRegex.cls` - 正規表現クラスのソースコード
- E-10: `src/stdWindow.cls` - ウィンドウ管理クラスのソースコード
- E-11: `src/stdProcess.cls` - プロセス管理クラスのソースコード
- E-12: `src/stdClipboard.cls` - クリップボードクラスのソースコード
- E-13: `src/stdAcc.cls` - アクセシビリティクラスのソースコード
- E-14: `src/stdWebSocket.cls` - WebSocketクラスのソースコード
- E-15: `src/stdHTTP.cls` - HTTPクラスのソースコード
- E-16: `src/stdCOM.cls` - COMラッパークラスのソースコード
- E-17: `src/stdReg.cls` - レジストリ操作クラスのソースコード
- E-18: `src/stdImage.cls` - 画像操作クラスのソースコード
- E-19: `src/stdPerformance.cls` - パフォーマンスクラスのソースコード
- E-20: `src/stdSentry.cls` - センチネルクラスのソースコード
- E-21: `src/stdTimer.cls` - タイマークラスのソースコード
- E-22: `src/stdFiber.cls` - ファイバークラスのソースコード
- E-23: `src/stdUIElement.cls` - UIエレメントクラスのソースコード
- E-24: `src/stdRibbon.cls` - リボン管理クラスのソースコード
- E-25: `src/stdHTTPAuthenticators.bas` - HTTP認証モジュールのソースコード
- E-26: `README.md` - プロジェクトの説明・ロードマップ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | stdArrayはJavaScriptライクな動的配列クラス | E-01, E-26 | ○ |
| C-02 | stdEnumeratorはイテレータ・列挙子クラス | E-02, E-26 | ○ |
| C-03 | stdLambdaは文字列式からラムダ関数を生成 | E-03, E-26 | ○ |
| C-04 | stdCallbackはコールバックオブジェクト生成クラス | E-04, E-26 | ○ |
| C-05 | stdICallableは呼び出し可能インターフェース | E-05 | ○ |
| C-06 | stdRefArrayはVBA配列の参照渡しラッパー | E-06 | ○ |
| C-07 | stdQuadTreeは2次元空間のQuadtreeデータ構造 | E-07 | ○ |
| C-08 | stdJSONはJSONオブジェクトの作成・操作クラス | E-08 | ○ |
| C-09 | stdRegexはVBScript.RegExpのラッパー | E-09, E-26 | ○ |
| C-10 | stdWindowはWin32ウィンドウ管理APIのラッパー | E-10, E-26 | ○ |
| C-11 | stdProcessはプロセス管理クラス | E-11, E-26 | ○ |
| C-12 | stdClipboardはクリップボード管理クラス | E-12, E-26 | ○ |
| C-13 | stdAccはMicrosoft Active Accessibilityのラッパー | E-13, E-26 | ○ |
| C-14 | stdWebSocketはWebSocket通信クラス | E-14, E-26 | ○ |
| C-15 | stdHTTPはHTTP通信クラス | E-15, E-26 | ○ |
| C-16 | stdCOMはCOMオブジェクトのリフレクション・低レベル操作クラス | E-16, E-26 | ○ |
| C-17 | stdRegはWindowsレジストリ操作クラス | E-17 | ○ |
| C-18 | stdImageは画像操作クラス | E-18 | ○ |
| C-19 | stdPerformanceはパフォーマンス計測・最適化クラス | E-19, E-26 | ○ |
| C-20 | stdSentryはセンチネルパターン実装クラス | E-20 | ○ |
| C-21 | stdTimerはタイマークラス | E-21 | ○ |
| C-22 | stdFiberはファイバー実装 | E-22 | ○ |
| C-23 | stdUIElementはMSFormsコントロールのラッパー | E-23 | ○ |
| C-24 | stdRibbonはOfficeリボン状態管理クラス | E-24 | ○ |
| C-25 | stdHTTPAuthenticatorsはHTTP認証ヘルパーモジュール | E-25 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし
  - 全ての機能はソースコードファイルから直接確認できました
  - README.mdの記載とソースコードの実装が一致しています

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードに基づいており、信頼性が高い
- 注意点：
  - stdHTTPは「HOLD」状態と記載されており、機能が完全でない可能性あり
  - WIPディレクトリ内のクラス（stdDictionary、stdError等）は機能一覧に含めていない

## 6) レビュアーチェックリスト（最小）
- [ ] 各機能の説明がソースコードのコメントと一致しているか確認
- [ ] README.mdに記載されているステータス（READY/WIP/HOLD）が機能一覧の備考と一致しているか確認
- [ ] WIPディレクトリ内の機能を今後追加する必要があるか検討
- [ ] 機能のカテゴリ分類が適切か確認（特に境界が曖昧な機能について）
