# 機能設計書 10-stdWindow

## 概要

本ドキュメントは、stdVBAライブラリにおけるWin32ウィンドウ管理APIラッパークラス `stdWindow` の機能設計を詳細に記述したものである。

### 本機能の処理概要

stdWindowは、Win32ウィンドウを管理・操作するためのクラスである。ウィンドウの作成、検索、プロパティ取得/設定、メッセージ送信、キー入力シミュレーションなど、Windowsウィンドウに関する包括的な機能を提供する。

**業務上の目的・背景**：VBAからWindowsアプリケーションを自動化する場合、Win32 APIを直接呼び出す必要があるが、その手順は複雑である。stdWindowはこれらのAPI呼び出しをカプセル化し、直感的なインターフェースで他アプリケーションの操作を可能にする。

**機能の利用シーン**：
- 外部アプリケーションの自動操作
- VBAユーザーフォームのリサイズ可能化
- ウィンドウの検索と特定
- ウィンドウへのキー入力シミュレーション
- ウィンドウスタイルの変更（常に最前面表示等）
- 複数ウィンドウの階層的な探索

**主要な処理内容**：
1. ウィンドウオブジェクトの生成（Create, CreateFromHwnd, CreateFromDesktop, CreateFromPoint, CreateFromIUnknown）
2. ウィンドウプロパティの取得/設定（Caption, Class, Style, RectWindow等）
3. ウィンドウ検索（FindFirst, FindAll, Children, GetDescendents）
4. ウィンドウ操作（Activate, Quit, Redraw, SendMessage, PostMessage）
5. キー入力シミュレーション（SendKeysEvent）
6. マウスクリックイベント（ClickEvent）

**関連システム・外部連携**：Win32 API（user32.dll, kernel32.dll, gdi32.dll等）に依存。

**権限による制御**：一部の操作は管理者権限が必要な場合がある。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本クラスはUIを持たないライブラリクラス |

## 機能種別

ウィンドウ管理 / Win32 API / GUI自動化

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| hwnd | LongPtr | Yes | ウィンドウハンドル（CreateFromHwnd時） | 有効なhwnd |
| x, y | Long | Yes | 座標（CreateFromPoint時） | - |
| obj | IUnknown | Yes | COMオブジェクト（CreateFromIUnknown時） | IOleWindow実装 |
| sClassName | String | Yes | ウィンドウクラス名（Create時） | - |
| query | stdICallable | Yes | 検索条件（FindFirst/FindAll時） | - |
| searchType | EWndFindType | No | 検索タイプ（BFS/DFS） | - |

### 主要なEnum定義

| Enum名 | 値 | 説明 |
|--------|-----|------|
| EWndState.Normal | 0 | 通常状態 |
| EWndState.Maximised | 1 | 最大化 |
| EWndState.Minimised | 2 | 最小化 |
| EWndFindType.BreadthFirst | 0 | 幅優先検索 |
| EWndFindType.DepthFirst | 1 | 深さ優先検索 |
| EWndFindResult.matchFound | 1 | マッチ発見 |
| EWndFindResult.NoMatchFound | 0 | 未発見、検索継続 |
| EWndFindResult.NoMatchCancelSearch | 2 | 未発見、検索中止 |
| EWndFindResult.NoMatchSkipDescendents | 3 | 未発見、子孫スキップ |

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| handle | LongPtr | ウィンドウハンドル |
| hDC | LongPtr | ディスプレイコンテキスト |
| Exists | Boolean | ウィンドウ存在確認 |
| Visible | Boolean | 表示状態 |
| State | EWndState | ウィンドウ状態 |
| Caption | String | ウィンドウタイトル |
| Class | String | ウィンドウクラス名 |
| RectWindow | Variant | ウィンドウ矩形(Left,Top,Width,Height) |
| ProcessID | Long | プロセスID |
| ProcessName | String | プロセス名 |
| Parent | stdWindow | 親ウィンドウ |
| Children | Collection | 子ウィンドウコレクション |
| Style | Long | ウィンドウスタイル |
| StyleEx | Long | 拡張ウィンドウスタイル |

## 処理フロー

### 処理シーケンス

```
1. CreateFromHwnd(hwnd)
   └─ protInit: ハンドル設定

2. CreateFromDesktop()
   └─ GetDesktopWindow API呼び出し
   └─ CreateFromHwnd

3. CreateFromIUnknown(obj)
   └─ IUnknown_GetWindow API呼び出し
   └─ CreateFromHwnd

4. FindFirst(query)
   └─ スタック初期化
   └─ BFS/DFS探索ループ
      └─ query.Run実行
      └─ 結果に応じて継続/終了/子孫追加

5. SendMessage(wMsg, wParam, lParam)
   └─ Existsチェック
   └─ SendMessageA API呼び出し

6. プロパティ取得 (Caption, Class等)
   └─ Existsチェック
   └─ GetWindowText/GetClassName API呼び出し
```

### フローチャート

```mermaid
flowchart TD
    A[CreateFromHwnd] --> B[protInit]
    B --> C[Handle設定]
    C --> D[stdWindow返却]

    E[CreateFromDesktop] --> F[GetDesktopWindow API]
    F --> G[CreateFromHwnd]
    G --> D

    H[CreateFromIUnknown] --> I[IUnknown_GetWindow API]
    I --> J{成功?}
    J -->|Yes| G
    J -->|No| K[エラー発生]

    L[FindFirst] --> M[スタック初期化]
    M --> N{Length > 0?}
    N -->|Yes| O[要素取得]
    O --> P[query.Run]
    P --> Q{結果判定}
    Q -->|MatchFound| R[要素返却]
    Q -->|NoMatchFound| S[子孫追加]
    S --> N
    Q -->|CancelSearch| T[Nothing返却]
    Q -->|SkipDescendents| N
    N -->|No| T

    U[プロパティ取得] --> V{Exists?}
    V -->|Yes| W[Win32 API呼び出し]
    W --> X[値返却]
    V -->|No| Y[エラー発生]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 存在確認 | 操作前にExistsチェック | 全プロパティ/メソッド |
| BR-002 | Win64対応 | LongPtr型でポインタ管理 | 全ハンドル操作 |
| BR-003 | BFS/DFS | 検索タイプ選択可能 | FindFirst/FindAll |
| BR-004 | スタイルビット操作 | bitFlagCheck/Setで操作 | Style/StyleEx変更 |
| BR-005 | VBA作成ウィンドウ | Class_Terminateで自動破棄 | Create時 |
| BR-006 | キャッシュ | Lookupsでスタイル名をキャッシュ | StyleTexts取得時 |

### ウィンドウスタイル定数

```
WS_BORDER = &H800000
WS_CAPTION = &HC00000
WS_CHILD = &H40000000
WS_POPUP = &H80000000
WS_THICKFRAME = &H40000   ' リサイズ可能
WS_VISIBLE = &H10000000
WS_EX_TOPMOST = &H8       ' 常に最前面
WS_EX_LAYERED = &H80000   ' レイヤードウィンドウ
```

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | 本クラスはDBアクセスを行わない |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | Err.Raise | ウィンドウが存在しない | "Window does not exist." |
| 1 | Err.Raise | IOleWindow未実装 | "This object does not implement IOleWindow..." |
| 1 | Err.Raise | ウィンドウ作成失敗 | "Failed to create window." |
| 1 | Err.Raise | 未実装機能 | "Error: Not implemented." |
| - | Err.LastDllError | Win32 APIエラー | DLLエラーコード参照 |

### リトライ仕様

リトライ仕様なし

## トランザクション仕様

トランザクション管理なし（Win32 API呼び出しのみ）

## パフォーマンス要件

- プロパティ取得: O(1)（単一API呼び出し）
- Children取得: O(n)（子ウィンドウ数に比例）
- FindFirst/FindAll: O(n)（探索対象ウィンドウ数に比例）
- GetDescendents: O(n)（再帰的な全子孫取得）

## セキュリティ考慮事項

- 他プロセスのウィンドウ操作には権限が必要な場合がある
- SendMessage/PostMessageによる任意メッセージ送信は慎重に
- WndProc変更はクラッシュの原因になりうる
- UserData設定時のオブジェクトライフサイクル管理に注意

## 備考

- VB_PredeclaredId = True により、stdWindowをインスタンス化せずにファクトリメソッドを呼び出し可能
- Win64/Win32両対応（#If VBA7 / #If Win64 条件コンパイル）
- Mac非対応（TODO: Mac compatibility）
- Class_Terminateで、VBAが作成したウィンドウは自動的にDestroyWindowされる
- stdLambdaと組み合わせてウィンドウ検索条件を柔軟に指定可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造とAPI宣言を理解する

まず、stdWindowの内部データ構造と使用するWin32 APIを理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | stdWindow.cls | `src/stdWindow.cls` | 564-571行目: TThis型定義 |
| 1-2 | stdWindow.cls | `src/stdWindow.cls` | 102-107行目: apiRect型 |
| 1-3 | stdWindow.cls | `src/stdWindow.cls` | 212-216行目: EWndState enum |
| 1-4 | stdWindow.cls | `src/stdWindow.cls` | 149-206行目: EWndStyles/EWndExStyles enum |
| 1-5 | stdWindow.cls | `src/stdWindow.cls` | 363-375行目: EWndFindType/EWndFindResult enum |
| 1-6 | stdWindow.cls | `src/stdWindow.cls` | 403-556行目: Win32 API宣言 |

**読解のコツ**:
- `TThis.Handle`: ウィンドウハンドル（hwnd）
- `TThis.Initialized`: 初期化フラグ
- `TThis.isCreatedByVBA`: VBA作成フラグ（自動破棄用）
- `#If VBA7 / #If Win64`: 64bit/32bit両対応

#### Step 2: ファクトリメソッドを理解する

Create関数群とprotInit関数を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | stdWindow.cls | `src/stdWindow.cls` | 643-650行目: CreateFromHwnd |
| 2-2 | stdWindow.cls | `src/stdWindow.cls` | 681-683行目: CreateFromDesktop |
| 2-3 | stdWindow.cls | `src/stdWindow.cls` | 691-694行目: CreateFromPoint |
| 2-4 | stdWindow.cls | `src/stdWindow.cls` | 707-719行目: CreateFromIUnknown |
| 2-5 | stdWindow.cls | `src/stdWindow.cls` | 593-603行目: Create（新規ウィンドウ作成） |
| 2-6 | stdWindow.cls | `src/stdWindow.cls` | 824-831行目: protInit |
| 2-7 | stdWindow.cls | `src/stdWindow.cls` | 633-637行目: Class_Terminate |

**主要処理フロー**:
1. **643-650行目**: CreateFromHwnd - 既存ハンドルからstdWindow生成
2. **681-683行目**: CreateFromDesktop - GetDesktopWindow APIでデスクトップ取得
3. **707-719行目**: CreateFromIUnknown - IOleWindowからハンドル取得
4. **824-831行目**: protInit - ハンドルと初期化フラグを設定
5. **633-637行目**: Class_Terminate - VBA作成ウィンドウの自動破棄

#### Step 3: プロパティ操作を理解する

主要なウィンドウプロパティの取得/設定を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | stdWindow.cls | `src/stdWindow.cls` | 845-851行目: handleプロパティ |
| 3-2 | stdWindow.cls | `src/stdWindow.cls` | 873-877行目: Existsプロパティ |
| 3-3 | stdWindow.cls | `src/stdWindow.cls` | 891-909行目: Captionプロパティ |
| 3-4 | stdWindow.cls | `src/stdWindow.cls` | 913-922行目: Classプロパティ |
| 3-5 | stdWindow.cls | `src/stdWindow.cls` | 926-943行目: Visibleプロパティ |
| 3-6 | stdWindow.cls | `src/stdWindow.cls` | 947-977行目: Stateプロパティ |
| 3-7 | stdWindow.cls | `src/stdWindow.cls` | 1275-1295行目: Styleプロパティ |
| 3-8 | stdWindow.cls | `src/stdWindow.cls` | 1422-1428行目: isResizableプロパティ |

**主要処理フロー**:
- **873-877行目**: Exists - IsWindow APIで存在確認
- **891-900行目**: Caption Get - GetWindowText APIで取得
- **913-922行目**: Class - GetClassName APIで取得
- **1275-1295行目**: Style - GetWindowLongA/SetWindowLongA APIで操作
- **1422-1428行目**: isResizable - WS_THICKFRAMEビットフラグ操作

#### Step 4: ウィンドウ検索を理解する

FindFirst/FindAllメソッドを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | stdWindow.cls | `src/stdWindow.cls` | 981-1017行目: Childrenプロパティ |
| 4-2 | stdWindow.cls | `src/stdWindow.cls` | 1695-1755行目: FindFirstメソッド |
| 4-3 | stdWindow.cls | `src/stdWindow.cls` | 1785-1852行目: FindAllメソッド |
| 4-4 | stdWindow.cls | `src/stdWindow.cls` | 1903-1921行目: GetDescendentsメソッド |

**主要処理フロー**:
- **981-1017行目**: Children - GetWindow(GW_CHILD/GW_HWNDNEXT)で子ウィンドウ取得
- **1695-1755行目**: FindFirst - BFS/DFSでウィンドウツリー探索
- **1727行目**: query.Run(.element, .depth)でコールバック実行
- **1785-1852行目**: FindAll - 複数マッチを返却

#### Step 5: ウィンドウ操作を理解する

ウィンドウの操作メソッドを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | stdWindow.cls | `src/stdWindow.cls` | 1871-1877行目: Quitメソッド |
| 5-2 | stdWindow.cls | `src/stdWindow.cls` | 1891-1898行目: Activateメソッド |
| 5-3 | stdWindow.cls | `src/stdWindow.cls` | 1924-1927行目: Redrawメソッド |
| 5-4 | stdWindow.cls | `src/stdWindow.cls` | 1934-1940行目: SendMessageメソッド |
| 5-5 | stdWindow.cls | `src/stdWindow.cls` | 1946-1958行目: PostMessageメソッド |

**主要処理フロー**:
- **1871-1877行目**: Quit - WM_CLOSE(0x10)をPostMessage
- **1891-1898行目**: Activate - SetForegroundWindow API
- **1934-1940行目**: SendMessage - SendMessageA APIラッパー
- **1946-1958行目**: PostMessage - PostMessageA APIラッパー

### プログラム呼び出し階層図

```
stdWindow.CreateFromHwnd(hwnd)
    │
    └─ stdWindow.protInit(hwnd)
           └─ This.Handle = hwnd

stdWindow.CreateFromDesktop()
    │
    └─ GetDesktopWindow() API
           └─ CreateFromHwnd()

stdWindow.CreateFromIUnknown(obj)
    │
    ├─ IUnknown_GetWindow() API
    │
    └─ CreateFromHwnd()

stdWindow.Children
    │
    ├─ GetWindow(GW_CHILD) API
    │
    └─ GetWindow(GW_HWNDNEXT) ループ
           └─ CreateFromHwnd()

stdWindow.FindFirst(query)
    │
    ├─ スタック初期化
    │
    └─ 探索ループ
           │
           ├─ [BFS] index++
           ├─ [DFS] stackPop
           │
           └─ query.Run(element, depth)
                  │
                  ├─ [MatchFound] → 要素返却
                  ├─ [NoMatchFound] → 子孫をstackPush
                  ├─ [CancelSearch] → Nothing返却
                  └─ [SkipDescendents] → 継続

stdWindow.Caption [Get]
    │
    ├─ Existsチェック
    │
    └─ GetWindowText() API

stdWindow.Style [Let]
    │
    ├─ Existsチェック
    │
    └─ SetWindowLongA() API

stdWindow.isResizable [Let]
    │
    └─ Style = bitFlagSet(Style, WS_THICKFRAME, v)
           └─ SetWindowLongA() API
```

### データフロー図

```
[入力]                      [処理]                          [出力]

CreateFromHwnd(hwnd) ───▶ protInit ────────────────────▶ stdWindow
                              └─▶ Handle設定

CreateFromDesktop() ────▶ GetDesktopWindow API ────────▶ stdWindow
                              └─▶ CreateFromHwnd

CreateFromIUnknown ─────▶ IUnknown_GetWindow API ──────▶ stdWindow
                              └─▶ CreateFromHwnd

Caption [Get] ──────────▶ GetWindowText API ───────────▶ String
                              └─▶ バッファから文字列抽出

Style [Let] ────────────▶ SetWindowLongA API ──────────▶ ウィンドウ更新
                              └─▶ エラーチェック

Children ───────────────▶ GetWindow(GW_CHILD) ─────────▶ Collection
                              │                          <stdWindow>
                              └─▶ GW_HWNDNEXTループ

FindFirst(query) ───────▶ BFS/DFS探索 ─────────────────▶ stdWindow
                              │                          または Nothing
                              └─▶ query.Run()

SendMessage(wMsg,...) ──▶ SendMessageA API ────────────▶ Long (結果)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| stdWindow.cls | `src/stdWindow.cls` | ソース | ウィンドウ管理クラス |
| stdLambda.cls | `src/stdLambda.cls` | ソース | 検索条件のラムダ式（依存） |
| stdICallable.cls | `src/stdICallable.cls` | ソース | コールバックインターフェース（依存） |
| stdAcc.cls | `src/stdAcc.cls` | ソース | アクセシビリティ（オプション依存） |
