# 機能設計書 11-stdProcess

## 概要

本ドキュメントは、stdVBAライブラリのプロセス管理クラス「stdProcess」の機能設計を記載する。stdProcessは、Windowsプロセスの作成・情報取得・強制終了などの操作をVBAから行うためのラッパークラスである。

### 本機能の処理概要

stdProcessは、Windows Kernel32 APIを活用してプロセス操作機能を提供するVBAクラスモジュールである。

**業務上の目的・背景**：VBAアプリケーションから外部プログラムの起動・監視・制御が必要なケースに対応する。バッチ処理の自動化、外部ツール連携、プロセス監視など、業務自動化シナリオにおいて不可欠な機能を提供する。

**機能の利用シーン**：
- Excel VBAから外部アプリケーション（PDF変換ツール、データ変換ツール等）を起動し、完了まで待機する処理
- 特定のプロセスが実行中かどうかを監視するシステム管理ツール
- 異常終了したプロセスの強制終了処理

**主要な処理内容**：
1. Shell関数を使用したプロセスの新規作成（Create）
2. プロセスIDからプロセスオブジェクトの取得（CreateFromProcessId）
3. クエリ条件によるプロセス検索（CreateFromQuery、CreateManyFromQuery）
4. 全プロセス一覧の取得（CreateAll）
5. プロセス情報の取得（name、path、isRunning、Priority等）
6. プロセスの強制終了（forceQuit）
7. プロセス終了までの待機（waitTilClose）

**関連システム・外部連携**：Windows Kernel32.dll APIを通じたプロセス操作、WMI（Winmgmts）によるプロセス情報取得

**権限による制御**：システムプロセスや他ユーザーのプロセスへのアクセスにはWindows権限が必要。isCriticalプロパティで重要プロセス判定が可能

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | なし | - | VBAライブラリクラスのため画面連携なし |

## 機能種別

ユーティリティ機能 / システム操作 / プロセス管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| sCmd | String | Yes | 起動するプロセスのコマンド文字列 | 空文字列でない |
| winStyle | VbAppWinStyle | No | ウィンドウ表示スタイル（既定: vbHide） | VbAppWinStyle列挙型の値 |
| pID | Long | Yes | プロセスID（CreateFromProcessIdの場合） | 正の整数値 |
| query | stdICallable | Yes | 検索条件（CreateFromQueryの場合） | stdICallable実装オブジェクト |
| ExitCode | Long | No | 強制終了時の終了コード（既定: 0） | Long型の値 |

### 入力データソース

- コマンドライン引数（プロセス起動時）
- プロセスID（既存プロセス参照時）
- stdICallable実装のクエリ条件（プロセス検索時）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | Long | プロセスID |
| name | String | プロセス名（実行ファイル名） |
| path | String | プロセスの完全パス |
| isRunning | Boolean | 実行中フラグ |
| isCritical | Boolean | 重要プロセスフラグ |
| Priority | EProcessPriority | プロセス優先度 |
| TimeCreated | Date | プロセス開始時刻（UTC） |
| TimeQuit | Date | プロセス終了時刻（UTC） |
| TimeKernel | Date | カーネルモード実行時間 |
| TimeUser | Date | ユーザーモード実行時間 |
| ExitCode | Long | 終了コード |
| CommandLine | String | コマンドライン引数 |
| Winmgmt | Object | WMIオブジェクト |

### 出力先

VBAオブジェクトのプロパティとしてメモリ内に保持

## 処理フロー

### 処理シーケンス

```
1. プロセス作成（Create）
   └─ Shell関数でプロセス起動し、protInitFromProcessIdで初期化

2. プロセス情報取得（CreateFromProcessId）
   └─ OpenProcess APIでハンドル取得、QueryFullProcessImageNameAでパス取得

3. プロセス検索（CreateFromQuery）
   └─ CreateToolhelp32Snapshot → Process32First/Next → クエリ評価

4. プロセス強制終了（forceQuit）
   └─ OpenProcess(PROCESS_TERMINATE) → TerminateProcess

5. 終了待機（waitTilClose）
   └─ isRunning=Falseになるまでループ
```

### フローチャート

```mermaid
flowchart TD
    A[Create/CreateFromProcessId] --> B[protInitFromProcessId]
    B --> C[プロセス名取得]
    B --> D[プロセスパス取得]
    B --> E[QueryInfoHandle取得]

    F[CreateFromQuery] --> G[CreateToolhelp32Snapshot]
    G --> H[Process32First]
    H --> I{プロセスあり?}
    I -->|Yes| J[クエリ評価]
    J --> K{マッチ?}
    K -->|Yes| L[stdProcess返却]
    K -->|No| M[Process32Next]
    M --> I
    I -->|No| N[Nothing返却]

    O[forceQuit] --> P[OpenProcess TERMINATE]
    P --> Q[TerminateProcess]
    Q --> R[CloseHandle]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | プロセスハンドル管理 | Class_Terminateで自動的にハンドルを解放 | オブジェクト破棄時 |
| BR-02 | 権限チェック | システムプロセスへのアクセスはエラーを無視 | OpenProcessエラー時 |
| BR-03 | 静的キャッシュ | PROCESSENTRY32情報はプロセスID単位でキャッシュ | getCachedProcessEntry使用時 |

### 計算ロジック

- TimeFromFileTime: Windows FILETIME構造体からVBA Date型への変換
- GetProcessVersion: プロセスが実行中かどうかの判定に使用（戻り値>0で実行中）

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | なし | - | データベース操作なし |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | isCriticalエラー | プロセスのクリティカル状態取得失敗 | DLLエラーコードを確認 |
| 1 | TimeCreatedエラー | プロセス作成時刻取得失敗 | プロセスハンドルを確認 |
| 1 | TimeQuitエラー | 実行中プロセスの終了時刻取得試行 | isRunning確認後に呼び出し |
| DllError | ForceQuitエラー | TerminateProcess失敗 | 権限・プロセス状態を確認 |
| DllError | ExitCodeエラー | 終了コード取得失敗 | ハンドル有効性を確認 |

### リトライ仕様

明示的なリトライ仕様なし。呼び出し側でのエラーハンドリング推奨

## トランザクション仕様

該当なし（メモリ内操作のみ）

## パフォーマンス要件

- CreateAll: 全プロセス列挙のため、プロセス数に比例した処理時間
- waitTilClose: DoEventsによる協調的マルチタスキング

## セキュリティ考慮事項

- PROCESS_TERMINATE権限が必要な操作ではエラーが発生する可能性
- システムプロセスへのアクセスはエラーコード5（ACCESS_DENIED）
- isCriticalプロパティで重要プロセスの誤終了を防止

## 備考

- Mac/VBA7/32bit/64bitの条件付きコンパイルに対応
- PredeclaredId属性により、インスタンス化せずにCreateメソッドを呼び出し可能
- WMI経由のCommandLine取得は、プロセス起動後に引数が変更されている可能性あり

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

VBA内で使用される型定義とWindows API構造体を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | stdProcess.cls | `src/stdProcess.cls` | TThis型（244-252行目）でプロセス状態管理を理解 |
| 1-2 | stdProcess.cls | `src/stdProcess.cls` | PROCESSENTRY32構造体（231-242行目）でプロセス情報構造を理解 |
| 1-3 | stdProcess.cls | `src/stdProcess.cls` | EProcessPriority、EProcessAccess列挙型（176-202行目） |

**読解のコツ**: VBA7条件付きコンパイルで32bit/64bit両対応している。LongPtr型はプラットフォームに応じたポインタサイズ。

#### Step 2: エントリーポイントを理解する

コンストラクタメソッドがエントリーポイントとなる。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | stdProcess.cls | `src/stdProcess.cls` | Create関数（259-262行目）がプロセス起動の入口 |
| 2-2 | stdProcess.cls | `src/stdProcess.cls` | CreateFromProcessId（268-271行目）が既存プロセス参照の入口 |
| 2-3 | stdProcess.cls | `src/stdProcess.cls` | CreateFromQuery（277-295行目）がクエリ検索の入口 |

**主要処理フロー**:
1. **259-262行目**: Create - Shell関数でプロセス起動、protInitFromProcessIdで初期化
2. **268-271行目**: CreateFromProcessId - プロセスIDから初期化
3. **277-295行目**: CreateFromQuery - スナップショット取得→ループ→クエリ評価

#### Step 3: 初期化処理を理解する

protInitFromProcessIdが内部初期化の中核。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | stdProcess.cls | `src/stdProcess.cls` | protInitFromProcessId（351-359行目）でプロセス情報の収集 |
| 3-2 | stdProcess.cls | `src/stdProcess.cls` | getProcessImageName（628-651行目）でパス取得 |
| 3-3 | stdProcess.cls | `src/stdProcess.cls` | getProcessNameById（586-589行目）で名前取得 |

**主要処理フロー**:
- **351-359行目**: This構造体にプロセスID、名前、パス、ハンドルを格納
- **358行目**: OpenProcess(PROCESS_QUERY_INFORMATION)でクエリ用ハンドル取得

#### Step 4: プロパティ取得処理を理解する

各種プロパティの実装パターンを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | stdProcess.cls | `src/stdProcess.cls` | isRunning（414-416行目）- GetProcessVersion API使用 |
| 4-2 | stdProcess.cls | `src/stdProcess.cls` | TimeCreated（438-446行目）- GetProcessTimes API使用 |
| 4-3 | stdProcess.cls | `src/stdProcess.cls` | Winmgmt（400-404行目）- WMI経由のプロセス情報取得 |

#### Step 5: 終了処理を理解する

プロセス終了とリソース解放の実装を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | stdProcess.cls | `src/stdProcess.cls` | forceQuit（507-517行目）- TerminateProcess呼び出し |
| 5-2 | stdProcess.cls | `src/stdProcess.cls` | waitTilClose（520-524行目）- isRunning監視ループ |
| 5-3 | stdProcess.cls | `src/stdProcess.cls` | Class_Terminate（362-364行目）- ハンドル解放 |

### プログラム呼び出し階層図

```
stdProcess.Create(sCmd, winStyle)
    │
    ├─ Shell(sCmd, winStyle)                [VBA組み込み]
    │
    └─ protInitFromProcessId(pID)
           │
           ├─ getProcessNameById(pID)
           │      └─ getCachedProcessEntry(pID)
           │             ├─ CreateToolhelp32Snapshot()  [Kernel32]
           │             ├─ Process32First()            [Kernel32]
           │             └─ Process32Next()             [Kernel32]
           │
           ├─ getProcessImageName(pID)
           │      ├─ OpenProcess()                      [Kernel32]
           │      └─ QueryFullProcessImageNameA()       [Kernel32]
           │
           └─ OpenProcess(PROCESS_QUERY_INFORMATION)    [Kernel32]

stdProcess.forceQuit(ExitCode)
    │
    ├─ protProcessHandleCreate(PROCESS_TERMINATE)
    │      └─ OpenProcess()                             [Kernel32]
    │
    ├─ TerminateProcess()                               [Kernel32]
    │
    └─ protProcessHandleRelease()
           └─ CloseHandle()                             [Kernel32]
```

### データフロー図

```
[入力]                    [処理]                         [出力]

コマンド文字列 ───────▶ Shell() ──────────────────▶ プロセスID
     │                      │
     │                      ▼
     │              protInitFromProcessId()
     │                      │
     │          ┌───────────┼───────────┐
     │          ▼           ▼           ▼
     │     名前取得      パス取得    ハンドル取得
     │          │           │           │
     │          └───────────┼───────────┘
     │                      ▼
     │              TThis構造体に格納
     │                      │
     └──────────────────────┼──────────────────────────▶ stdProcessオブジェクト
                            │
                            ▼
                    各種プロパティ参照
                    (isRunning, name, path等)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| stdProcess.cls | `src/stdProcess.cls` | ソース | プロセス管理クラス本体 |
| stdICallable.cls | `src/stdICallable.cls` | インターフェース | CreateFromQueryのクエリ条件インターフェース |
| stdLambda.cls | `src/stdLambda.cls` | ソース | クエリ条件の簡易記述に使用 |
