# 機能設計書 12-stdClipboard

## 概要

本ドキュメントは、stdVBAライブラリのクリップボード管理クラス「stdClipboard」の機能設計を記載する。stdClipboardは、Windowsクリップボードへのデータ読み書きをVBAから行うためのラッパークラスである。

### 本機能の処理概要

stdClipboardは、Windows User32 APIおよびOLE APIを活用してクリップボード操作機能を提供するVBAクラスモジュールである。

**業務上の目的・背景**：VBAアプリケーションでクリップボードを介したデータ交換が必要なケースに対応する。テキストのコピー&ペースト、画像のコピー、ファイルパスリストの取得など、ユーザーインターフェースとの連携に不可欠な機能を提供する。

**機能の利用シーン**：
- Excel VBAで処理結果をクリップボードにコピーして他アプリケーションと共有
- クリップボードから画像を取得して加工・保存
- ファイルエクスプローラーでコピーしたファイルのパスリストを取得

**主要な処理内容**：
1. テキストデータのクリップボードへの設定・取得
2. 画像データ（stdImage）のクリップボードへの設定・取得
3. ファイルドロップリストの取得
4. クリップボードのクリア
5. 利用可能なフォーマットの取得

**関連システム・外部連携**：Windows User32.dll API、OLE32.dll API、stdImageクラスとの連携

**権限による制御**：クリップボードへのアクセスはWindows標準のセキュリティ制限に従う

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | なし | - | VBAライブラリクラスのため画面連携なし |

## 機能種別

ユーティリティ機能 / システム操作 / クリップボード管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| value | String | Yes | 設定するテキストデータ（Textプロパティ） | 任意の文字列 |
| value | stdImage | Yes | 設定する画像データ（Imageプロパティ） | stdImageオブジェクト |

### 入力データソース

- VBAコードからの文字列データ
- stdImageオブジェクト
- Windowsクリップボード（読み取り時）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Text | String | クリップボード内のテキストデータ |
| Image | stdImage | クリップボード内の画像データ |
| Files | String() | クリップボード内のファイルパスリスト |
| AvailableFormats | Long() | 利用可能なクリップボードフォーマットID配列 |
| AvailableFormatNames | String() | 利用可能なクリップボードフォーマット名配列 |

### 出力先

VBAオブジェクトのプロパティとしてメモリ内に保持、またはWindowsクリップボードへの書き込み

## 処理フロー

### 処理シーケンス

```
1. テキスト取得（Text Get）
   └─ CreateObject("htmlfile").ParentWindow.ClipboardData.GetData("text")

2. テキスト設定（Text Let）
   └─ CreateObject("htmlfile").ParentWindow.ClipboardData.SetData("text", value)

3. 画像取得（Image Get）
   └─ stdImage.CreateFromClipboard()

4. 画像設定（Image Set）
   └─ stdImage.toClipboard()

5. ファイル取得（Files Get）
   └─ OpenClipboard → GetClipboardData(CF_HDROP) → DragQueryFileW
```

### フローチャート

```mermaid
flowchart TD
    A[Text取得] --> B[HTMLDocument作成]
    B --> C[ClipboardData.GetData]
    C --> D[テキスト返却]

    E[Text設定] --> F[HTMLDocument作成]
    F --> G[ClipboardData.SetData]

    H[Files取得] --> I[OpenClipboard]
    I --> J[GetClipboardData CF_HDROP]
    J --> K[DragQueryFileW ループ]
    K --> L[ファイルパス配列返却]
    L --> M[CloseClipboard]

    N[Clear] --> O[OpenClipboard]
    O --> P[EmptyClipboard]
    P --> Q[CloseClipboard]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | HTMLファイル経由のテキスト操作 | IE/HTMLDocument経由でテキストをやり取り | Text Get/Let時 |
| BR-02 | stdImage連携 | 画像操作はstdImageクラスに委譲 | Image Get/Set時 |
| BR-03 | クリップボードロック | OpenClipboard/CloseClipboardでロック管理 | Files取得、Clear時 |

### クリップボードフォーマット定数

| 定数名 | 値 | 説明 |
|--------|-----|------|
| CF_TEXT | 1 | テキスト（ANSI） |
| CF_BITMAP | 2 | ビットマップ画像 |
| CF_METAFILEPICT | 3 | メタファイル画像 |
| CF_SYLK | 4 | SYLK形式 |
| CF_DIF | 5 | DIF形式 |
| CF_TIFF | 6 | TIFF画像 |
| CF_OEMTEXT | 7 | OEMテキスト |
| CF_DIB | 8 | DIB画像 |
| CF_PALETTE | 9 | パレット |
| CF_PENDATA | 10 | ペンデータ |
| CF_RIFF | 11 | RIFF |
| CF_WAVE | 12 | WAVEオーディオ |
| CF_UNICODETEXT | 13 | Unicodeテキスト |
| CF_ENHMETAFILE | 14 | 拡張メタファイル |
| CF_HDROP | 15 | ファイルドロップリスト |
| CF_LOCALE | 16 | ロケール |
| CF_DIBV5 | 17 | DIB v5 |

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | なし | - | データベース操作なし |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | HTMLDocument失敗 | IE/HTML機能が無効な環境 | On Error Resume Next で保護 |
| - | OpenClipboard失敗 | クリップボードが他プロセスでロック中 | リトライまたはエラーハンドリング |
| - | GetClipboardData失敗 | 要求フォーマットがクリップボードに存在しない | 空データを返却 |

### リトライ仕様

明示的なリトライ仕様なし。OpenClipboard失敗時は呼び出し側でのリトライ推奨

## トランザクション仕様

該当なし（メモリ内操作のみ）

## パフォーマンス要件

- HTMLDocument生成はオーバーヘッドあり（毎回新規作成）
- 大量のファイルリストがある場合、DragQueryFileWループに時間がかかる可能性

## セキュリティ考慮事項

- クリップボードは他アプリケーションと共有される領域
- 機密データをクリップボードに残さないよう、Clearメソッドの使用を推奨
- HTMLDocument経由のため、悪意のあるスクリプトが実行される可能性は低い

## 備考

- Mac環境では動作しない（Windows API依存）
- VBA7/64bit対応の条件付きコンパイルあり
- PredeclaredId属性により、stdClipboard.Textのように直接アクセス可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

クリップボードフォーマット定数とAPI宣言を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | stdClipboard.cls | `src/stdClipboard.cls` | CF_* 定数定義（31-49行目）でクリップボードフォーマットを理解 |
| 1-2 | stdClipboard.cls | `src/stdClipboard.cls` | Windows API宣言（52-76行目）でUser32/Shell32 APIを理解 |

**読解のコツ**: CF_で始まる定数はWindowsクリップボードの標準フォーマット。CF_HDROP(15)はファイルドロップ時に使用される。

#### Step 2: テキスト操作を理解する

HTMLDocument経由のテキスト操作パターンを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | stdClipboard.cls | `src/stdClipboard.cls` | Text Get プロパティ（92-99行目）でGetDataパターンを理解 |
| 2-2 | stdClipboard.cls | `src/stdClipboard.cls` | Text Let プロパティ（106-114行目）でSetDataパターンを理解 |

**主要処理フロー**:
- **92-99行目**: HTMLDocument.ParentWindow.ClipboardData.GetData("text") でテキスト取得
- **106-114行目**: ClipboardData.SetData("text", value) でテキスト設定

#### Step 3: 画像操作を理解する

stdImageクラスへの委譲パターンを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | stdClipboard.cls | `src/stdClipboard.cls` | Image Get プロパティ（121-123行目） |
| 3-2 | stdClipboard.cls | `src/stdClipboard.cls` | Image Set プロパティ（130-132行目） |
| 3-3 | stdImage.cls | `src/stdImage.cls` | CreateFromClipboard、toClipboardメソッド |

**主要処理フロー**:
- **121-123行目**: stdImage.CreateFromClipboard() に委譲
- **130-132行目**: img.toClipboard() に委譲

#### Step 4: ファイルリスト操作を理解する

CF_HDROP形式のファイルリスト取得を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | stdClipboard.cls | `src/stdClipboard.cls` | Files Get プロパティ（139-163行目） |

**主要処理フロー**:
1. **142行目**: OpenClipboard(0) でクリップボードを開く
2. **143行目**: GetClipboardData(CF_HDROP) でファイルドロップハンドル取得
3. **146-159行目**: DragQueryFileW ループでファイルパスを取得
4. **162行目**: CloseClipboard でクリップボードを閉じる

#### Step 5: ユーティリティ機能を理解する

フォーマット取得とクリア機能を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | stdClipboard.cls | `src/stdClipboard.cls` | Clear メソッド（170-175行目） |
| 5-2 | stdClipboard.cls | `src/stdClipboard.cls` | AvailableFormats プロパティ（180-196行目） |
| 5-3 | stdClipboard.cls | `src/stdClipboard.cls` | AvailableFormatNames プロパティ（200-215行目） |

### プログラム呼び出し階層図

```
stdClipboard.Text (Get)
    │
    └─ CreateObject("htmlfile")
           └─ ParentWindow.ClipboardData.GetData("text")

stdClipboard.Text (Let)
    │
    └─ CreateObject("htmlfile")
           └─ ParentWindow.ClipboardData.SetData("text", value)

stdClipboard.Image (Get)
    │
    └─ stdImage.CreateFromClipboard()     [stdImage.cls]
           ├─ OpenClipboard()             [User32]
           ├─ GetClipboardData(CF_BITMAP) [User32]
           ├─ GdipCreateBitmapFromHBITMAP [GDI+]
           └─ CloseClipboard()            [User32]

stdClipboard.Files (Get)
    │
    ├─ OpenClipboard(0)                   [User32]
    │
    ├─ GetClipboardData(CF_HDROP)         [User32]
    │
    ├─ DragQueryFileW(-1)                 [Shell32] ファイル数取得
    │
    ├─ DragQueryFileW(i)                  [Shell32] 各ファイルパス取得
    │      └─ ループ処理
    │
    └─ CloseClipboard()                   [User32]

stdClipboard.Clear()
    │
    ├─ OpenClipboard(0)                   [User32]
    │
    ├─ EmptyClipboard()                   [User32]
    │
    └─ CloseClipboard()                   [User32]
```

### データフロー図

```
[入力]                    [処理]                         [出力]

VBA文字列 ────────────▶ HTMLDocument ─────────────▶ Windowsクリップボード
                         SetData("text")

Windowsクリップボード ──▶ HTMLDocument ─────────────▶ VBA文字列
                         GetData("text")

stdImageオブジェクト ───▶ stdImage.toClipboard() ───▶ Windowsクリップボード
                         (GDI+経由)

Windowsクリップボード ──▶ stdImage.CreateFromClipboard ▶ stdImageオブジェクト
(CF_BITMAP)              (GDI+経由)

Windowsクリップボード ──▶ DragQueryFileW ─────────▶ String()配列
(CF_HDROP)               ループ処理
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| stdClipboard.cls | `src/stdClipboard.cls` | ソース | クリップボード管理クラス本体 |
| stdImage.cls | `src/stdImage.cls` | ソース | 画像操作クラス（Image連携） |
