# 機能設計書 13-stdAcc

## 概要

本ドキュメントは、stdVBAライブラリのアクセシビリティクラス「stdAcc」の機能設計を記載する。stdAccは、Microsoft Active Accessibility（MSAA）およびUI Automation（UIA）APIを活用して、Windows UIコントロールへのアクセスと操作を行うためのラッパークラスである。

### 本機能の処理概要

stdAccは、IAccessibleインターフェースを中心としたアクセシビリティAPIをVBAから利用可能にするクラスモジュールである。

**業務上の目的・背景**：VBAアプリケーションから他のWindowsアプリケーションのUI要素にアクセスし、自動操作を行う必要があるケースに対応する。デスクトップ自動化、UIテスト、スクリーンリーダー連携などの高度な自動化シナリオを実現する。

**機能の利用シーン**：
- 外部アプリケーションのボタンクリックや入力フィールドへの自動入力
- ウィンドウ内のUIツリー走査と特定要素の検索
- Excel以外のアプリケーションとのデータ連携自動化
- アクセシビリティ情報を活用したUI自動テスト

**主要な処理内容**：
1. ウィンドウハンドルからのアクセシビリティオブジェクト取得（CreateFromHwnd）
2. デスクトップ/フォアグラウンドウィンドウからの取得（CreateFromDesktop/CreateFromFocus）
3. スクリーン座標からの要素取得（CreateFromPoint）
4. UIツリー走査とクエリ検索（FindFirst、FindAll）
5. UI要素への操作（DoDefaultAction、SetValue、Select等）
6. プロパティの取得（Name、Role、State、Location等）

**関連システム・外部連携**：Windows oleacc.dll（MSAA）、UIAutomation COM

**権限による制御**：UIACCESSマニフェスト設定により、一部の保護されたUIへのアクセスが制限される

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | なし | - | VBAライブラリクラスのため画面連携なし |

## 機能種別

ユーティリティ機能 / システム操作 / UIアクセシビリティ

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| hwnd | LongPtr | Yes | ウィンドウハンドル（CreateFromHwnd） | 有効なハンドル |
| iChild | Long | No | 子要素ID（既定: CHILDID_SELF） | Long型 |
| x, y | Long | Yes | スクリーン座標（CreateFromPoint） | スクリーン範囲内 |
| query | stdICallable | Yes | 検索条件（FindFirst/FindAll） | stdICallable実装 |
| sPath | String | Yes | パス文字列（CreateFromPath） | 有効なパス形式 |

### 入力データソース

- ウィンドウハンドル（HWND）
- スクリーン座標（X, Y）
- stdICallable実装のクエリ条件
- パス文字列（子要素への相対パス）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Name | String | 要素の名前 |
| Role | Long | 要素の役割（EAccRole列挙型） |
| RoleName | String | 役割の表示名 |
| State | Long | 要素の状態（EAccState列挙型） |
| Description | String | 要素の説明 |
| Value | String | 要素の値 |
| DefaultAction | String | 既定のアクション名 |
| KeyboardShortcut | String | キーボードショートカット |
| Location | Object | 要素の位置とサイズ（x, y, w, h） |
| hwnd | LongPtr | 要素のウィンドウハンドル |
| ChildCount | Long | 子要素の数 |
| Children | Collection | 子要素のコレクション |
| Parent | stdAcc | 親要素 |

### 出力先

VBAオブジェクトのプロパティとしてメモリ内に保持

## 処理フロー

### 処理シーケンス

```
1. オブジェクト取得（CreateFromHwnd）
   └─ AccessibleObjectFromWindow APIでIAccessible取得

2. デスクトップ取得（CreateFromDesktop）
   └─ GetDesktopWindow → AccessibleObjectFromWindow

3. 座標からの取得（CreateFromPoint）
   └─ AccessibleObjectFromPoint API

4. 要素検索（FindFirst/FindAll）
   └─ UIツリー再帰走査 → クエリ評価

5. アクション実行（DoDefaultAction）
   └─ IAccessible::accDoDefaultAction

6. 値設定（SetValue）
   └─ IAccessible::set_accValue
```

### フローチャート

```mermaid
flowchart TD
    A[CreateFromHwnd] --> B[AccessibleObjectFromWindow]
    B --> C[IAccessible取得]
    C --> D[protInit]
    D --> E[stdAccオブジェクト]

    F[FindFirst] --> G[Children取得]
    G --> H{クエリマッチ?}
    H -->|Yes| I[stdAcc返却]
    H -->|No| J[子要素に再帰]
    J --> G

    K[DoDefaultAction] --> L[IAccessible::accDoDefaultAction]
    L --> M[アクション実行完了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | IAccessibleラッパー | COMオブジェクトをstdAccでラップ | オブジェクト取得時 |
| BR-02 | 再帰的UIツリー走査 | 深さ優先でUIツリーを走査 | FindFirst/FindAll時 |
| BR-03 | CHILDID_SELF | 子ID 0は自身を指す | iChild省略時 |

### アクセシビリティ役割定数（EAccRole）

| 定数名 | 値 | 説明 |
|--------|-----|------|
| ROLE_TITLEBAR | 1 | タイトルバー |
| ROLE_MENUBAR | 2 | メニューバー |
| ROLE_SCROLLBAR | 3 | スクロールバー |
| ROLE_GRIP | 4 | グリップ |
| ROLE_WINDOW | 9 | ウィンドウ |
| ROLE_CLIENT | 10 | クライアント領域 |
| ROLE_PUSHBUTTON | 43 | プッシュボタン |
| ROLE_CHECKBUTTON | 44 | チェックボックス |
| ROLE_RADIOBUTTON | 45 | ラジオボタン |
| ROLE_COMBOBOX | 46 | コンボボックス |
| ROLE_TEXT | 42 | テキスト |
| ROLE_LISTITEM | 34 | リストアイテム |
| ROLE_TREEITEM | 36 | ツリーアイテム |

### アクセシビリティ状態定数（EAccState）

| 定数名 | 値 | 説明 |
|--------|-----|------|
| STATE_UNAVAILABLE | &H1 | 使用不可 |
| STATE_SELECTED | &H2 | 選択済み |
| STATE_FOCUSED | &H4 | フォーカスあり |
| STATE_PRESSED | &H8 | 押下中 |
| STATE_CHECKED | &H10 | チェック済み |
| STATE_INVISIBLE | &H8000 | 非表示 |
| STATE_OFFSCREEN | &H10000 | 画面外 |

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | なし | - | データベース操作なし |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | COM例外 | IAccessible取得失敗 | On Error Resume Nextで保護 |
| - | ウィンドウ不在 | 無効なHWND指定 | Nothing返却 |
| 1 | 検索失敗 | FindFirstで要素が見つからない | Nothing返却またはエラー |
| 1 | QueryInterface失敗 | 要求インターフェースが未サポート | エラー発生 |

### リトライ仕様

明示的なリトライ仕様なし。UIが動的に変化する場合は呼び出し側で再試行

## トランザクション仕様

該当なし（メモリ内操作のみ）

## パフォーマンス要件

- FindAll: UIツリー全体を走査するため、深いツリーでは時間がかかる
- Highlight: 一時的な描画オーバーレイのためパフォーマンス影響あり

## セキュリティ考慮事項

- 他アプリケーションのUIにアクセスするため、セキュリティソフトウェアにブロックされる可能性
- UACで保護されたアプリケーション（管理者権限で実行中）へのアクセスは制限される
- 機密情報を含むUI要素（パスワードフィールド等）への不正アクセスに注意

## 備考

- Mac環境では動作しない（MSAA/UIA非対応）
- VBA7/64bit対応の条件付きコンパイルあり
- PredeclaredId属性により、stdAcc.CreateFromDesktopのように直接アクセス可能
- stdLambdaと組み合わせて複雑な検索条件を記述可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

アクセシビリティ関連の型定義と列挙型を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | stdAcc.cls | `src/stdAcc.cls` | EAccRole列挙型でUI要素の役割を理解 |
| 1-2 | stdAcc.cls | `src/stdAcc.cls` | EAccState列挙型で要素の状態フラグを理解 |
| 1-3 | stdAcc.cls | `src/stdAcc.cls` | TThis型でインスタンス状態管理を理解 |

**読解のコツ**: EAccRoleの値はMSAAの標準役割定数。RoleNameプロパティで人間可読な名前に変換される。

#### Step 2: エントリーポイントを理解する

コンストラクタメソッドがエントリーポイントとなる。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | stdAcc.cls | `src/stdAcc.cls` | CreateFromHwnd - ウィンドウハンドルからの取得 |
| 2-2 | stdAcc.cls | `src/stdAcc.cls` | CreateFromDesktop - デスクトップからの取得 |
| 2-3 | stdAcc.cls | `src/stdAcc.cls` | CreateFromPoint - 座標からの取得 |
| 2-4 | stdAcc.cls | `src/stdAcc.cls` | CreateFromPath - パス指定での取得 |

**主要処理フロー**:
- CreateFromHwnd: AccessibleObjectFromWindow APIでIAccessible取得
- CreateFromDesktop: GetDesktopWindow → CreateFromHwnd
- CreateFromPoint: AccessibleObjectFromPoint API

#### Step 3: プロパティ取得を理解する

IAccessibleインターフェースからのプロパティ取得パターンを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | stdAcc.cls | `src/stdAcc.cls` | Name プロパティ - IAccessible::get_accName |
| 3-2 | stdAcc.cls | `src/stdAcc.cls` | Role プロパティ - IAccessible::get_accRole |
| 3-3 | stdAcc.cls | `src/stdAcc.cls` | State プロパティ - IAccessible::get_accState |
| 3-4 | stdAcc.cls | `src/stdAcc.cls` | Location プロパティ - IAccessible::accLocation |

#### Step 4: 検索機能を理解する

UIツリー走査と検索パターンを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | stdAcc.cls | `src/stdAcc.cls` | Children プロパティ - 子要素コレクションの取得 |
| 4-2 | stdAcc.cls | `src/stdAcc.cls` | FindFirst メソッド - 条件に一致する最初の要素 |
| 4-3 | stdAcc.cls | `src/stdAcc.cls` | FindAll メソッド - 条件に一致する全要素 |

**主要処理フロー**:
- Children: IAccessible::get_accChildCount → AccessibleChildren API
- FindFirst: 深さ優先走査 → クエリ評価 → マッチしたらreturn
- FindAll: 深さ優先走査 → クエリ評価 → マッチしたらコレクションに追加

#### Step 5: アクション実行を理解する

UI操作メソッドを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | stdAcc.cls | `src/stdAcc.cls` | DoDefaultAction メソッド - 既定アクション実行 |
| 5-2 | stdAcc.cls | `src/stdAcc.cls` | SetValue メソッド - 値の設定 |
| 5-3 | stdAcc.cls | `src/stdAcc.cls` | Select メソッド - 選択操作 |
| 5-4 | stdAcc.cls | `src/stdAcc.cls` | Highlight メソッド - ビジュアルハイライト |

### プログラム呼び出し階層図

```
stdAcc.CreateFromHwnd(hwnd, iChild)
    │
    ├─ AccessibleObjectFromWindow()      [oleacc.dll]
    │      └─ IAccessible取得
    │
    └─ protInit(IAccessible, iChild)
           └─ This構造体に格納

stdAcc.CreateFromDesktop()
    │
    ├─ GetDesktopWindow()                [User32]
    │
    └─ CreateFromHwnd(hwnd)

stdAcc.FindFirst(query)
    │
    ├─ query.Run(Me)                     [stdICallable]
    │      └─ マッチ判定
    │
    └─ Children走査（再帰）
           ├─ AccessibleChildren()       [oleacc.dll]
           │
           └─ 各子要素.FindFirst(query)

stdAcc.DoDefaultAction()
    │
    └─ IAccessible::accDoDefaultAction() [COM]
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ウィンドウハンドル ─────▶ AccessibleObjectFromWindow ──▶ IAccessible
     │                         │                            │
     │                         ▼                            │
     │                    protInit()                        │
     │                         │                            │
     └─────────────────────────┼────────────────────────────▶ stdAccオブジェクト
                               │
                               ▼
                         プロパティ取得
                    (Name, Role, State, Location等)
                               │
                               ▼
                         検索/操作
                    (FindFirst, DoDefaultAction等)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| stdAcc.cls | `src/stdAcc.cls` | ソース | アクセシビリティクラス本体 |
| stdICallable.cls | `src/stdICallable.cls` | インターフェース | FindFirst/FindAllのクエリ条件 |
| stdLambda.cls | `src/stdLambda.cls` | ソース | クエリ条件の簡易記述に使用 |
| stdEnumerator.cls | `src/stdEnumerator.cls` | ソース | コレクション列挙サポート |
