# 機能設計書 14-stdWebSocket

## 概要

本ドキュメントは、stdVBAライブラリのWebSocket通信クラス「stdWebSocket」の機能設計を記載する。stdWebSocketは、Internet Explorer（IE）内蔵のWebSocket APIを活用して、VBAからリアルタイム双方向通信を実現するクラスである。

### 本機能の処理概要

stdWebSocketは、非表示のIEインスタンスを介してJavaScriptのWebSocket APIにアクセスし、VBAからWebSocket通信機能を提供するクラスモジュールである。

**業務上の目的・背景**：VBAアプリケーションでリアルタイムデータストリーミングや双方向通信が必要なケースに対応する。ストック価格のライブフィード、チャットシステム、IoTデバイス連携など、プッシュ型通信シナリオを実現する。

**機能の利用シーン**：
- リアルタイムの株価・為替データをExcelに取り込む
- チャットボットとの双方向通信
- サーバーからのプッシュ通知の受信
- WebSocketベースのAPIとの連携

**主要な処理内容**：
1. WebSocket接続の作成（Create）
2. メッセージの送信（Send）
3. 接続の終了（CloseSocket、Disconnect）
4. イベントハンドリング（OnOpen、OnClose、OnError、OnMessage）
5. イベントリスナーの登録

**関連システム・外部連携**：Internet Explorer COM、JavaScript WebSocket API

**権限による制御**：ネットワーク通信のため、ファイアウォール設定に依存

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | なし | - | VBAライブラリクラスのため画面連携なし |

## 機能種別

ユーティリティ機能 / ネットワーク通信 / WebSocket

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| url | String | Yes | WebSocket接続先URL | ws://またはwss://で始まる |
| data | Variant | Yes | 送信データ（Sendメソッド） | 任意のデータ |
| Code | Long | No | 終了コード（既定: 1000） | RFC 6455準拠のコード |
| reason | String | No | 終了理由 | 任意の文字列 |

### 入力データソース

- WebSocket URL（接続先サーバー）
- 送信データ（文字列またはJSONシリアライズ可能なデータ）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| url | String | 接続先WebSocket URL |
| Listeners | Collection | イベントリスナーコレクション |

### イベント

| イベント名 | 説明 | パラメータ |
|-----------|------|-----------|
| OnOpen | 接続成功時に発火 | eventData |
| OnClose | 接続終了時に発火 | eventData |
| OnError | エラー発生時に発火 | eventData |
| OnMessage | メッセージ受信時に発火 | eventData |
| EventRaised | 全イベントで発火 | sEventName, eventData |

### 出力先

VBAイベントおよびリスナーコレクション経由でのコールバック

## 処理フロー

### 処理シーケンス

```
1. WebSocket作成（Create）
   └─ new stdWebSocket → protInit(url)

2. 初期化（protInit）
   ├─ IEインスタンス作成
   ├─ 空のHTMLページにナビゲート
   ├─ JavaScriptでbind関数を定義
   ├─ VBオブジェクトとURLをバインド
   └─ WebSocketオブジェクト作成＆イベントハンドラ設定

3. メッセージ送信（Send）
   └─ document.ws.Send(data)

4. 接続終了（CloseSocket）
   └─ document.ws.Close(code, reason)

5. 完全終了（Disconnect）
   ├─ CloseSocket()
   ├─ VBオブジェクトのバインド解除
   └─ IE終了
```

### フローチャート

```mermaid
flowchart TD
    A[Create] --> B[new stdWebSocket]
    B --> C[protInit]
    C --> D[IEインスタンス作成]
    D --> E[空ページにナビゲート]
    E --> F[bind関数定義]
    F --> G[VBオブジェクト/URLバインド]
    G --> H[WebSocketオブジェクト作成]
    H --> I[イベントハンドラ設定]
    I --> J[接続完了]

    K[Send] --> L[document.ws.Send]

    M[handleEvent] --> N{イベント種別}
    N -->|Open| O[RaiseEvent OnOpen]
    N -->|Close| P[RaiseEvent OnClose]
    N -->|Error| Q[RaiseEvent OnError]
    N -->|Message| R[RaiseEvent OnMessage]

    S[Disconnect] --> T[CloseSocket]
    T --> U[バインド解除]
    U --> V[IE終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | IE依存 | 非表示のIEインスタンスを使用 | 全機能 |
| BR-02 | JavaScript Bridge | VBオブジェクトをJavaScriptにバインド | protInit時 |
| BR-03 | イベント伝播 | handleEventで全イベントをVBAに伝播 | イベント発生時 |
| BR-04 | リスナーパターン | stdICallableを使用したリスナー登録 | 任意 |

### WebSocket終了コード

| コード | 説明 |
|--------|------|
| 1000 | 正常終了 |
| 1001 | Going Away（サーバーシャットダウン等） |
| 1002 | プロトコルエラー |
| 1003 | サポートされないデータ型 |
| 1005 | 終了コード未指定（既定） |
| 1006 | 異常終了（接続断） |
| 1007 | 不正なデータ |
| 1008 | ポリシー違反 |
| 1009 | メッセージが大きすぎる |
| 1010 | 必須の拡張機能が欠如 |
| 1011 | サーバー内部エラー |

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | なし | - | データベース操作なし |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | IE作成失敗 | IEが無効化されている環境 | EdgeやChrome代替を検討 |
| - | 接続失敗 | サーバー未応答、URLエラー | OnErrorイベントで検知 |
| - | 送信失敗 | 未接続状態での送信 | OnOpenを待ってから送信 |

### リトライ仕様

明示的なリトライ仕様なし。OnError/OnCloseイベントで再接続ロジックを実装可能

## トランザクション仕様

該当なし（ネットワーク通信）

## パフォーマンス要件

- IEインスタンス作成のオーバーヘッドあり（数百ミリ秒）
- readyState監視のためのDoEventsループあり
- 非同期イベントドリブンのためメインスレッドをブロックしない

## セキュリティ考慮事項

- wss://（TLS暗号化）の使用を推奨
- 信頼できるWebSocketサーバーへの接続のみを行う
- 受信データのバリデーションを呼び出し側で実施
- IEセキュリティゾーン設定の影響を受ける

## 備考

- Mac環境では動作しない（IE非対応）
- Windows 11以降ではIEが無効化されているため動作しない可能性
- PredeclaredId属性により、stdWebSocket.Createのように直接アクセス可能
- stdICallable実装のリスナーを登録可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: クラス構造を理解する

モジュールレベル変数とイベント宣言を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | stdWebSocket.cls | `src/stdWebSocket.cls` 37-61行目 | イベント宣言（EventRaised, OnOpen, OnClose, OnError, OnMessage） |
| 1-2 | stdWebSocket.cls | `src/stdWebSocket.cls` 57-60行目 | モジュールレベル変数（ie, document, pURL, Listeners） |

**読解のコツ**: VBAのPublic Eventは呼び出し側でWithEventsを使って購読する。

#### Step 2: エントリーポイントを理解する

Create関数とprotInit処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | stdWebSocket.cls | `src/stdWebSocket.cls` 67-70行目 | Create関数 |
| 2-2 | stdWebSocket.cls | `src/stdWebSocket.cls` 78-119行目 | protInit関数の全体構造 |

**主要処理フロー**:
- **80行目**: IEインスタンス作成 `CreateObject("InternetExplorer.Application")`
- **83-86行目**: 空ページにナビゲート＆待機
- **92-95行目**: JavaScriptでbind関数を定義
- **98-101行目**: VBオブジェクトとURLをバインド
- **112-117行目**: WebSocketオブジェクト作成＆イベントハンドラ設定

#### Step 3: 通信機能を理解する

Send、CloseSocket、Disconnectを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | stdWebSocket.cls | `src/stdWebSocket.cls` 129-131行目 | Send メソッド |
| 3-2 | stdWebSocket.cls | `src/stdWebSocket.cls` 136-138行目 | CloseSocket メソッド |
| 3-3 | stdWebSocket.cls | `src/stdWebSocket.cls` 141-145行目 | Disconnect メソッド |

**主要処理フロー**:
- **130行目**: `document.ws.Send(data)` でJavaScript側に送信委譲
- **137行目**: `document.ws.Close(Code, reason)` で接続終了
- **142-144行目**: CloseSocket → バインド解除 → IE終了

#### Step 4: イベントハンドリングを理解する

handleEvent関数でのイベント伝播パターンを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | stdWebSocket.cls | `src/stdWebSocket.cls` 152-167行目 | handleEvent関数 |

**主要処理フロー**:
- **153行目**: RaiseEvent EventRaised で汎用イベント発火
- **154-159行目**: イベント種別に応じた個別イベント発火
- **161-166行目**: Listenersコレクションの各リスナーを呼び出し

### プログラム呼び出し階層図

```
stdWebSocket.Create(url)
    │
    └─ protInit(url)
           │
           ├─ CreateObject("InternetExplorer.Application")
           │
           ├─ ie.navigate("about:<!DOCTYPE html>...")
           │
           ├─ document.createElement("script")  [bind関数定義]
           │      └─ document.body.appendChild(scpt)
           │
           ├─ document.Bind("vb_obj", Me)       [VBオブジェクトバインド]
           ├─ document.Bind("websocket_url", url)
           │
           └─ document.createElement("script")  [WebSocket作成]
                  │
                  └─ new WebSocket(websocket_url)
                         ├─ ws.onopen = vb_obj.handleEvent
                         ├─ ws.onclose = vb_obj.handleEvent
                         ├─ ws.onerror = vb_obj.handleEvent
                         └─ ws.onmessage = vb_obj.handleEvent

stdWebSocket.Send(data)
    │
    └─ document.ws.Send(data)           [JavaScript]

stdWebSocket.handleEvent(sEventName, oEventData)
    │
    ├─ RaiseEvent EventRaised(...)      [VBA]
    │
    ├─ RaiseEvent OnOpen/OnClose/OnError/OnMessage(...)
    │
    └─ For Each listener In Listeners
           └─ listener.Run(sEventName, oEventData)
```

### データフロー図

```
[VBA側]                   [JavaScript側]                [サーバー側]

stdWebSocket.Create()
       │
       ├──────▶ IEインスタンス作成
       │              │
       │              ▼
       │        WebSocketオブジェクト作成
       │              │
       │              └────────────────────────▶ WebSocket接続
       │                                                │
       │                                                │
       │◀───────────── onopen ◀────────────────────────┘
       │                                                │
Send(data) ─────────▶ ws.Send(data) ───────────────────▶ データ送信
       │                                                │
       │◀───────────── onmessage ◀─────────────────────── データ受信
       │
handleEvent()
       │
       ├─ RaiseEvent OnMessage()
       │
       └─ Listeners.Run()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| stdWebSocket.cls | `src/stdWebSocket.cls` | ソース | WebSocket通信クラス本体 |
| stdICallable.cls | `src/stdICallable.cls` | インターフェース | リスナーのインターフェース |
| stdCallback.cls | `src/stdCallback.cls` | ソース | リスナー実装に使用可能 |
| stdLambda.cls | `src/stdLambda.cls` | ソース | リスナー実装に使用可能 |
