# 機能設計書 15-stdHTTP

## 概要

本ドキュメントは、stdVBAライブラリのHTTP通信クラス「stdHTTP」の機能設計を記載する。stdHTTPは、WinHTTP APIを活用して、VBAからHTTP/HTTPSリクエストを送信するためのラッパークラスである。

### 本機能の処理概要

stdHTTPは、WinHttpRequest COMオブジェクトを使用してHTTP通信機能を提供するVBAクラスモジュールである。

**業務上の目的・背景**：VBAアプリケーションでWeb API連携やHTTPデータ取得が必要なケースに対応する。REST API呼び出し、Webスクレイピング、ファイルダウンロードなど、モダンなWeb連携シナリオを実現する。

**機能の利用シーン**：
- REST APIからJSONデータを取得してExcelに展開
- Webサービスへのデータ送信（POST/PUT）
- プロキシ経由のHTTP通信
- 認証付きAPIへのアクセス

**主要な処理内容**：
1. HTTPリクエストの作成と送信（Create）
2. 同期/非同期通信のサポート（HTTPSync/HTTPAsync）
3. レスポンスの取得（ResponseText、ResponseBody、ResponseStatus等）
4. プロキシ設定（CreateProxy）
5. カスタムヘッダー・クッキーの設定（CreateHeaders、CreateOptions）
6. 認証機能（Authenticator）
7. URLエンコード/デコード（URIEncode/URIDecode）

**関連システム・外部連携**：WinHTTP.dll、WinHttp.WinHttpRequest.5.1 COM

**権限による制御**：ネットワーク通信のため、ファイアウォール・プロキシ設定に依存

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | なし | - | VBAライブラリクラスのため画面連携なし |

## 機能種別

ユーティリティ機能 / ネットワーク通信 / HTTP

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| sURL | String | Yes | リクエスト先URL | 有効なURL形式 |
| RequestMethod | String | No | HTTPメソッド（既定: GET） | GET/POST/PUT/DELETE等 |
| ThreadingStyle | EHTTPSynchronisity | No | 同期/非同期（既定: HTTPSync） | HTTPSync/HTTPAsync |
| options | Object | No | オプション辞書 | CreateOptionsで生成 |
| Authenticator | stdICallable | No | 認証コールバック | stdICallable実装 |

### CreateOptionsパラメータ

| パラメータ名 | 型 | 既定値 | 説明 |
|-------------|-----|-------|------|
| Body | String | "" | リクエストボディ |
| Headers | Object | Nothing | ヘッダー辞書 |
| Cookies | Object | Nothing | クッキー辞書 |
| ContentTypeDefault | EHTTPContentType | 0 | Content-Type |
| Insecure | Boolean | False | SSL検証を無効化 |
| EnableRedirects | Boolean | True | リダイレクト追従 |
| TimeoutMS | Long | 5000 | タイムアウト（ミリ秒） |
| Proxy | Object | Nothing | プロキシ設定 |

### 入力データソース

- URL文字列
- リクエストボディ（POST/PUT時）
- ヘッダー・クッキー設定

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ResponseStatus | Long | HTTPステータスコード |
| ResponseStatusText | String | ステータステキスト |
| ResponseText | String | レスポンスボディ（テキスト） |
| ResponseBody | Byte() | レスポンスボディ（バイナリ） |
| ResponseHeader | Variant | 特定ヘッダーの値 |
| ResponseHeaders | Object | 全ヘッダー |
| ResponseMapped | Variant | マッピング済みレスポンス |
| isFinished | Boolean | 非同期リクエスト完了フラグ |

### 出力先

VBAオブジェクトのプロパティとしてメモリ内に保持

## 処理フロー

### 処理シーケンス

```
1. リクエスト作成（Create）
   └─ new stdHTTP → protInit

2. 初期化（protInit）
   ├─ WinHttpRequest.5.1オブジェクト作成
   ├─ Open(RequestMethod, sURL, True)
   ├─ プロキシ設定
   ├─ SSL/リダイレクト設定
   ├─ ヘッダー/クッキー設定
   ├─ 認証コールバック実行
   └─ Send(Body)

3. 非同期待機（Await）
   └─ isFinished=Trueになるまでループ

4. レスポンス取得
   └─ ResponseText/ResponseBody/ResponseStatus等
```

### フローチャート

```mermaid
flowchart TD
    A[Create] --> B[new stdHTTP]
    B --> C[protInit]
    C --> D[WinHttpRequest作成]
    D --> E[Open]
    E --> F[プロキシ設定]
    F --> G[SSL設定]
    G --> H[ヘッダー設定]
    H --> I{Authenticator?}
    I -->|Yes| J[認証コールバック]
    I -->|No| K[Send]
    J --> K
    K --> L{HTTPSync?}
    L -->|Yes| M[Await]
    L -->|No| N[返却]
    M --> N

    O[isFinished] --> P{status=202?}
    P -->|Yes| Q[True]
    P -->|No| R[WaitForResponse]
    R --> Q
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 自動プロキシ | IEプロキシ設定を自動取得 | ProxyTypeAuto時 |
| BR-02 | タイムアウト分割 | TimeoutMSを4分割して各フェーズに適用 | 全リクエスト |
| BR-03 | レスポンスマッパー | ResponseMapperでカスタム変換 | ResponseMapped取得時 |

### HTTPコンテンツタイプ（EHTTPContentType）

| 定数名 | 値 | Content-Type |
|--------|-----|--------------|
| ContentType_HTML | 1 | text/html |
| ContentType_Plain | 2 | text/plain |
| ContentType_JSON | 4 | application/json |
| ContentType_XML | 8 | application/xml; text/xml |
| ContentType_CSV | 16 | text/csv |
| ContentType_ZIP | 32 | application/zip |
| ContentType_Binary | 64 | application/octet-stream |

### プロキシタイプ（EHTTPProxyType）

| 定数名 | 説明 |
|--------|------|
| ProxyTypeAuto | システム設定を自動検出 |
| ProxyTypeManual | 手動でプロキシ指定 |
| ProxyTypeNone | プロキシを使用しない |

### WinHTTPエラーコード

| コード | 名前 | 説明 |
|--------|------|------|
| 12002 | TIMEOUT | タイムアウト |
| 12007 | NAME_NOT_RESOLVED | ホスト名解決失敗 |
| 12029 | CANNOT_CONNECT | 接続失敗 |
| 12157 | SECURE_CHANNEL_ERROR | SSL/TLSエラー |

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | なし | - | データベース操作なし |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 10000 | タイムアウト | 非同期リクエストがTimeoutMSを超過 | TimeoutMS延長またはリトライ |
| 12002 | WinHTTPタイムアウト | サーバー応答なし | ネットワーク確認 |
| 12007 | DNS解決失敗 | ホスト名が不正 | URL確認 |
| 12029 | 接続失敗 | サーバー到達不可 | ネットワーク/ファイアウォール確認 |

### リトライ仕様

明示的なリトライ仕様なし。呼び出し側でのエラーハンドリング推奨

## トランザクション仕様

該当なし（ネットワーク通信）

## パフォーマンス要件

- WinHttpRequest作成のオーバーヘッドあり
- 非同期モードではDoEventsループを使用
- 自動プロキシ検出はWPAD/DNSに依存するため遅延の可能性

## セキュリティ考慮事項

- HTTPS使用を推奨（Insecure=Falseが既定）
- 認証情報はAuthenticatorコールバック経由で安全に渡す
- プロキシ認証情報の取り扱いに注意
- SSL証明書検証を無効化（Insecure=True）は本番環境では非推奨

## 備考

- Mac環境では動作しない（WinHTTP非対応）
- VBA7/64bit対応の条件付きコンパイルあり
- PredeclaredId属性により、stdHTTP.Createのように直接アクセス可能
- stdICallable実装の認証コールバックを登録可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

列挙型とAPI宣言を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | stdHTTP.cls | `src/stdHTTP.cls` 79-96行目 | EHTTPSynchronisity, EHTTPContentType, EHTTPProxyType列挙型 |
| 1-2 | stdHTTP.cls | `src/stdHTTP.cls` 117-170行目 | WINHTTP_ERROR列挙型 |
| 1-3 | stdHTTP.cls | `src/stdHTTP.cls` 194-257行目 | WinHTTP API宣言とプロキシ構造体 |

**読解のコツ**: WINHTTP_ERRORの値はWinHTTPのエラーコードに対応。12000番台がWinHTTP固有エラー。

#### Step 2: エントリーポイントを理解する

Create関数とヘルパー関数を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | stdHTTP.cls | `src/stdHTTP.cls` 289-292行目 | Create関数 |
| 2-2 | stdHTTP.cls | `src/stdHTTP.cls` 298-309行目 | CreateHeaders関数 |
| 2-3 | stdHTTP.cls | `src/stdHTTP.cls` 322-355行目 | CreateOptions関数 |
| 2-4 | stdHTTP.cls | `src/stdHTTP.cls` 365-387行目 | CreateProxy関数 |

**主要処理フロー**:
- **289-292行目**: Create - new stdHTTP → protInit
- **322-355行目**: CreateOptions - オプション辞書の構築

#### Step 3: 初期化処理を理解する

protInit関数でのリクエスト構築を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | stdHTTP.cls | `src/stdHTTP.cls` 495-545行目 | protInit関数 |

**主要処理フロー**:
- **497行目**: WinHttpRequest.5.1オブジェクト作成
- **498行目**: Open(RequestMethod, sURL, True)
- **499行目**: タイムアウト設定
- **502-514行目**: プロキシ設定
- **516-525行目**: SSL/リダイレクト設定
- **527-533行目**: ヘッダー/クッキー設定
- **536行目**: 認証コールバック実行
- **539-541行目**: Send実行
- **544行目**: 同期モードならAwait

#### Step 4: レスポンス取得を理解する

各種レスポンスプロパティを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | stdHTTP.cls | `src/stdHTTP.cls` 391-402行目 | Await関数 |
| 4-2 | stdHTTP.cls | `src/stdHTTP.cls` 406-418行目 | isFinished プロパティ |
| 4-3 | stdHTTP.cls | `src/stdHTTP.cls` 422-454行目 | ResponseStatus/StatusText/Text/Body |
| 4-4 | stdHTTP.cls | `src/stdHTTP.cls` 474-486行目 | ResponseMapped |

#### Step 5: プロキシ自動検出を理解する

自動プロキシ検出ロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | stdHTTP.cls | `src/stdHTTP.cls` 626-643行目 | LoadAutoProxy関数 |
| 5-2 | stdHTTP.cls | `src/stdHTTP.cls` 648-758行目 | GetProxyCurrentUser関数 |

### プログラム呼び出し階層図

```
stdHTTP.Create(sURL, RequestMethod, ThreadingStyle, options, Authenticator)
    │
    └─ protInit(sURL, RequestMethod, ThreadingStyle, options, Authenticator)
           │
           ├─ CreateObject("WinHttp.WinHttpRequest.5.1")
           │
           ├─ HTTP.Open(RequestMethod, sURL, True)
           │
           ├─ HTTP.SetTimeouts(...)
           │
           ├─ LoadAutoProxy(sURL, options("Proxy"))
           │      │
           │      └─ GetProxyCurrentUser(sURL)
           │             ├─ WinHttpGetIEProxyConfigForCurrentUser()  [WinHTTP]
           │             └─ WinHttpGetProxyForUrl()                   [WinHTTP]
           │
           ├─ HTTP.SetProxy(...)
           │
           ├─ HTTP.Option(SslErrorIgnoreFlags) = ...
           │
           ├─ HTTP.SetRequestHeader(...) ループ
           │
           ├─ Authenticator.Run(...)                [stdICallable]
           │
           └─ HTTP.Send(Body)

stdHTTP.Await()
    │
    └─ While Not isFinished
           ├─ DateDiff タイムアウトチェック
           └─ DoEvents
```

### データフロー図

```
[入力]                    [処理]                         [出力]

URL/Method/Options ─────▶ protInit()
       │                      │
       │                      ├─ WinHttpRequest作成
       │                      │
       │                      ├─ プロキシ設定
       │                      │      └─ GetProxyCurrentUser()
       │                      │
       │                      ├─ ヘッダー/クッキー設定
       │                      │
       │                      └─ Send(Body)
       │                             │
       │                             ▼
       │                      HTTPリクエスト送信
       │                             │
       │                             ▼
       └─────────────────────▶ HTTPレスポンス受信
                                     │
                                     ▼
                              ResponseText
                              ResponseBody
                              ResponseStatus
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| stdHTTP.cls | `src/stdHTTP.cls` | ソース | HTTP通信クラス本体 |
| stdICallable.cls | `src/stdICallable.cls` | インターフェース | 認証コールバック/レスポンスマッパー |
| stdCallback.cls | `src/stdCallback.cls` | ソース | 認証コールバック実装に使用可能 |
| stdLambda.cls | `src/stdLambda.cls` | ソース | レスポンスマッパー実装に使用可能 |
| stdJSON.cls | `src/stdJSON.cls` | ソース | JSONレスポンスのパースに使用可能 |
