# 機能設計書 16-stdCOM

## 概要

本ドキュメントは、stdVBAライブラリのCOMオブジェクト操作クラス「stdCOM」の機能設計を記載する。stdCOMは、低レベルCOM操作をVBAから行うためのラッパークラスであり、IUnknown/IDispatchインターフェースへの直接アクセス、VTable呼び出し、型情報の取得などの高度なCOM操作を可能にする。

### 本機能の処理概要

stdCOMは、COM（Component Object Model）の低レベルAPIをVBAから利用可能にするクラスモジュールである。

**業務上の目的・背景**：VBAの標準機能では対応できない高度なCOM操作が必要なケースに対応する。カスタムインターフェースの呼び出し、ROT（Running Object Table）へのオブジェクト登録、型情報のリフレクションなど、システムプログラミングレベルの機能を提供する。

**機能の利用シーン**：
- VBAで直接呼び出せないCOMインターフェースメソッドの実行
- 実行中のCOMオブジェクト（ROT）へのアクセス
- オブジェクトの型情報（メソッド・プロパティ一覧）の取得
- WinRT APIへのアクセス
- タスクバープログレスなどのカスタムCOM機能の利用

**主要な処理内容**：
1. COMオブジェクトのラッピング（Create、CreateFromPtr）
2. QueryInterfaceによるインターフェース取得（unkQueryInterface）
3. VTable直接呼び出し（CallVT）
4. 型情報の取得（TypeInfo、InterfaceInfo、Methods、Properties）
5. ROTへの登録・取得（RegisterActiveObject、CreateFromActiveObjects）
6. WinRT/CLSIDからのオブジェクト作成（CreateFromWinRTClassID、CreateFromClassAndIID）
7. IPropertyStore操作（PropertyStore_*メソッド）

**関連システム・外部連携**：Windows OLE32.dll、oleAut32.dll、Combase.dll、Shell32.dll

**権限による制御**：ROT登録にはプロセス間通信権限が必要

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | なし | - | VBAライブラリクラスのため画面連携なし |

## 機能種別

ユーティリティ機能 / システム操作 / COMインフラストラクチャ

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| obj | IUnknown | Yes | ラップするCOMオブジェクト | 有効なCOMオブジェクト |
| ptr | LongPtr | Yes | オブジェクトポインタ | 有効なメモリアドレス |
| sIID | String | Yes | インターフェースID（GUID形式） | GUID形式文字列 |
| sClassID | String | Yes | クラスID（GUID形式） | GUID形式文字列 |
| VTableOffset | Long | Yes | VTableオフセット | 0以上の整数 |
| ReturnType | VbVarType | Yes | 戻り値の型 | VbVarType列挙値 |

### 入力データソース

- VBAオブジェクト参照
- メモリポインタ（ObjPtr等から取得）
- GUID文字列（インターフェースID、クラスID）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Object | IUnknown | ラップされた生のCOMオブジェクト |
| AsObject | Object | IDispatch経由のオブジェクト |
| Pointer | LongPtr | オブジェクトポインタ |
| TypeInfo | stdCOM | ITypeInfo COMラッパー |
| InterfaceInfo | Collection | メソッド/プロパティ情報コレクション |
| Methods | Collection | メソッド名コレクション |
| Properties | Collection | プロパティ名コレクション |

### 出力先

VBAオブジェクトのプロパティとしてメモリ内に保持

## 処理フロー

### 処理シーケンス

```
1. オブジェクトラッピング（Create/CreateFromPtr）
   └─ protInit* でポインタ保持

2. インターフェース取得（unkQueryInterface）
   └─ CallVT(QueryInterface) → stdCOM返却

3. VTable呼び出し（CallVT）
   └─ DispCallFunc API呼び出し

4. 型情報取得（TypeInfo/InterfaceInfo）
   └─ IDispatch::GetTypeInfo → ITypeInfo操作

5. ROT操作（RegisterActiveObject/CreateFromActiveObjects）
   └─ RegisterActiveObject/GetRunningObjectTable API
```

### フローチャート

```mermaid
flowchart TD
    A[Create] --> B[protInitFromObject]
    B --> C[ObjPtr保存]
    C --> D[stdCOMオブジェクト]

    E[CreateFromPtr] --> F[protInitFromPtr]
    F --> G[unkAddRef]
    G --> D

    H[unkQueryInterface] --> I[CallVT QueryInterface]
    I --> J{S_OK?}
    J -->|Yes| K[新しいstdCOM返却]
    J -->|No| L[エラー/Nothing]

    M[CallVT] --> N[パラメータ配列構築]
    N --> O[DispCallFunc]
    O --> P[結果返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 参照カウント管理 | CreateFromPtrではAddRef、Class_TerminateではRelease | ポインタからの作成時 |
| BR-02 | VTableオフセット計算 | オフセット×ポインタサイズでアドレス計算 | CallVT時 |
| BR-03 | GUID形式 | {xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx}形式 | インターフェースID指定時 |

### 既知のインターフェース（EKnownInterfaces）

| 定数名 | IID | 説明 |
|--------|-----|------|
| IUnknown | 00000000-0000-0000-C000-000000000046 | 基本インターフェース |
| IDispatch | 00020400-0000-0000-C000-000000000046 | オートメーションインターフェース |
| ITypeInfo | 00020401-0000-0000-C000-000000000046 | 型情報 |
| IEnumVARIANT | 00020404-0000-0000-C000-000000000046 | バリアント列挙 |
| IRunningObjectTable | 00000010-0000-0000-C000-000000000046 | ROT |
| IMoniker | 0000000F-0000-0000-C000-000000000046 | モニカー |
| IPropertyStore | 886D8EEB-8CF2-4446-8D02-CDBA1DBDCF99 | プロパティストア |

### IUnknownインターフェース（EIUnknown）

| オフセット | メソッド | 説明 |
|-----------|---------|------|
| 0 | QueryInterface | インターフェース取得 |
| 1 | AddRef | 参照カウント増加 |
| 2 | Release | 参照カウント減少 |

### IDispatchインターフェース（EIDispatch）

| オフセット | メソッド | 説明 |
|-----------|---------|------|
| 0-2 | (IUnknown) | 継承 |
| 3 | GetTypeInfoCount | 型情報数取得 |
| 4 | GetTypeInfo | 型情報取得 |
| 5 | GetIDsOfNames | DispID取得 |
| 6 | Invoke | メソッド呼び出し |

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | なし | - | データベース操作なし |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E_NOINTERFACE | QueryInterface失敗 | インターフェース未サポート | 別インターフェースを試行 |
| E_POINTER | ポインタエラー | 無効なポインタ | Nothing返却 |
| 1 | CreateFromClassAndIID失敗 | CLSID/IIDが無効 | GUID形式を確認 |
| 1 | CreateFromWinRTClassID失敗 | WinRT ClassIDが無効 | ClassID確認 |
| hResult | DispCallFunc失敗 | VTable呼び出しエラー | パラメータ確認 |

### リトライ仕様

明示的なリトライ仕様なし

## トランザクション仕様

該当なし（メモリ内操作のみ）

## パフォーマンス要件

- InterfaceInfo: 全メソッド列挙のためオーバーヘッドあり（50件ごとにDoEvents）
- DispCallFunc: ネイティブAPI呼び出しのため高速

## セキュリティ考慮事項

- 無効なポインタへのアクセスはアプリケーションクラッシュを引き起こす可能性
- ROT登録されたオブジェクトは他プロセスからアクセス可能
- システムCOMオブジェクトへのアクセスには管理者権限が必要な場合あり

## 備考

- Mac環境では動作しない（COM非対応）
- VBA7/64bit対応の条件付きコンパイルあり（PTRSIZE定数で切り替え）
- PredeclaredId属性により、stdCOM.Createのように直接アクセス可能
- 上級者向け機能のため、誤用によるメモリ破壊に注意

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

GUID構造体とインターフェース列挙型を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | stdCOM.cls | `src/stdCOM.cls` 150-156行目 | GUID構造体 |
| 1-2 | stdCOM.cls | `src/stdCOM.cls` 238-302行目 | EKnownInterfaces列挙型 |
| 1-3 | stdCOM.cls | `src/stdCOM.cls` 316-338行目 | EIUnknown, EIDispatch列挙型 |
| 1-4 | stdCOM.cls | `src/stdCOM.cls` 389-430行目 | EIRunningObjectTable, EIEnumMoniker列挙型 |

**読解のコツ**: 列挙型の値はVTableオフセット。IUnknownの0,1,2を基準にIDispatchは3から始まる。

#### Step 2: コンストラクタを理解する

各種Createメソッドを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | stdCOM.cls | `src/stdCOM.cls` 577-580行目 | Create関数 |
| 2-2 | stdCOM.cls | `src/stdCOM.cls` 589-596行目 | CreateFromPtr関数 |
| 2-3 | stdCOM.cls | `src/stdCOM.cls` 603-655行目 | CreateFromActiveObjects関数 |
| 2-4 | stdCOM.cls | `src/stdCOM.cls` 664-677行目 | CreateFromWinRTClassID関数 |
| 2-5 | stdCOM.cls | `src/stdCOM.cls` 688-697行目 | CreateFromClassAndIID関数 |

**主要処理フロー**:
- **577-580行目**: Create - オブジェクトからのラッピング
- **589-596行目**: CreateFromPtr - ポインタからのラッピング（AddRef呼び出し）
- **603-655行目**: CreateFromActiveObjects - ROT列挙

#### Step 3: IUnknown操作を理解する

QueryInterface、AddRef、Release操作を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | stdCOM.cls | `src/stdCOM.cls` 780-801行目 | unkQueryInterface関数 |
| 3-2 | stdCOM.cls | `src/stdCOM.cls` 804-806行目 | unkAddRef関数 |
| 3-3 | stdCOM.cls | `src/stdCOM.cls` 809-811行目 | unkRelease関数 |

**主要処理フロー**:
- **784行目**: CallVT(EIUnknown.QueryInterface, vbLong, VarPtr(tGUID), VarPtr(IInterface))
- **805行目**: CallVT EIUnknown.AddRef, vbLong
- **810行目**: CallVT EIUnknown.Release, vbLong

#### Step 4: VTable呼び出しを理解する

DispCallFuncを使用したVTable直接呼び出しを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | stdCOM.cls | `src/stdCOM.cls` 1040-1075行目 | CallVT関数 |

**主要処理フロー**:
- **1042-1043行目**: パラメータ配列の構築
- **1054-1066行目**: 型配列とポインタ配列の構築
- **1070行目**: DispCallFunc呼び出し

#### Step 5: 型情報取得を理解する

ITypeInfoを使用したリフレクション機能を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | stdCOM.cls | `src/stdCOM.cls` 834-851行目 | TypeInfoプロパティ |
| 5-2 | stdCOM.cls | `src/stdCOM.cls` 855-914行目 | InterfaceInfoプロパティ |
| 5-3 | stdCOM.cls | `src/stdCOM.cls` 918-930行目 | Methodsプロパティ |
| 5-4 | stdCOM.cls | `src/stdCOM.cls` 940-966行目 | Propertiesプロパティ |

### プログラム呼び出し階層図

```
stdCOM.Create(obj)
    │
    └─ protInitFromObject(obj)
           └─ ObjPtr(obj) → This.ObjPtr

stdCOM.CreateFromPtr(ptr, bAddRef)
    │
    ├─ protInitFromPtr(ptr, bAddRef)
    │      └─ ptr → This.ObjPtr
    │
    └─ unkAddRef()                       [bAddRef=True時]
           └─ CallVT(EIUnknown.AddRef)

stdCOM.unkQueryInterface(sIID)
    │
    ├─ IIDFromString(StrPtr(sIID), tGUID) [ole32.dll]
    │
    └─ CallVT(EIUnknown.QueryInterface, ...)
           │
           └─ DispCallFunc(...)           [oleAut32.dll]
                  │
                  └─ IUnknown::QueryInterface [COM VTable]

stdCOM.CallVT(VTableOffset, ReturnType, params...)
    │
    ├─ パラメータ配列構築
    │      ├─ vType() - 型配列
    │      └─ vPtr() - ポインタ配列
    │
    └─ DispCallFunc(This.ObjPtr, VTableOffset * PTRSIZE, ...)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

VBAオブジェクト ─────────▶ Create()
     │                         │
     │                         ▼
     │                    ObjPtr取得
     │                         │
     └─────────────────────────┼───────────────────────▶ stdCOMオブジェクト
                               │
                               ▼
                         CallVT()
                               │
                    ┌──────────┼──────────┐
                    ▼          ▼          ▼
              QueryInterface  AddRef    Invoke
                    │          │          │
                    ▼          ▼          ▼
              DispCallFunc DispCallFunc DispCallFunc
                    │          │          │
                    ▼          ▼          ▼
               COM VTable  COM VTable  COM VTable
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| stdCOM.cls | `src/stdCOM.cls` | ソース | COMオブジェクト操作クラス本体 |
