# 機能設計書 17-stdReg

## 概要

本ドキュメントは、stdVBAライブラリのレジストリ操作クラス「stdReg」の機能設計を記載する。stdRegは、Windowsレジストリの読み書きをVBAから行うためのラッパークラスである。

### 本機能の処理概要

stdRegは、Windows advapi32.dll APIを活用してレジストリ操作機能を提供するVBAクラスモジュールである。

**業務上の目的・背景**：VBAアプリケーションでWindowsレジストリにアクセスする必要があるケースに対応する。アプリケーション設定の保存・読み込み、インストール情報の確認、システム設定の参照など、Windows環境との深い連携を実現する。

**機能の利用シーン**：
- アプリケーション固有の設定値をレジストリに保存・読み込み
- インストールされているソフトウェアのバージョン確認
- ファイル関連付け情報の取得
- 環境固有の設定値（プロキシ設定等）の取得

**主要な処理内容**：
1. レジストリキーのオープン・作成（Create、CreateKey）
2. 値の読み取り（Value）
3. 値の書き込み（CreateValue）
4. サブキーの列挙（SubKeys）
5. 値名の列挙（ValueNames）
6. キー・値の削除（DeleteKey、DeleteValue）

**関連システム・外部連携**：Windows advapi32.dll API

**権限による制御**：HKEY_LOCAL_MACHINE等への書き込みには管理者権限が必要

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | なし | - | VBAライブラリクラスのため画面連携なし |

## 機能種別

ユーティリティ機能 / システム操作 / レジストリ管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| sPath | String | Yes | レジストリパス | 有効なパス形式 |
| iAccess | ERegistryAccess | No | アクセスモード（既定: KEY_READ） | 列挙値 |
| sName | String | Yes | 値名 | 空文字列は既定値を示す |
| value | Variant | Yes | 設定する値 | 型に応じた値 |
| iType | ERegistryValueType | No | 値の型（既定: REG_SZ） | 列挙値 |

### レジストリルートキー定数

| 定数名 | 値 | 説明 |
|--------|-----|------|
| HKEY_CLASSES_ROOT | &H80000000 | ファイル関連付け情報 |
| HKEY_CURRENT_USER | &H80000001 | 現在のユーザー設定 |
| HKEY_LOCAL_MACHINE | &H80000002 | マシン全体の設定 |
| HKEY_USERS | &H80000003 | 全ユーザー設定 |
| HKEY_CURRENT_CONFIG | &H80000005 | 現在のハードウェア設定 |

### 入力データソース

- レジストリパス文字列
- 設定する値（文字列、数値、バイナリ等）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Value | Variant | レジストリ値 |
| SubKeys | String() | サブキー名配列 |
| ValueNames | String() | 値名配列 |
| exists | Boolean | キー存在フラグ |

### 出力先

VBAオブジェクトのプロパティとしてメモリ内に保持

## 処理フロー

### 処理シーケンス

```
1. レジストリキーオープン（Create）
   └─ パス解析 → ルートキー決定 → RegOpenKeyExA

2. 値の読み取り（Value）
   └─ RegQueryValueExA（サイズ取得） → RegQueryValueExA（データ取得）

3. 値の書き込み（CreateValue）
   └─ RegSetValueExA

4. サブキー列挙（SubKeys）
   └─ RegEnumKeyExA ループ

5. 値名列挙（ValueNames）
   └─ RegEnumValueA ループ
```

### フローチャート

```mermaid
flowchart TD
    A[Create] --> B[パス解析]
    B --> C[ルートキー決定]
    C --> D{32bit/64bit?}
    D -->|32bit| E[KEY_WOW64_32KEY]
    D -->|64bit| F[KEY_WOW64_64KEY]
    E --> G[RegOpenKeyExA]
    F --> G
    G --> H{成功?}
    H -->|Yes| I[stdRegオブジェクト]
    H -->|No| J[Nothing]

    K[Value取得] --> L[RegQueryValueExA サイズ]
    L --> M[バッファ確保]
    M --> N[RegQueryValueExA データ]
    N --> O{型判定}
    O -->|REG_SZ| P[文字列変換]
    O -->|REG_DWORD| Q[Long変換]
    O -->|REG_BINARY| R[バイト配列]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | パス解析 | HKEY_*プレフィックスからルートキーを決定 | Create時 |
| BR-02 | WOW64対応 | 32bit/64bitビュー指定を考慮 | アクセス時 |
| BR-03 | ハンドル管理 | Class_TerminateでRegCloseKey | オブジェクト破棄時 |
| BR-04 | 既定値 | 空文字列の値名は既定値を示す | Value取得/設定時 |

### アクセスモード（ERegistryAccess）

| 定数名 | 値 | 説明 |
|--------|-----|------|
| KEY_QUERY_VALUE | &H1 | 値の読み取り |
| KEY_SET_VALUE | &H2 | 値の設定 |
| KEY_CREATE_SUB_KEY | &H4 | サブキー作成 |
| KEY_ENUMERATE_SUB_KEYS | &H8 | サブキー列挙 |
| KEY_NOTIFY | &H10 | 変更通知 |
| KEY_CREATE_LINK | &H20 | シンボリックリンク作成 |
| KEY_READ | &H20019 | 読み取り複合 |
| KEY_WRITE | &H20006 | 書き込み複合 |
| KEY_ALL_ACCESS | &HF003F | 全アクセス |

### 値の型（ERegistryValueType）

| 定数名 | 値 | 説明 |
|--------|-----|------|
| REG_NONE | 0 | 型なし |
| REG_SZ | 1 | 文字列 |
| REG_EXPAND_SZ | 2 | 展開可能な文字列 |
| REG_BINARY | 3 | バイナリデータ |
| REG_DWORD | 4 | 32ビット整数 |
| REG_DWORD_BIG_ENDIAN | 5 | ビッグエンディアン整数 |
| REG_LINK | 6 | シンボリックリンク |
| REG_MULTI_SZ | 7 | 複数文字列 |
| REG_QWORD | 11 | 64ビット整数 |

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | なし | - | データベース操作なし |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 2 | ERROR_FILE_NOT_FOUND | キーが存在しない | キー作成または存在確認 |
| 5 | ERROR_ACCESS_DENIED | アクセス権限不足 | 管理者権限で実行 |
| 1 | CreateKey失敗 | キー作成失敗 | DLLエラーを確認 |
| 1 | CreateValue失敗 | 値設定失敗 | DLLエラーを確認 |
| 1 | DeleteKey失敗 | キー削除失敗 | DLLエラーを確認 |
| 1 | DeleteValue失敗 | 値削除失敗 | DLLエラーを確認 |

### リトライ仕様

明示的なリトライ仕様なし

## トランザクション仕様

該当なし（レジストリ操作はアトミック）

## パフォーマンス要件

- RegEnumKeyExA/RegEnumValueAはループ処理のため項目数に比例
- レジストリアクセスはI/O操作のため若干のオーバーヘッドあり

## セキュリティ考慮事項

- HKEY_LOCAL_MACHINEへの書き込みには管理者権限が必要
- 他アプリケーションのレジストリ設定を誤って変更しないよう注意
- レジストリ破損はシステム障害につながる可能性あり
- 機密情報（パスワード等）のレジストリ保存は非推奨

## 備考

- Mac環境では動作しない（レジストリ非対応）
- VBA7/64bit対応の条件付きコンパイルあり
- PredeclaredId属性により、stdReg.Createのように直接アクセス可能
- WOW64リダイレクションに注意（32bit/64bitビューの違い）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

レジストリ関連の列挙型と定数を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | stdReg.cls | `src/stdReg.cls` | ERegistryRoot列挙型でルートキーを理解 |
| 1-2 | stdReg.cls | `src/stdReg.cls` | ERegistryAccess列挙型でアクセスモードを理解 |
| 1-3 | stdReg.cls | `src/stdReg.cls` | ERegistryValueType列挙型で値の型を理解 |
| 1-4 | stdReg.cls | `src/stdReg.cls` | TThis型でインスタンス状態管理を理解 |

**読解のコツ**: ルートキーの値は&H80000000から始まる。KEY_READは複数フラグの組み合わせ。

#### Step 2: エントリーポイントを理解する

Create関数とパス解析処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | stdReg.cls | `src/stdReg.cls` | Create関数 |
| 2-2 | stdReg.cls | `src/stdReg.cls` | protInit関数 |
| 2-3 | stdReg.cls | `src/stdReg.cls` | getPathParts関数 |

**主要処理フロー**:
- Create: パス文字列 → getPathParts → ルートキー＋サブパス決定
- protInit: RegOpenKeyExA → ハンドル保存

#### Step 3: 値の読み書きを理解する

Value取得とCreateValue設定を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | stdReg.cls | `src/stdReg.cls` | Value プロパティ |
| 3-2 | stdReg.cls | `src/stdReg.cls` | CreateValue 関数 |

**主要処理フロー**:
- Value: RegQueryValueExA（サイズ取得）→ バッファ確保 → RegQueryValueExA（データ取得）→ 型変換
- CreateValue: RegSetValueExA

#### Step 4: 列挙操作を理解する

SubKeysとValueNamesの列挙処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | stdReg.cls | `src/stdReg.cls` | SubKeys プロパティ |
| 4-2 | stdReg.cls | `src/stdReg.cls` | ValueNames プロパティ |

**主要処理フロー**:
- SubKeys: RegEnumKeyExA ループ → 配列に追加
- ValueNames: RegEnumValueA ループ → 配列に追加

#### Step 5: 削除操作とリソース管理を理解する

削除処理とClass_Terminateを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | stdReg.cls | `src/stdReg.cls` | DeleteKey 関数 |
| 5-2 | stdReg.cls | `src/stdReg.cls` | DeleteValue 関数 |
| 5-3 | stdReg.cls | `src/stdReg.cls` | Class_Terminate |

### プログラム呼び出し階層図

```
stdReg.Create(sPath, iAccess)
    │
    ├─ getPathParts(sPath)
    │      └─ パス文字列解析 → (ルートキー, サブパス)
    │
    └─ protInit(ルートキー, サブパス, iAccess)
           │
           └─ RegOpenKeyExA()              [advapi32]
                  └─ ハンドル取得

stdReg.Value(sName)
    │
    ├─ RegQueryValueExA(NULL, 0)          [advapi32] サイズ取得
    │
    ├─ バッファ確保
    │
    ├─ RegQueryValueExA(バッファ, サイズ)  [advapi32] データ取得
    │
    └─ 型に応じた変換
           ├─ REG_SZ → 文字列変換
           ├─ REG_DWORD → Long変換
           └─ REG_BINARY → Byte配列

stdReg.CreateValue(sName, value, iType)
    │
    └─ RegSetValueExA()                    [advapi32]

stdReg.SubKeys()
    │
    └─ While RegEnumKeyExA() = ERROR_SUCCESS  [advapi32]
           └─ 配列に追加

Class_Terminate()
    │
    └─ RegCloseKey()                       [advapi32]
```

### データフロー図

```
[入力]                    [処理]                         [出力]

レジストリパス ──────────▶ getPathParts()
     │                         │
     │                         ▼
     │                    ルートキー決定
     │                    サブパス抽出
     │                         │
     │                         ▼
     │                    RegOpenKeyExA()
     │                         │
     └─────────────────────────┼───────────────────────▶ stdRegオブジェクト
                               │
                               ▼
                         RegQueryValueExA()
                               │
                               ▼
                         型変換処理
                               │
                               ▼
                         Variant値
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| stdReg.cls | `src/stdReg.cls` | ソース | レジストリ操作クラス本体 |
