# 機能設計書 18-stdImage

## 概要

本ドキュメントは、stdVBAライブラリの画像操作クラス「stdImage」の機能設計を記載する。stdImageは、GDI+ライブラリを活用して画像の読み込み・保存・変換・操作をVBAから行うためのラッパークラスである。

### 本機能の処理概要

stdImageは、Windows GDI+ APIを活用して画像処理機能を提供するVBAクラスモジュールである。

**業務上の目的・背景**：VBAアプリケーションで画像ファイルの操作が必要なケースに対応する。スクリーンショットの取得、画像形式の変換、クリップボードとの画像やり取りなど、画像処理シナリオを実現する。

**機能の利用シーン**：
- スクリーンショットをキャプチャしてファイルに保存
- クリップボードの画像をPNG形式で保存
- BMP画像をJPEG/PNG形式に変換
- Excel VBAから画像ファイルを読み込んで加工

**主要な処理内容**：
1. 画像ファイルの読み込み（CreateFromFile）
2. クリップボードからの画像取得（CreateFromClipboard）
3. スクリーンショットの取得（CreateFromScreen、CreateFromHwnd）
4. 画像ファイルへの保存（SaveAs）
5. クリップボードへの画像設定（toClipboard）
6. 画像形式の変換（PNG、BMP、JPEG、TIFF、GIF）
7. 画像プロパティの取得（Width、Height等）

**関連システム・外部連携**：Windows GDI+（gdiplus.dll）、User32.dll、stdClipboardクラス

**権限による制御**：ファイルシステムへのアクセス権限に依存

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | なし | - | VBAライブラリクラスのため画面連携なし |

## 機能種別

ユーティリティ機能 / 画像処理 / GDI+

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| sPath | String | Yes | 画像ファイルパス（読み込み/保存） | 有効なパス |
| hwnd | LongPtr | Yes | ウィンドウハンドル（CreateFromHwnd） | 有効なハンドル |
| iFormat | EStdImageFormat | No | 保存形式（既定: PNG） | 列挙値 |

### 入力データソース

- 画像ファイル（BMP、PNG、JPEG、GIF、TIFF）
- ウィンドウハンドル（スクリーンショット用）
- クリップボード

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Width | Long | 画像の幅（ピクセル） |
| Height | Long | 画像の高さ（ピクセル） |
| HorizontalResolution | Single | 水平解像度（DPI） |
| VerticalResolution | Single | 垂直解像度（DPI） |
| PixelFormat | Long | ピクセルフォーマット |

### 出力先

- 画像ファイル（SaveAs）
- クリップボード（toClipboard）
- VBAオブジェクトのプロパティ

## 処理フロー

### 処理シーケンス

```
1. GDI+初期化（pGDIPToken取得）
   └─ GdiplusStartup

2. 画像読み込み（CreateFromFile）
   └─ GdipLoadImageFromFile → pImage取得

3. クリップボードから取得（CreateFromClipboard）
   └─ OpenClipboard → GetClipboardData → GdipCreateBitmapFromHBITMAP

4. スクリーンショット（CreateFromScreen）
   └─ GetDesktopWindow → GetDC → BitBlt → GdipCreateBitmapFromHBITMAP

5. 画像保存（SaveAs）
   └─ GdipSaveImageToFile

6. クリーンアップ
   └─ GdipDisposeImage → GdiplusShutdown
```

### フローチャート

```mermaid
flowchart TD
    A[Class_Initialize] --> B[GdiplusStartup]
    B --> C[pGDIPToken取得]

    D[CreateFromFile] --> E[GdipLoadImageFromFile]
    E --> F[pImage取得]
    F --> G[stdImageオブジェクト]

    H[CreateFromClipboard] --> I[OpenClipboard]
    I --> J[GetClipboardData CF_BITMAP]
    J --> K[GdipCreateBitmapFromHBITMAP]
    K --> L[CloseClipboard]
    L --> G

    M[CreateFromScreen] --> N[GetDesktopWindow]
    N --> O[GetDC]
    O --> P[CreateCompatibleDC]
    P --> Q[CreateCompatibleBitmap]
    Q --> R[BitBlt]
    R --> S[GdipCreateBitmapFromHBITMAP]
    S --> G

    T[SaveAs] --> U{フォーマット判定}
    U --> V[GdipSaveImageToFile]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | GDI+初期化 | Class_InitializeでGdiplusStartup | モジュール初期化時 |
| BR-02 | GDI+終了 | Class_TerminateでGdiplusShutdown | モジュール終了時 |
| BR-03 | 画像解放 | Class_TerminateでGdipDisposeImage | オブジェクト破棄時 |
| BR-04 | クリップボードロック | Open/CloseClipboardでロック管理 | クリップボード操作時 |

### 画像形式定数（EStdImageFormat）

| 定数名 | 説明 | MIME Type |
|--------|------|-----------|
| ImagePNG | PNG形式 | image/png |
| ImageBMP | BMP形式 | image/bmp |
| ImageJPEG | JPEG形式 | image/jpeg |
| ImageTIFF | TIFF形式 | image/tiff |
| ImageGIF | GIF形式 | image/gif |

### 画像エンコーダーCLSID

| 形式 | CLSID |
|------|-------|
| PNG | {557CF406-1A04-11D3-9A73-0000F81EF32E} |
| BMP | {557CF400-1A04-11D3-9A73-0000F81EF32E} |
| JPEG | {557CF401-1A04-11D3-9A73-0000F81EF32E} |
| TIFF | {557CF405-1A04-11D3-9A73-0000F81EF32E} |
| GIF | {557CF402-1A04-11D3-9A73-0000F81EF32E} |

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | なし | - | データベース操作なし |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| GDI+エラー | 画像読み込み失敗 | ファイル不存在/不正形式 | ファイルパスと形式を確認 |
| - | クリップボード空 | クリップボードに画像なし | Nothing返却 |
| - | GDI+初期化失敗 | GDI+ライブラリが利用不可 | システム確認 |

### リトライ仕様

明示的なリトライ仕様なし

## トランザクション仕様

該当なし（ファイル/メモリ操作のみ）

## パフォーマンス要件

- GDI+初期化はモジュールレベルで1回のみ（PredeclaredIdによるシングルトン）
- 大きな画像のBitBltは処理時間がかかる可能性
- 画像形式変換はGDI+に委譲するため効率的

## セキュリティ考慮事項

- スクリーンショット機能は機密画面をキャプチャする可能性
- ファイルシステムへのアクセス権限が必要
- クリップボードは他アプリケーションと共有される領域

## 備考

- Mac環境では動作しない（GDI+非対応）
- VBA7/64bit対応の条件付きコンパイルあり
- PredeclaredId属性により、stdImage.CreateFromFileのように直接アクセス可能
- GDI+トークンはモジュールレベルで管理

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

GDI+関連の構造体と定数を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | stdImage.cls | `src/stdImage.cls` | GdiplusStartupInput構造体 |
| 1-2 | stdImage.cls | `src/stdImage.cls` | EStdImageFormat列挙型 |
| 1-3 | stdImage.cls | `src/stdImage.cls` | GUID構造体（エンコーダーCLSID用） |
| 1-4 | stdImage.cls | `src/stdImage.cls` | TThis型でインスタンス状態管理 |

**読解のコツ**: GDI+はWindowsのグラフィックライブラリ。pGDIPTokenはGDI+セッション識別子。

#### Step 2: 初期化と終了処理を理解する

GDI+の初期化・終了パターンを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | stdImage.cls | `src/stdImage.cls` | Class_Initialize - GdiplusStartup |
| 2-2 | stdImage.cls | `src/stdImage.cls` | Class_Terminate - GdipDisposeImage, GdiplusShutdown |

**主要処理フロー**:
- Class_Initialize: PredeclaredId時にGdiplusStartupでGDI+初期化
- Class_Terminate: 画像リソース解放、GDI+終了

#### Step 3: 画像読み込みを理解する

各種CreateFrom*メソッドを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | stdImage.cls | `src/stdImage.cls` | CreateFromFile関数 - GdipLoadImageFromFile |
| 3-2 | stdImage.cls | `src/stdImage.cls` | CreateFromClipboard関数 |
| 3-3 | stdImage.cls | `src/stdImage.cls` | CreateFromScreen関数 |
| 3-4 | stdImage.cls | `src/stdImage.cls` | CreateFromHwnd関数 |

**主要処理フロー**:
- CreateFromFile: GdipLoadImageFromFile → pImage取得
- CreateFromClipboard: OpenClipboard → GetClipboardData(CF_BITMAP) → GdipCreateBitmapFromHBITMAP
- CreateFromScreen: GetDesktopWindow → BitBlt → GdipCreateBitmapFromHBITMAP

#### Step 4: 画像保存を理解する

SaveAsメソッドとエンコーダー選択を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | stdImage.cls | `src/stdImage.cls` | SaveAs関数 |
| 4-2 | stdImage.cls | `src/stdImage.cls` | getEncoderCLSID関数 |

**主要処理フロー**:
- SaveAs: 形式からCLSID取得 → GdipSaveImageToFile

#### Step 5: プロパティ取得を理解する

画像プロパティの取得方法を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | stdImage.cls | `src/stdImage.cls` | Width プロパティ - GdipGetImageWidth |
| 5-2 | stdImage.cls | `src/stdImage.cls` | Height プロパティ - GdipGetImageHeight |
| 5-3 | stdImage.cls | `src/stdImage.cls` | HorizontalResolution プロパティ |

### プログラム呼び出し階層図

```
Class_Initialize (PredeclaredId時)
    │
    └─ GdiplusStartup()                   [gdiplus.dll]
           └─ pGDIPToken取得

stdImage.CreateFromFile(sPath)
    │
    ├─ GdipLoadImageFromFile()            [gdiplus.dll]
    │      └─ pImage取得
    │
    └─ protInit(pImage)
           └─ This.pImage = pImage

stdImage.CreateFromClipboard()
    │
    ├─ OpenClipboard(0)                   [User32]
    │
    ├─ GetClipboardData(CF_BITMAP)        [User32]
    │      └─ hBitmap取得
    │
    ├─ GdipCreateBitmapFromHBITMAP()      [gdiplus.dll]
    │      └─ pImage作成
    │
    └─ CloseClipboard()                   [User32]

stdImage.SaveAs(sPath, iFormat)
    │
    ├─ getEncoderCLSID(iFormat)
    │      └─ GUID取得 (PNG/BMP/JPEG/TIFF/GIF)
    │
    └─ GdipSaveImageToFile()              [gdiplus.dll]

Class_Terminate
    │
    ├─ GdipDisposeImage(This.pImage)      [gdiplus.dll]
    │
    └─ GdiplusShutdown(pGDIPToken)        [gdiplus.dll]
```

### データフロー図

```
[入力]                    [処理]                         [出力]

画像ファイル ─────────────▶ GdipLoadImageFromFile
     │                            │
     │                            ▼
     │                       pImage取得
     │                            │
     └────────────────────────────┼─────────────────────▶ stdImageオブジェクト
                                  │
                                  ▼
                            プロパティ取得
                            (Width, Height等)
                                  │
                                  ▼
                            GdipSaveImageToFile
                                  │
                                  ▼
                            画像ファイル出力

クリップボード ──────────▶ GetClipboardData(CF_BITMAP)
     │                            │
     │                            ▼
     │                   GdipCreateBitmapFromHBITMAP
     │                            │
     └────────────────────────────┼─────────────────────▶ stdImageオブジェクト
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| stdImage.cls | `src/stdImage.cls` | ソース | 画像操作クラス本体 |
| stdClipboard.cls | `src/stdClipboard.cls` | ソース | クリップボード連携（Image Get/Set） |
