# 機能設計書 19-stdPerformance

## 概要

本ドキュメントは、stdVBAライブラリのパフォーマンス計測・最適化クラス「stdPerformance」の機能設計を記載する。stdPerformanceは、コードブロックの実行時間計測およびExcel等のアプリケーション設定最適化を行うためのセントリーパターン実装クラスである。

### 本機能の処理概要

stdPerformanceは、GetTickCount APIを使用した実行時間計測機能と、Application設定の一時的な変更による最適化機能を提供するVBAクラスモジュールである。

**業務上の目的・背景**：VBAアプリケーションのパフォーマンスチューニングが必要なケースに対応する。コードのボトルネック特定、処理時間の計測、バッチ処理時の画面更新抑制など、パフォーマンス改善シナリオを実現する。

**機能の利用シーン**：
- コードブロックの実行時間を計測してボトルネックを特定
- 大量データ処理時に画面更新・イベント発火を抑制
- 平均実行時間の算出による統計的な性能分析
- デバッグ時の処理時間ログ出力

**主要な処理内容**：
1. パフォーマンス計測（CreateMeasure）
2. アプリケーション設定最適化（CreateOptimiser）
3. 計測結果のキャッシュと取得（Measurement、MeasuresKeys）
4. 計測結果のクリア（MeasuresClear）

**関連システム・外部連携**：Windows kernel32.dll（GetTickCount API）、Application オブジェクト

**権限による制御**：特になし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | なし | - | VBAライブラリクラスのため画面連携なし |

## 機能種別

ユーティリティ機能 / デバッグ支援 / パフォーマンス計測

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| sProc | String | Yes | 計測対象の名前 | 任意の文字列 |
| nCount | Double | No | 繰り返し回数（既定: 1） | 正の数値 |
| ScreenUpdating | Boolean | No | 画面更新設定（既定: False） | Boolean |
| EnableEvents | Boolean | No | イベント発火設定（既定: False） | Boolean |
| Calculation | Long | No | 計算モード（既定: xlCalculationManual） | xlCalculation列挙値 |

### 入力データソース

- コードブロック名（文字列）
- 繰り返し回数（数値）
- アプリケーション設定パラメータ

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Measurement(sKey) | Double | 計測結果（ミリ秒） |
| MeasuresKeys | String() | 計測済みキー配列 |

### 出力先

- Debug.Print（計測結果の即座出力）
- 内部FakeDict（計測結果のキャッシュ）

## 処理フロー

### 処理シーケンス

```
1. 計測オブジェクト作成（CreateMeasure）
   └─ Create(iMeasure, Array(sProc, nCount))
      └─ protInit でStartTime記録

2. 計測対象コード実行
   └─ With ... End With ブロック内で任意のコード

3. 計測オブジェクト破棄（Class_Terminate）
   └─ EndTime取得 → AddMeasurement

4. 結果取得（Measurement）
   └─ FakeDictからキャッシュ値を取得
```

### フローチャート

```mermaid
flowchart TD
    A[CreateMeasure] --> B[Create iMeasure]
    B --> C[protInit]
    C --> D[StartTime = GetTickCount]
    D --> E[stdPerformanceオブジェクト返却]

    F[Withブロック開始] --> G[計測対象コード実行]
    G --> H[Withブロック終了]
    H --> I[Class_Terminate]
    I --> J[EndTime = GetTickCount]
    J --> K[AddMeasurement]
    K --> L[Debug.Print出力]
    L --> M[FakeDictに保存]

    N[CreateOptimiser] --> O[Create iOptimiser]
    O --> P[protInit]
    P --> Q[元設定を保存]
    Q --> R[設定を変更]
    R --> S[stdPerformanceオブジェクト返却]

    T[Withブロック終了] --> U[Class_Terminate]
    U --> V[設定を復元]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | セントリーパターン | With...End Withでスコープ管理 | 全機能 |
| BR-02 | 計測結果平均化 | 同名キーの計測は平均値を算出 | AddMeasurement時 |
| BR-03 | 設定復元 | Class_Terminateで元設定に復元 | iOptimiser時 |
| BR-04 | マルチプラットフォーム | Mac/Windows両対応のGetTickCount | 全計測 |

### パフォーマンスオブジェクト種別（EPerfObjType）

| 定数名 | 値 | 説明 |
|--------|-----|------|
| iMeasure | 1 | 計測用オブジェクト |
| iOptimiser | 2 | 最適化用オブジェクト |

### Optimiserの既定設定

| 設定項目 | 既定値 | 説明 |
|---------|--------|------|
| ScreenUpdating | False | 画面更新を抑制 |
| EnableEvents | False | イベント発火を抑制 |
| Calculation | xlCalculationManual (-4135) | 手動計算モード |

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | なし | - | データベース操作なし |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | なし | - | エラーハンドリング不要 |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし（メモリ内操作のみ）

## パフォーマンス要件

- GetTickCountは高速（ミリ秒精度）
- FakeDictは単純な配列実装（辞書ライブラリ不要でクロスプラットフォーム）
- Optimiserのオーバーヘッドは最小限

## セキュリティ考慮事項

特になし（デバッグ・開発支援機能）

## 備考

- Mac/Windows両対応（条件付きコンパイル）
- VBA7/64bit対応の条件付きコンパイルあり
- PredeclaredId属性により、stdPerformance.CreateMeasureのように直接アクセス可能
- FakeDictはScripting.Dictionary非依存のクロスプラットフォーム実装
- 計測結果はDebug.Printで即座に出力される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

内部で使用される型定義を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | stdPerformance.cls | `src/stdPerformance.cls` 47-50行目 | EPerfObjType列挙型 |
| 1-2 | stdPerformance.cls | `src/stdPerformance.cls` 54-58行目 | TOptimiser型（設定保存用） |
| 1-3 | stdPerformance.cls | `src/stdPerformance.cls` 61-65行目 | TMeasure型（計測用） |
| 1-4 | stdPerformance.cls | `src/stdPerformance.cls` 68-71行目 | FakeDictItem型（辞書代替） |
| 1-5 | stdPerformance.cls | `src/stdPerformance.cls` 77-84行目 | TThis型（全状態管理） |

**読解のコツ**: FakeDictはScripting.Dictionaryが使えないMac環境対応のための自前実装。

#### Step 2: API宣言を理解する

GetTickCount APIの条件付きコンパイルを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | stdPerformance.cls | `src/stdPerformance.cls` 32-44行目 | GetTickCount API宣言（Mac/Windows分岐） |

**主要処理フロー**:
- **32-37行目**: Mac用のGetTickCount宣言（MicrosoftOffice.framework）
- **38-43行目**: Windows用のGetTickCount宣言（kernel32.dll）

#### Step 3: コンストラクタを理解する

CreateMeasureとCreateOptimiserを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | stdPerformance.cls | `src/stdPerformance.cls` 95-98行目 | Create関数（Private） |
| 3-2 | stdPerformance.cls | `src/stdPerformance.cls` 158-160行目 | CreateMeasure関数 |
| 3-3 | stdPerformance.cls | `src/stdPerformance.cls` 175-177行目 | CreateOptimiser関数 |

**主要処理フロー**:
- **158-160行目**: CreateMeasure - Create(iMeasure, Array(sProc, nCount))
- **175-177行目**: CreateOptimiser - Create(iOptimiser, Array(ScreenUpdating, EnableEvents, Calculation))

#### Step 4: 初期化処理を理解する

protInitでのオブジェクト種別ごとの処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | stdPerformance.cls | `src/stdPerformance.cls` 107-133行目 | protInit関数 |

**主要処理フロー**:
- **110-113行目**: iMeasure時 - KeyName, Divider, StartTime設定
- **114-131行目**: iOptimiser時 - 元設定保存、新設定適用

#### Step 5: 終了処理を理解する

Class_Terminateでの計測完了/設定復元を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | stdPerformance.cls | `src/stdPerformance.cls` 267-288行目 | Class_Terminate |

**主要処理フロー**:
- **270-272行目**: iMeasure時 - EndTime取得、AddMeasurement呼び出し
- **273-286行目**: iOptimiser時 - 元設定への復元

#### Step 6: 計測結果管理を理解する

FakeDictを使用した計測結果の保存・取得を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 6-1 | stdPerformance.cls | `src/stdPerformance.cls` 196-205行目 | Measurement プロパティ |
| 6-2 | stdPerformance.cls | `src/stdPerformance.cls` 213-227行目 | AddMeasurement関数 |
| 6-3 | stdPerformance.cls | `src/stdPerformance.cls` 301-313行目 | getDictIndex関数 |
| 6-4 | stdPerformance.cls | `src/stdPerformance.cls` 319-336行目 | setDictItem関数 |
| 6-5 | stdPerformance.cls | `src/stdPerformance.cls` 352-363行目 | getDictItem関数 |

### プログラム呼び出し階層図

```
stdPerformance.CreateMeasure(sProc, nCount)
    │
    └─ Create(iMeasure, Array(sProc, nCount))
           │
           └─ protInit(iMeasure, params)
                  │
                  ├─ This.Measure.KeyName = params(0)
                  ├─ This.Measure.Divider = params(1)
                  └─ This.Measure.StartTime = GetTickCount()  [kernel32]

[Withブロック内のコード実行]

Class_Terminate()
    │
    ├─ GetTickCount()                              [kernel32]
    │      └─ EndTime取得
    │
    └─ AddMeasurement(KeyName, EndTime - StartTime, Divider)
           │
           ├─ Debug.Print                          [出力]
           │
           └─ setDictItem(sKey, Array(time, 1))   [FakeDictに保存]

stdPerformance.CreateOptimiser(ScreenUpdating, EnableEvents, Calculation)
    │
    └─ Create(iOptimiser, Array(...))
           │
           └─ protInit(iOptimiser, params)
                  │
                  ├─ 元設定保存
                  │      ├─ This.Optimiser.ScreenUpdating = Application.ScreenUpdating
                  │      ├─ This.Optimiser.EnableEvents = Application.EnableEvents
                  │      └─ This.Optimiser.Calculation = Application.Calculation
                  │
                  └─ 新設定適用
                         ├─ Application.ScreenUpdating = params(0)
                         ├─ Application.EnableEvents = params(1)
                         └─ Application.Calculation = params(2)

Class_Terminate()
    │
    └─ 設定復元
           ├─ Application.ScreenUpdating = This.Optimiser.ScreenUpdating
           ├─ Application.EnableEvents = This.Optimiser.EnableEvents
           └─ Application.Calculation = This.Optimiser.Calculation
```

### データフロー図

```
[入力]                    [処理]                         [出力]

CreateMeasure("test") ───▶ protInit
     │                         │
     │                         ├─ StartTime = GetTickCount
     │                         │
     └─────────────────────────┼───────────────────────▶ stdPerformanceオブジェクト
                               │
                               ▼
                         [計測対象コード]
                               │
                               ▼
                         Class_Terminate
                               │
                               ├─ EndTime = GetTickCount
                               │
                               ├─ 経過時間 = EndTime - StartTime
                               │
                               ├─ Debug.Print出力 ────────────▶ イミディエイトウィンドウ
                               │
                               └─ FakeDictに保存 ─────────────▶ キャッシュ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| stdPerformance.cls | `src/stdPerformance.cls` | ソース | パフォーマンス計測・最適化クラス本体 |
