# 機能設計書 21-stdTimer

## 概要

本ドキュメントは、stdVBAライブラリにおける`stdTimer`クラスの機能設計を記述する。stdTimerは、VBAで指定間隔でのTickイベント発生とコールバック実行を実現するタイマークラスである。

### 本機能の処理概要

stdTimerは、VBAの制約を克服し、ミリ秒単位の精度でタイマーイベントを発生させることができるクラスである。リモートワークブックを使用した独自のアーキテクチャにより、安全で信頼性の高いタイマー機能を提供する。

**業務上の目的・背景**：VBA標準のApplication.OnTimeメソッドは秒単位の精度しかなく、またユーザー操作中に安全に動作させることが困難である。stdTimerは、定期的なデータ更新、ポーリング処理、アニメーション効果、プログレス表示更新など、より細かい時間制御が必要な業務要件に対応するために開発された。

**機能の利用シーン**：外部データの定期取得（株価、為替レートなど）、バックグラウンド処理の進捗監視、UI要素の定期更新（時計表示、カウントダウン）、非同期処理の完了待機、ゲームやシミュレーションのフレーム更新などの場面で利用される。

**主要な処理内容**：
1. VBOM（Visual Basic Object Model）の有効化確認と必要に応じた自動有効化
2. 新しいExcelアプリケーションインスタンスの作成とリモートワークブックの生成
3. タイマーコードの動的注入とMainLoopの開始
4. WorksheetChangeイベントを介したTickイベントの発火
5. コールバックオブジェクト（stdICallable）への通知
6. クラス終了時のリモートワークブック自動クリーンアップ

**関連システム・外部連携**：stdICallableインターフェースを実装したコールバックオブジェクト（stdLambda、stdCallback）と連携可能。Windows/Mac両環境でのSleep API呼び出し。

**権限による制御**：VBOM（VB Object Model Extensibility）の有効化が必要。信頼設定でマクロへのアクセスが許可されている必要がある。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | （画面なし） | 該当なし | 本機能はVBAライブラリであり、UIを持つ画面は存在しない |

## 機能種別

イベント処理 / タイマー制御 / 非同期処理サポート

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| iMilliseconds | Long | Yes | Tickイベント発生間隔（ミリ秒） | 正の整数値 |
| callback | Object (stdICallable) | No | Tickイベント時に実行されるコールバック | Runメソッドを持つオブジェクト |

### 入力データソース

- プログラムからのパラメータ指定

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Tickイベント | Event | 指定間隔で発生するイベント |
| コールバック実行 | - | 登録されたコールバックのRunメソッド呼び出し |

### 出力先

- イベントリスナー（WithEventsで購読するクライアント）
- コールバックオブジェクトのRunメソッド

## 処理フロー

### 処理シーケンス

```
1. Create関数の呼び出し
   └─ 新しいstdTimerインスタンスを生成

2. protInit（初期化処理）
   ├─ コールバックの保存
   ├─ VBOMの有効化確認・設定
   ├─ リモートワークブックの作成
   ├─ タイマーコードの注入
   └─ タイマーループの開始

3. MainLoop（リモートワークブック内）
   ├─ ワークシートのセルA1に"Tick"を書き込み
   ├─ 指定ミリ秒間Sleep
   ├─ DoEventsの実行
   └─ 繰り返し（bRunning = True の間）

4. SheetChangeイベントのトリガー
   ├─ Tickイベントの発火（RaiseEvent）
   └─ コールバックのRun実行

5. Class_Terminate（終了処理）
   ├─ StopTimerの呼び出し
   └─ リモートワークブックのクローズ
```

### フローチャート

```mermaid
flowchart TD
    A[Create呼び出し] --> B[protInit実行]
    B --> C{VBOMが有効?}
    C -->|No| D[VBOM有効化]
    C -->|Yes| E[リモートワークブック作成]
    D --> E
    E --> F[タイマーコード注入]
    F --> G[StartTimer実行]
    G --> H[MainLoop開始]
    H --> I[セルA1に書き込み]
    I --> J[SheetChangeイベント発火]
    J --> K[Tickイベント発火]
    K --> L{コールバック登録済?}
    L -->|Yes| M[callback.Run実行]
    L -->|No| N[Sleep実行]
    M --> N
    N --> O{bRunning?}
    O -->|True| I
    O -->|False| P[ワークブック終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-21-01 | VBOM自動有効化 | VBOMが無効の場合、自動的に有効化する | タイマー初期化時 |
| BR-21-02 | リモートワークブック分離 | タイマー処理は別のExcelインスタンスで実行 | 常時 |
| BR-21-03 | イベント同期 | COMイベントを使用するため、イベントは同期的に処理される | 常時 |
| BR-21-04 | 自動クリーンアップ | タイマー終了時にリモートワークブックを自動クローズ | Class_Terminate時 |

### 計算ロジック

タイマー間隔：指定されたミリ秒間隔でSleep関数が呼び出されるが、実際の間隔は処理時間により若干の誤差が生じる。

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（本機能はデータベース操作を行わない）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | VBOM無効化エラー | VBOMの有効化に失敗した場合 | 手動でマクロセキュリティ設定を変更 |
| - | リモートワークブック作成エラー | Excelインスタンス作成失敗 | システムリソースを確認 |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし（本機能はトランザクション制御を行わない）

## パフォーマンス要件

- タイマー精度：ミリ秒単位の指定が可能だが、完全な精度は保証されない
- 処理オーバーヘッド：リモートワークブックとのCOMイベント通信による若干の遅延が発生

## セキュリティ考慮事項

- VBOMの有効化はセキュリティリスクを伴うため、信頼できる環境でのみ使用すること
- リモートワークブックは非表示で作成されるため、DEBUG_MODE定数でデバッグ時に表示可能

## 備考

- MsgBoxやInputBox表示中はTickイベントが発生しない
- デバッグ中（ステップ実行等）はタイマーイベントは発生しない
- Edit/Pointモード中もイベントは発火する（SafeTimers-Nativeとの違い）
- Cristian Buse氏のSafeTimersプロジェクトからインスピレーションを得ている

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

タイマークラスの内部状態と外部インターフェースを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | stdTimer.cls | `src/stdTimer.cls` | クラス属性とモジュールレベル変数（44-49行目）の宣言を確認 |

**読解のコツ**: `WithEvents xlRemoteWorkbook`はリモートワークブックからのイベントを受信するための宣言。`pCallback As Object`はstdICallableインターフェースを持つコールバックオブジェクト。

#### Step 2: エントリーポイントを理解する

タイマー作成のエントリーポイントを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | stdTimer.cls | `src/stdTimer.cls` | Create関数（56-59行目）がエントリーポイント |

**主要処理フロー**:
1. **56行目**: `Create`関数はファクトリメソッドとして動作
2. **57-58行目**: 新しいインスタンスを生成し、protInitを呼び出して初期化

#### Step 3: 初期化処理を理解する

タイマーの初期化処理の流れを追跡する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | stdTimer.cls | `src/stdTimer.cls` | protInit（65-72行目）で初期化処理を実行 |

**主要処理フロー**:
- **66行目**: コールバックオブジェクトを保存
- **67行目**: VBOMの有効化確認と必要に応じた設定
- **68行目**: リモートワークブックを作成
- **70行目**: タイマーコードを注入
- **71行目**: タイマーループを開始

#### Step 4: リモートワークブック作成を理解する

別プロセスでのワークブック作成メカニズムを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | stdTimer.cls | `src/stdTimer.cls` | createRemoteWorkbook（76-90行目）の処理 |

**主要処理フロー**:
- **78行目**: `CreateObject("Excel.Application")`で新しいExcelインスタンスを作成
- **79-88行目**: アプリケーション設定（非表示、画面更新停止など）
- **89行目**: ワークブックを追加して返却

#### Step 5: タイマーコード注入を理解する

動的に生成されるタイマーコードを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | stdTimer.cls | `src/stdTimer.cls` | injectCode（97-103行目）とgetTimerCode（136-168行目） |

**主要処理フロー**:
- **136-168行目**: Windows/Mac両対応のSleep宣言とMainLoop、StartTimer、StopTimerサブルーチンを生成
- **154行目**: セルA1への書き込みでSheetChangeイベントをトリガー
- **97-103行目**: VBProjectにコードモジュールを追加

#### Step 6: イベントハンドリングを理解する

Tickイベントの発火メカニズムを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 6-1 | stdTimer.cls | `src/stdTimer.cls` | xlRemoteWorkbook_SheetChange（179-182行目） |

**主要処理フロー**:
- **180行目**: Tickイベントを発火
- **181行目**: コールバックが登録されている場合はRunメソッドを実行

### プログラム呼び出し階層図

```
stdTimer.Create
    │
    ├─ protInit
    │      ├─ getVBOM / setVBOM
    │      ├─ createRemoteWorkbook
    │      │      └─ Excel.Application (CreateObject)
    │      ├─ injectCode
    │      │      └─ getTimerCode
    │      └─ Application.Run("TimerMain.StartTimer")
    │             └─ MainLoop (リモートワークブック内)
    │                    ├─ Sheets(1).Range("A1") 更新
    │                    ├─ Sleep
    │                    └─ DoEvents
    │
    └─ xlRemoteWorkbook_SheetChange (イベント受信)
           ├─ RaiseEvent Tick
           └─ pCallback.Run
```

### データフロー図

```
[入力]                    [処理]                          [出力]

iMilliseconds ──────▶ getTimerCode ──────▶ タイマーコード生成
                            │
callback ─────────────▶ protInit ──────────▶ コールバック保存
                            │
                     createRemoteWorkbook
                            │
                     injectCode ──────────▶ VBProject更新
                            │
                     StartTimer
                            │
                     MainLoop (リモート)
                            │
                     SheetChange ─────────▶ Tickイベント
                            │
                     callback.Run ─────────▶ コールバック実行
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| stdTimer.cls | `src/stdTimer.cls` | ソース | タイマークラス本体 |
| stdTimer.cls (WIP) | `src/WIP/stdTimer.cls` | ソース | 開発中バージョン |
| stdTimerServerWIP.bas | `src/WIP/stdTimerServerWIP.bas` | ソース | サーバーベースタイマー（開発中） |
| stdICallable.cls | `src/stdICallable.cls` | ソース | コールバックインターフェース |
| stdCallback.cls | `src/stdCallback.cls` | ソース | コールバック実装（関連クラス） |
| stdLambda.cls | `src/stdLambda.cls` | ソース | ラムダ関数実装（関連クラス） |
