# 機能設計書 22-stdFiber

## 概要

本ドキュメントは、stdVBAライブラリにおける`stdFiber`クラスの機能設計を記述する。stdFiberは、VBAでファイバー（軽量スレッド）パターンを実現し、非同期手続きの分割実行と並行処理のシミュレーションを可能にするクラスである。

### 本機能の処理概要

stdFiberは、長時間実行される処理を複数のステップに分割し、複数のファイバー（処理単位）を疑似的に並行実行できるようにするクラスである。特に非同期HTTPリクエストやUIオートメーションなど、待機が必要な処理において有効である。

**業務上の目的・背景**：VBAはシングルスレッドで実行されるため、複数の非同期処理を効率的に管理することが困難である。stdFiberは、複数の非同期リクエストの同時発行と結果の一括収集、複数ウィンドウの並行操作、大量データの分割処理など、従来VBAでは実現が難しかった並行処理パターンを提供する。

**機能の利用シーン**：複数のWebAPIへの同時リクエストと結果の集約、複数のIE/ブラウザウィンドウの並行制御、大量レコードのバッチ処理における進捗表示、RPAにおける複数ウィンドウの同時監視、エラーハンドリングを伴う段階的な処理実行などで利用される。

**主要な処理内容**：
1. ファイバー（処理手順のコンテナ）の作成
2. ステップ（個別の処理関数）のファイバーへの登録
3. 複数ファイバーの並行実行ランタイムによる処理
4. エージェント（共有リソースオブジェクト）の管理
5. エラーハンドリングとリセット機能
6. 処理結果の収集と返却

**関連システム・外部連携**：stdICallableインターフェースを実装したコールバック（stdCallback）と連携。stdHTTP（非同期HTTP通信）、stdAcc（Accessibility自動化）等との組み合わせ使用を想定。

**権限による制御**：特別な権限制御は不要。ただし、ファイバー内で実行される処理によっては、適切な権限が必要となる場合がある。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | （画面なし） | 該当なし | 本機能はVBAライブラリであり、UIを持つ画面は存在しない |

## 機能種別

非同期処理 / 並行処理シミュレーション / ワークフロー制御

## 入力仕様

### 入力パラメータ

#### Create関数
| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| sName | String | Yes | ファイバーの名前 | - |

#### add関数
| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| processStep | stdICallable | Yes | 実行するステップのコールバック | (stdFiber)=>Boolean を返す関数 |
| stepName | String | No | ステップの名前（リセット用） | - |

#### runFibers関数
| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| vFibers | Variant | Yes | 実行するファイバーのコレクション | Collection/Array/stdArray/stdEnumerator |
| numAgents | Long | No | 同時実行するエージェント数（デフォルト: 1） | 正の整数 |
| agentInitCB | stdICallable | No | エージェント初期化コールバック | - |
| agentDestroyCB | stdICallable | No | エージェント破棄コールバック | - |
| runtimeUpdateCB | stdICallable | No | 進捗更新コールバック | - |

### 入力データソース

- プログラムからのパラメータ指定
- コールバック関数の定義

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Result | Variant | Resolveで設定された処理結果 |
| ErrorText | String | エラー発生時のエラーメッセージ |
| isFinished | Boolean | 処理完了フラグ |
| Step | Long | 現在のステップ番号 |
| StepName | String | 現在のステップ名 |
| StepDuration | Long | 現在のステップの実行時間（秒） |
| TotalDuration | Long | 全体の実行時間（秒） |
| ResetCount | Long | リセット回数 |

### 出力先

- runFibersの戻り値としてCollectionで結果を返却
- 個別のファイバーからResultプロパティで結果を取得

## 処理フロー

### 処理シーケンス

```
1. ファイバーの作成（Create）
   └─ 名前を指定してファイバーインスタンスを生成

2. ステップの追加（add）
   ├─ 処理関数（stdICallable）を登録
   └─ 複数ステップをチェーンで追加可能

3. エラーハンドラの追加（addErrorHandler）
   └─ エラー時の処理を登録

4. ファイバーランタイムの実行（runFibers）
   ├─ エージェントの初期化
   ├─ キューからファイバーを取得
   ├─ 各ファイバーのステップを順次実行
   │     ├─ ステップがTrueを返したら次のステップへ
   │     └─ ステップがFalseを返したら同じステップを再実行
   ├─ 完了したファイバーをキューから除去
   └─ 全ファイバー完了まで繰り返し

5. 結果の収集
   └─ 各ファイバーの結果をCollectionとして返却
```

### フローチャート

```mermaid
flowchart TD
    A[ファイバー作成] --> B[ステップ追加]
    B --> C[エラーハンドラ追加]
    C --> D[runFibers呼び出し]
    D --> E[エージェント初期化]
    E --> F{ファイバーキュー}
    F -->|あり| G[ファイバー取得]
    G --> H[protStep実行]
    H --> I{ステップ成功?}
    I -->|True| J[次のステップへ]
    I -->|False| K[同じステップを再実行]
    J --> L{最終ステップ?}
    L -->|Yes| M[ファイバー完了]
    L -->|No| H
    K --> N[DoEvents]
    M --> N
    N --> O{全ファイバー完了?}
    O -->|No| F
    O -->|Yes| P[エージェント破棄]
    P --> Q[結果収集]
    Q --> R[Collection返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-22-01 | ステップ完了判定 | ステップがTrueを返すと次のステップに進む | protStep実行時 |
| BR-22-02 | 待機ステップ | ステップがFalseを返すと同じステップを再実行 | 非同期処理待機時 |
| BR-22-03 | エラー時終了 | エラー発生時はファイバーを完了扱いにする | エラーハンドラ実行後 |
| BR-22-04 | エージェント共有 | エージェントは同一ランタイム内で共有される | runFibers実行中 |
| BR-22-05 | リセット機能 | 特定のステップに戻って再実行可能 | Reset呼び出し時 |

### 計算ロジック

- StepDuration: `DateDiff("s", This.procs(This.procStep).startTime, Now())`
- TotalDuration: `DateDiff("s", This.procs(This.procsCount).startTime, This.endTime)`
- 進捗更新は1000サイクルごとに実行

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（本機能はデータベース操作を行わない）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ステップ実行エラー | protStep内でエラー発生 | errorHandlerが呼び出される |
| - | キャンセル | Cancel呼び出し | errorTextにメッセージ設定、完了扱い |

### リトライ仕様

Resetメソッドにより特定のステップまたは最初から再実行可能

## トランザクション仕様

該当なし（本機能はトランザクション制御を行わない）

## パフォーマンス要件

- エージェント数を増やすことで並行処理数を増加可能
- DoEventsを定期的に呼び出すことでUIの応答性を維持
- 進捗更新は1000サイクルごとに実行（パフォーマンスとのバランス）

## セキュリティ考慮事項

- ファイバー内で実行される処理のセキュリティは、各ステップの実装に依存
- エージェントオブジェクトは複数ファイバー間で共有されるため、適切なスコープ管理が必要

## 備考

- VBAのシングルスレッド制約の中で協調的マルチタスキングを実現
- stdHTTPの非同期モードと組み合わせることで、複数HTTPリクエストの並行処理が可能
- IEオートメーションにおいて、複数ウィンドウの同時制御に活用可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ファイバーの内部状態を管理するType定義を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | stdFiber.cls | `src/stdFiber.cls` | TFiberQueue（87-91行目）とTProc（92-96行目）の型定義 |
| 1-2 | stdFiber.cls | `src/stdFiber.cls` | TThis（99-114行目）の型定義で内部状態を理解 |

**読解のコツ**:
- `TFiberQueue`はファイバーのキュー管理用の構造体
- `TProc`は個別のステップ（手続き）を表す構造体
- `TThis`はファイバーインスタンスの全状態を保持する構造体

#### Step 2: エントリーポイントを理解する

ファイバー作成と実行のエントリーポイントを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | stdFiber.cls | `src/stdFiber.cls` | Create関数（121-124行目）がファイバー生成のエントリーポイント |
| 2-2 | stdFiber.cls | `src/stdFiber.cls` | runFibers関数（301-367行目）がランタイム実行のエントリーポイント |

**主要処理フロー**:
1. **121-124行目**: `Create`関数で新しいファイバーを生成し、protInitで初期化
2. **301-367行目**: `runFibers`で複数ファイバーを並行実行

#### Step 3: ステップ追加処理を理解する

ファイバーへのステップ追加メカニズムを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | stdFiber.cls | `src/stdFiber.cls` | add関数（140-148行目）でステップを追加 |
| 3-2 | stdFiber.cls | `src/stdFiber.cls` | addErrorHandler（153-156行目）とaddStepChangeHandler（161-164行目） |

**主要処理フロー**:
- **141-146行目**: procsCount増加、procs配列の再確保、procとnameの設定
- **147行目**: Meを返すことでメソッドチェーンを実現

#### Step 4: ステップ実行処理を理解する

個別ステップの実行ロジックを追跡する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | stdFiber.cls | `src/stdFiber.cls` | protStep関数（169-195行目）でステップを実行 |

**主要処理フロー**:
- **172-173行目**: 開始時刻の記録
- **176行目**: ステップのコールバックを実行し、結果を取得
- **177-183行目**: Trueならば次のステップへ、最終ステップなら完了
- **188-194行目**: エラー発生時の処理

#### Step 5: ランタイム実行を理解する

複数ファイバーの並行実行メカニズムを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | stdFiber.cls | `src/stdFiber.cls` | runFibers（301-367行目）のメインループ |

**主要処理フロー**:
- **303-311行目**: エージェントの初期化
- **316-352行目**: メインループ - ファイバーのステップを順次実行
- **320-324行目**: 実行中ファイバーのステップ処理
- **327-334行目**: キューから次のファイバーを取得
- **354-358行目**: エージェントのクリーンアップ
- **361-365行目**: 結果の収集

#### Step 6: キュー操作を理解する

ファイバーキューの操作ヘルパー関数を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 6-1 | stdFiber.cls | `src/stdFiber.cls` | TFiberQueue_Create（399-434行目） |
| 6-2 | stdFiber.cls | `src/stdFiber.cls` | TFiberQueue_Get（439-442行目）とTFiberQueue_HasNext（447-449行目） |

**主要処理フロー**:
- **402-432行目**: Collection、Array、stdArray、stdEnumeratorからキューを生成
- **439-442行目**: キューから次のファイバーを取得
- **447-449行目**: 次のファイバーが存在するか確認

### プログラム呼び出し階層図

```
stdFiber.Create
    │
    └─ protInit
           └─ Scripting.Dictionary (meta初期化)

stdFiber.add / addErrorHandler / addStepChangeHandler
    │
    └─ procs配列への追加

stdFiber.runFibers
    │
    ├─ TFiberQueue_Create
    │      └─ Collection/Array/stdArray/stdEnumeratorからキュー生成
    │
    ├─ agentInitCB.Run (各エージェント)
    │
    ├─ MainLoop
    │      ├─ protStep
    │      │      ├─ proc.Run (ステップ実行)
    │      │      └─ stepChangeHandler.Run (完了時)
    │      │
    │      ├─ TFiberQueue_HasNext
    │      ├─ TFiberQueue_Get
    │      └─ runtimeUpdateCB.Run (1000サイクルごと)
    │
    ├─ agentDestroyCB.Run (各エージェント)
    │
    └─ 結果Collection生成・返却
```

### データフロー図

```
[入力]                         [処理]                          [出力]

ステップ関数群 ─────────▶ add() ─────────────▶ procs配列
       │
エラーハンドラ ─────────▶ addErrorHandler()──▶ errorHandler
       │
ファイバー群 ───────────▶ TFiberQueue_Create ──▶ キュー
       │
numAgents ─────────────▶ エージェント配列 ────▶ agents()
       │
                        runFibers()
                            │
                        protStep()
                            │
                ┌───────────┴───────────┐
                │                       │
        proc.Run() ─────▶ 結果(True/False)
                │
        Resolve() ──────▶ This.result ────▶ Result
                │
        Cancel() ───────▶ isFinished ─────▶ ErrorText
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| stdFiber.cls | `src/stdFiber.cls` | ソース | ファイバークラス本体 |
| stdICallable.cls | `src/stdICallable.cls` | ソース | コールバックインターフェース |
| stdCallback.cls | `src/stdCallback.cls` | ソース | コールバック実装（ステップ定義に使用） |
| stdHTTP.cls | `src/stdHTTP.cls` | ソース | 非同期HTTP通信（連携利用） |
| stdArray.cls | `src/stdArray.cls` | ソース | 配列クラス（vFibersの入力形式） |
| stdEnumerator.cls | `src/stdEnumerator.cls` | ソース | イテレータクラス（vFibersの入力形式） |
