# 機能設計書 24-stdRibbon

## 概要

本ドキュメントは、stdVBAライブラリにおける`stdRibbon`クラスの機能設計を記述する。stdRibbonは、Microsoft OfficeアプリケーションのリボンUI状態を管理するクラスであり、リボンの表示状態（フルスクリーン、タブのみ、常時表示等）の取得と設定を提供する。

### 本機能の処理概要

stdRibbonは、Excel・Wordなどのオフィスアプリケーションにおけるリボンの表示状態を統一的に管理するクラスである。アプリケーション固有の状態（Excel全画面表示、Word読み取りモード等）も含めて、リボン状態の取得と設定を一元的に行うことができる。

**業務上の目的・背景**：VBAマクロからリボンの表示状態を制御するには、複数のAPIやプロパティを組み合わせる必要があり、アプリケーションごとに異なる実装が必要となる。stdRibbonは、これらの複雑さを抽象化し、統一的なインターフェースでリボン状態を制御することで、プレゼンテーション、キオスクモード、フルスクリーンビューア等のアプリケーション開発を容易にする。

**機能の利用シーン**：データ入力フォームでのリボン非表示、プレゼンテーションモードの実装、キオスクアプリケーションの構築、画面スペース最大化、ユーザーのリボン状態保存と復元などの場面で利用される。

**主要な処理内容**：
1. 現在のリボン状態の取得（State Get）
2. リボン状態の設定・変更（State Let）
3. アプリケーション固有状態の検出（Excel全画面、Word読み取りモード等）
4. リボン状態の段階的リセット（RibbonAlwaysShowRibbon経由）
5. Windows/Mac環境での条件分岐処理

**関連システム・外部連携**：Microsoft Office CommandBars API、Application.DisplayFullScreen、Word ActiveWindow.View等のOffice APIを使用。Excel 4.0マクロ（Show.ToolBar）も一部使用。

**権限による制御**：Protected View（保護されたビュー）中は一部操作が制限される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | （画面なし） | 該当なし | 本機能はVBAライブラリであり、UIを持つ画面は存在しない。ただし、Office UIのリボン制御に使用される |

## 機能種別

UI制御 / アプリケーション状態管理

## 入力仕様

### 入力パラメータ

#### State プロパティ（Let）
| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| v | ERibbonState | Yes | 設定したいリボン状態 | 列挙体の有効な値 |

### 入力データソース

- プログラムからのプロパティ設定

## 出力仕様

### 出力データ

#### State プロパティ（Get）
| 項目名 | 型 | 説明 |
|--------|-----|------|
| State | ERibbonState | 現在のリボン状態 |

#### ERibbonState 列挙体
| 値 | 説明 |
|----|------|
| RibbonNullState | 初期状態（未使用） |
| RibbonFullScreenMode | フルスクリーンモード（HideRibbon） |
| RibbonShowTabsOnly | タブのみ表示（MinimizeRibbon） |
| RibbonAlwaysShowRibbon | 常時リボン表示 |
| RibbonNotVisible | リボン非表示 |
| RibbonProtectedViewMode | 保護されたビュー |
| ExcelApplicationDisplayFullScreenMode | Excel全画面表示 |
| WordViewFullScreenMode | Word全画面表示 |
| WordViewReadMode | Word読み取りモード |

### 出力先

- プロパティ経由での値取得

## 処理フロー

### 処理シーケンス

```
1. State取得（Get）
   ├─ アプリケーション名を確認
   ├─ 各種状態フラグを取得
   │     ├─ xlDisplayFullScreen
   │     ├─ wdReadMode / wdViewFullScreen
   │     ├─ genRibbonNotVisible
   │     ├─ genRibbonHidden
   │     └─ genRibbonMinimized
   └─ 優先順位に従って状態を判定

2. State設定（Let）
   ├─ 現在の状態を取得
   ├─ 同じ状態なら何もしない
   ├─ 現在の状態からRibbonAlwaysShowRibbonへリセット
   │     └─ 状態に応じた解除処理
   └─ RibbonAlwaysShowRibbonから目的の状態へ変更
         └─ 状態に応じた設定処理
```

### フローチャート

```mermaid
flowchart TD
    A[State Let呼び出し] --> B[現在の状態を取得]
    B --> C{現在の状態 = 目的の状態?}
    C -->|Yes| D[終了]
    C -->|No| E{現在の状態}
    E -->|RibbonProtectedViewMode| F1[ActiveProtectedViewWindow.Edit]
    E -->|WordViewFullScreenMode| F2[FullScreen = False]
    E -->|ExcelDisplayFullScreen| F3[DisplayFullScreen = False]
    E -->|RibbonNotVisible| F4[Show.ToolBar Ribbon true]
    E -->|RibbonFullScreenMode| F5[ExecuteMso HideRibbon]
    E -->|RibbonShowTabsOnly| F6[ExecuteMso MinimizeRibbon]
    E -->|RibbonAlwaysShowRibbon| G[状態変更へ]
    F1 --> H[再帰的にRibbonAlwaysShowRibbonへ]
    F2 --> H
    F3 --> H
    F4 --> H
    F5 --> H
    F6 --> H
    H --> G
    G --> I{目的の状態}
    I -->|RibbonProtectedViewMode| J1[エラー発生]
    I -->|WordViewFullScreenMode| J2[FullScreen = True]
    I -->|ExcelDisplayFullScreen| J3[DisplayFullScreen = True]
    I -->|RibbonNotVisible| J4[Show.ToolBar Ribbon false]
    I -->|RibbonFullScreenMode| J5[ExecuteMso HideRibbon]
    I -->|RibbonShowTabsOnly| J6[ExecuteMso MinimizeRibbon]
    I -->|RibbonAlwaysShowRibbon| D
    J1 --> D
    J2 --> D
    J3 --> D
    J4 --> D
    J5 --> D
    J6 --> D
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-24-01 | 状態優先順位 | ProtectedView > アプリ固有 > リボン非表示 > 最小化 > 隠す > 常時表示 | State Get時 |
| BR-24-02 | 段階的リセット | 状態変更は必ずRibbonAlwaysShowRibbonを経由 | State Let時 |
| BR-24-03 | ProtectedView制限 | 保護されたビューへの状態変更は不可 | State Let時 |
| BR-24-04 | アプリケーション固有状態 | Excel/Word固有の状態は対応アプリでのみ有効 | 常時 |
| BR-24-05 | Mac非対応機能 | Macでは一部機能が制限される | Mac環境 |

### 計算ロジック

該当なし

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（本機能はデータベース操作を行わない）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | stdRibbon#State[Let] | WordViewFullScreenModeがWord以外で検出 | 内部エラー、発生しないはず |
| 1 | stdRibbon#State[Let] | WordViewReadModeがWord以外で検出 | 内部エラー、発生しないはず |
| 1 | stdRibbon#State[Let] | ExcelDisplayFullScreenがExcel以外で検出 | 内部エラー、発生しないはず |
| 1 | stdRibbon#State[Let] | RibbonNotVisibleがExcel以外で検出 | メカニズム不明 |
| 1 | stdRibbon#State[Let] | RibbonProtectedViewModeへの変更を試みた | 保護ビューはファイル操作でのみ入れる |
| 1 | stdRibbon#State[Let] | 状態変更が反映されなかった | 予期しない状態 |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし（本機能はトランザクション制御を行わない）

## パフォーマンス要件

- Mac環境でのMinimizeRibbonは非同期動作のため、MacScript("delay 0")で待機が必要
- DoEventsを使用して状態変更の反映を待機

## セキュリティ考慮事項

- Protected View中は編集操作が制限されるため、Edit呼び出しには注意が必要
- リボンの非表示はユーザーの操作性に影響するため、適切な復元処理を実装すること

## 備考

- Excel 4.0マクロ（ExecuteExcel4Macro）を使用してリボンの表示/非表示を切り替える
- CommandBars.ExecuteMsoを使用してHideRibbon/MinimizeRibbonを実行
- Mac環境ではMinimizeRibbonのみサポート（Wordの場合）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

リボン状態を表す列挙体を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | stdRibbon.cls | `src/stdRibbon.cls` | ERibbonState列挙体（13-24行目）で全状態を確認 |

**読解のコツ**:
- `RibbonNullState`は初期値（未使用）
- アプリケーション固有の状態（Excel/Word）も列挙体に含まれている
- Macとの互換性を意識した設計

#### Step 2: State Getを理解する

現在のリボン状態取得ロジックを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | stdRibbon.cls | `src/stdRibbon.cls` | State Property Get（33-94行目）の全体構造 |
| 2-2 | stdRibbon.cls | `src/stdRibbon.cls` | アプリケーション別の状態フラグ取得（47-71行目） |
| 2-3 | stdRibbon.cls | `src/stdRibbon.cls` | 状態優先順位の判定（76-93行目） |

**主要処理フロー**:
- **34行目**: ActiveProtectedViewWindowの存在確認
- **47-71行目**: Excel/Wordごとの状態フラグ取得
- **76-93行目**: Select Case Trueで優先順位に従って状態を返す

#### Step 3: State Letを理解する

リボン状態設定ロジックを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | stdRibbon.cls | `src/stdRibbon.cls` | State Property Let（95-177行目）の全体構造 |
| 3-2 | stdRibbon.cls | `src/stdRibbon.cls` | 現在状態からのリセット処理（101-135行目） |
| 3-3 | stdRibbon.cls | `src/stdRibbon.cls` | 目的状態への変更処理（145-176行目） |

**主要処理フロー**:
- **96-98行目**: 現在の状態を取得し、同じならば終了
- **101-135行目**: 各状態からRibbonAlwaysShowRibbonへのリセット
- **139行目**: 状態が変わっていないならばエラー
- **142行目**: 再帰的にRibbonAlwaysShowRibbonへ
- **145-176行目**: RibbonAlwaysShowRibbonから目的状態への変更

#### Step 4: プラットフォーム分岐を理解する

Windows/Mac環境での条件分岐を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | stdRibbon.cls | `src/stdRibbon.cls` | コンパイラ定数（11行目） |
| 4-2 | stdRibbon.cls | `src/stdRibbon.cls` | Mac環境でのMinimizeRibbon処理（126-134行目、167-175行目） |

**読解のコツ**:
- `#If isWindows`で条件コンパイル
- MacではMinimizeRibbonが非同期のため、MacScript("delay 0")で待機
- `GetPressedMso`で現在の状態を確認してからトグル

### プログラム呼び出し階層図

```
stdRibbon.State (Get)
    │
    ├─ Application.ActiveProtectedViewWindow (確認)
    │
    ├─ [Excel] Application.DisplayFullScreen
    ├─ [Excel] CommandBars("Ribbon").Visible
    ├─ [Excel] CommandBars.GetPressedMso("HideRibbon")
    ├─ [Excel] CommandBars.GetPressedMso("MinimizeRibbon")
    │
    ├─ [Word] ActiveWindow.View.FullScreen
    ├─ [Word] ActiveWindow.View.ReadingLayout
    │
    └─ Select Case True → ERibbonState返却

stdRibbon.State (Let)
    │
    ├─ State (Get) で現在状態取得
    │
    ├─ リセット処理
    │      ├─ [ProtectedView] ActiveProtectedViewWindow.Edit
    │      ├─ [WordFullScreen] View.FullScreen = False
    │      ├─ [ExcelFullScreen] DisplayFullScreen = False
    │      ├─ [RibbonNotVisible] ExecuteExcel4Macro("Show.ToolBar")
    │      ├─ [HideRibbon] ExecuteMso("HideRibbon")
    │      └─ [MinimizeRibbon] ExecuteMso("MinimizeRibbon")
    │
    ├─ DoEvents
    │
    ├─ 再帰呼び出し → RibbonAlwaysShowRibbon
    │
    └─ 目的状態への変更
           ├─ [WordFullScreen] View.FullScreen = True
           ├─ [ExcelFullScreen] DisplayFullScreen = True
           ├─ [RibbonNotVisible] ExecuteExcel4Macro("Show.ToolBar")
           ├─ [HideRibbon] ExecuteMso("HideRibbon")
           └─ [MinimizeRibbon] ExecuteMso("MinimizeRibbon")
```

### データフロー図

```
[入力]                         [処理]                          [出力]

                        State Get
                            │
Application APIs ─────▶ 状態フラグ取得 ────▶ ERibbonState
                            │
                        優先順位判定
                            │

ERibbonState ─────────▶ State Let
                            │
                        現在状態取得
                            │
                        リセット処理 ───────▶ CommandBars API
                            │                 / Excel4Macro
                        DoEvents
                            │
                        状態変更処理 ───────▶ CommandBars API
                                              / Excel4Macro
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| stdRibbon.cls | `src/stdRibbon.cls` | ソース | リボン状態管理クラス本体 |
| stdRibbon.cls (WIP) | `src/WIP/stdRibbon.cls` | ソース | 開発中バージョン |
