# 機能設計書 25-stdHTTPAuthenticators

## 概要

本ドキュメントは、stdVBAライブラリにおける`stdHTTPAuthenticators`標準モジュールの機能設計を記述する。stdHTTPAuthenticatorsは、HTTP通信における各種認証方式をサポートするヘルパーモジュールであり、stdHTTPクラスと連携してBasic認証、Windows認証、トークン認証等を実現する。

### 本機能の処理概要

stdHTTPAuthenticatorsは、stdHTTPクラスのAuthenticatorパラメータとして使用可能な認証ヘルパーサブルーチン群を提供する標準モジュールである。各サブルーチンはstdCallbackを通じてバインドされ、HTTPリクエスト時に自動的に認証情報を設定する。

**業務上の目的・背景**：WebAPIやWebサービスとの連携では、様々な認証方式（Basic認証、Windows統合認証、APIトークン等）が使用される。stdHTTPAuthenticatorsは、これらの認証処理を共通化・再利用可能にし、VBAからの安全なHTTP通信を容易にする。認証ロジックをコールバックとして分離することで、テスタビリティと保守性を向上させる。

**機能の利用シーン**：社内システムへのWindows認証付きアクセス、REST APIへのBasic認証付きリクエスト、GitLab/GitHub等のAPIへのトークン認証、OAuth対応サービスへのBearer Token使用などの場面で利用される。

**主要な処理内容**：
1. Windows認証（統合認証）の自動ログオンポリシー設定
2. HTTP Basic認証の資格情報設定
3. カスタムヘッダー（トークン）の設定
4. Digest認証のサポート（開発中）

**関連システム・外部連携**：stdHTTPクラスと連携。stdCallbackを通じてAuthenticatorとして登録。WinHTTP APIを内部で使用。

**権限による制御**：Windows認証はOS資格情報を使用。Basic認証はユーザー名/パスワードを平文で送信するため、HTTPS使用を推奨。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | （画面なし） | 該当なし | 本機能はVBAライブラリであり、UIを持つ画面は存在しない |

## 機能種別

認証処理 / HTTP通信サポート

## 入力仕様

### 入力パラメータ

#### WindowsAuthenticator
| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| pHTTP | Object | Yes | stdHTTP.Create()から渡されるHTTPオブジェクト | - |
| RequestMethod | String | Yes | HTTPメソッド | - |
| sURL | String | Yes | リクエストURL | - |
| ThreadingStyle | Long | Yes | スレッドスタイル | - |
| options | Object | Yes | オプションオブジェクト | - |

#### HttpBasicAuthenticator
| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Username | String | Yes | ユーザー名（Bindで指定） | - |
| Password | String | Yes | パスワード（Bindで指定） | - |
| pHTTP | Object | Yes | HTTPオブジェクト | - |
| RequestMethod | String | Yes | HTTPメソッド | - |
| sURL | String | Yes | リクエストURL | - |
| ThreadingStyle | Long | Yes | スレッドスタイル | - |
| options | Object | Yes | オプションオブジェクト | - |

#### TokenAuthenticator
| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| HeaderName | String | Yes | ヘッダー名（Bindで指定） | - |
| Token | String | Yes | トークン値（Bindで指定） | - |
| pHTTP | Object | Yes | HTTPオブジェクト | - |
| RequestMethod | String | Yes | HTTPメソッド | - |
| sURL | String | Yes | リクエストURL | - |
| ThreadingStyle | Long | Yes | スレッドスタイル | - |
| options | Object | Yes | オプションオブジェクト | - |

#### DigestAuthenticator（開発中）
| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Username | String | Yes | ユーザー名（Bindで指定） | - |
| Password | String | Yes | パスワード（Bindで指定） | - |
| sDomain | String | Yes | 認証ドメイン（Bindで指定） | - |
| pHTTP | Object | Yes | HTTPオブジェクト | - |
| RequestMethod | String | Yes | HTTPメソッド | - |
| sURL | String | Yes | リクエストURL | - |
| ThreadingStyle | Long | Yes | スレッドスタイル | - |
| options | Object | Yes | オプションオブジェクト | - |

### 入力データソース

- stdCallback.Bindで指定された資格情報
- stdHTTP.Createからのリクエストパラメータ

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| - | - | 認証処理結果はpHTTPオブジェクトに設定される |

### 出力先

- pHTTP.SetAutoLogonPolicy（Windows認証）
- pHTTP.SetCredentials（Basic認証）
- pHTTP.SetHeader（トークン認証）

## 処理フロー

### 処理シーケンス

```
1. stdHTTP.Create呼び出し時
   └─ AuthenticatorパラメータにstdCallbackを指定

2. stdCallback.CreateFromModule呼び出し
   └─ モジュール名とサブルーチン名を指定
   └─ 必要に応じてBindで資格情報を結合

3. HTTPリクエスト実行時
   ├─ Authenticatorのコールバックが呼び出される
   └─ 各認証方式に応じた設定がpHTTPに適用される

4. 認証方式別処理
   ├─ WindowsAuthenticator: SetAutoLogonPolicy
   ├─ HttpBasicAuthenticator: SetCredentials
   └─ TokenAuthenticator: SetHeader
```

### フローチャート

```mermaid
flowchart TD
    A[stdHTTP.Create] --> B{Authenticator指定?}
    B -->|No| C[認証なしリクエスト]
    B -->|Yes| D[Authenticatorコールバック実行]
    D --> E{認証方式}
    E -->|Windows| F[SetAutoLogonPolicy Always]
    E -->|Basic| G[SetCredentials Username Password]
    E -->|Token| H[SetHeader HeaderName Token]
    E -->|Digest| I[開発中エラー]
    F --> J[HTTPリクエスト実行]
    G --> J
    H --> J
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-25-01 | Windows認証自動ログオン | AutoLogonPolicy_Alwaysを設定しOS資格情報を使用 | WindowsAuthenticator |
| BR-25-02 | Basic認証平文警告 | ユーザー名/パスワードは平文で送信される | HttpBasicAuthenticator |
| BR-25-03 | サーバー用資格情報 | SetCredentialsはSetCredentialsType_ForServer(0)を使用 | HttpBasicAuthenticator |
| BR-25-04 | Digest認証未完成 | 現在Work In Progressでエラーを発生させる | DigestAuthenticator |

### 計算ロジック

該当なし

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（本機能はデータベース操作を行わない）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | Work in progress | DigestAuthenticatorを使用 | 完成を待つか他の認証方式を使用 |

### リトライ仕様

該当なし（認証失敗時のリトライはstdHTTP側で制御）

## トランザクション仕様

該当なし（本機能はトランザクション制御を行わない）

## パフォーマンス要件

- Digest認証ではキャッシュ機構を実装予定（74行目コメント）
- 認証処理はリクエストごとに実行される

## セキュリティ考慮事項

- Basic認証はユーザー名/パスワードを平文（Base64エンコード）で送信するため、必ずHTTPSを使用すること
- トークン認証のトークンはコード内に直接記述せず、環境変数や設定ファイルから読み込むことを推奨
- Windows認証はOS資格情報を使用するため、適切なアクセス制御が必要

## 備考

- stdCallbackのBindを使用して、資格情報をコールバックに事前結合できる
- DigestAuthenticator（ダイジェスト認証）は開発中であり、現在は使用不可
- DigestAuthInfoユーザー定義型が宣言されているが、DigestAuthenticatorの完成後に使用予定

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Digest認証用のユーザー定義型を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | stdHTTPAuthenticators.bas | `src/stdHTTPAuthenticators.bas` | DigestAuthInfo型（4-8行目）の構造を確認 |

**読解のコツ**:
- `DigestAuthInfo`はDigest認証のチャレンジレスポンスに必要な情報を格納
- Realm、nonce、opaqueはサーバーからのWWW-Authenticateヘッダーから取得

#### Step 2: Windows認証を理解する

最もシンプルなWindows認証の実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | stdHTTPAuthenticators.bas | `src/stdHTTPAuthenticators.bas` | WindowsAuthenticator（19-24行目） |

**主要処理フロー**:
- **20-22行目**: AutoLogonPolicyの定数定義（Always=0, OnlyIfBypassProxy=1, Never=2）
- **23行目**: SetAutoLogonPolicyでAlwaysを設定し、OS資格情報を自動使用

#### Step 3: Basic認証を理解する

HTTP Basic認証の実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | stdHTTPAuthenticators.bas | `src/stdHTTPAuthenticators.bas` | HttpBasicAuthenticator（38-41行目） |

**主要処理フロー**:
- **39行目**: SetCredentialsType_ForServer = 0 の定数定義
- **40行目**: SetCredentialsでユーザー名とパスワードを設定
- **37行目コメント**: HTTPSでの使用を推奨

#### Step 4: トークン認証を理解する

カスタムヘッダーによるトークン認証を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | stdHTTPAuthenticators.bas | `src/stdHTTPAuthenticators.bas` | TokenAuthenticator（54-56行目） |

**主要処理フロー**:
- **55行目**: SetHeaderでヘッダー名とトークン値を設定
- 使用例（52行目）: `PRIVATE-TOKEN`ヘッダーにトークンを設定

#### Step 5: Digest認証（開発中）を理解する

開発中のDigest認証の構造を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | stdHTTPAuthenticators.bas | `src/stdHTTPAuthenticators.bas` | DigestAuthenticator（72-86行目） |

**主要処理フロー**:
- **73行目**: エラーを発生させて未完成を通知
- **74行目**: Dictionaryでキャッシュを管理予定
- **75-85行目**: 初回リクエストでチャレンジを取得し、キャッシュに保存する構想

### プログラム呼び出し階層図

```
stdHTTP.Create (Authenticator指定)
    │
    └─ stdCallback.CreateFromModule("stdHTTPAuthenticators", "認証方式名")
           │
           └─ .Bind(資格情報...)
                  │
                  └─ HTTPリクエスト実行時
                         │
                         └─ Authenticator.Run()
                                │
                                ├─ WindowsAuthenticator
                                │      └─ pHTTP.SetAutoLogonPolicy
                                │
                                ├─ HttpBasicAuthenticator
                                │      └─ pHTTP.SetCredentials
                                │
                                ├─ TokenAuthenticator
                                │      └─ pHTTP.SetHeader
                                │
                                └─ DigestAuthenticator
                                       └─ Err.Raise (開発中)
```

### データフロー図

```
[入力]                         [処理]                          [出力]

Username/Password ────▶ stdCallback.Bind ─────▶ バインド済みコールバック
        │
HeaderName/Token ─────▶ stdCallback.Bind ─────▶ バインド済みコールバック
        │
                        stdHTTP.Create
                            │
                        Authenticator呼び出し
                            │
                ┌───────────┼───────────┐
                │           │           │
        SetAutoLogonPolicy  │    SetHeader
                      SetCredentials
                            │
                        pHTTP設定完了 ────────▶ HTTPリクエスト
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| stdHTTPAuthenticators.bas | `src/stdHTTPAuthenticators.bas` | ソース | 認証ヘルパーモジュール |
| stdHTTP.cls | `src/stdHTTP.cls` | ソース | HTTP通信クラス（連携先） |
| stdCallback.cls | `src/stdCallback.cls` | ソース | コールバック生成クラス（使用方法） |
