# 機能設計書 8-stdJSON

## 概要

本ドキュメントは、stdVBAライブラリにおけるJSONオブジェクト操作クラス `stdJSON` の機能設計を詳細に記述したものである。

### 本機能の処理概要

stdJSONは、VBAでJSONデータを生成、解析、操作するためのクラスである。JSON文字列のパース、オブジェクト/配列の構築、文字列へのシリアライズ、ファイル入出力など、JSONに関する包括的な機能を提供する。

**業務上の目的・背景**：Web API連携やデータ交換においてJSONは標準的なデータ形式となっているが、VBAには標準でJSONを扱う機能がない。stdJSONはこの課題を解決し、VBAからWeb APIを利用したり、JSON形式の設定ファイルを読み書きしたりすることを可能にする。

**機能の利用シーン**：
- Web APIからのJSONレスポンスの解析
- JSON形式の設定ファイルの読み書き
- VBAデータ構造のJSON形式でのエクスポート
- JSONデータの動的な構築と操作
- 他システムとのJSONベースのデータ交換

**主要な処理内容**：
1. JSONオブジェクト/配列の生成（Create, CreateFromParams）
2. JSON文字列のパース（CreateFromString, parseJSONObject, parseJSONArray）
3. ファイルからの読み込み（CreateFromFile）
4. VBA変数からの変換（CreateFromVariant）
5. 要素の追加・更新（Add, AddArray, AddObject）
6. JSON文字列へのシリアライズ（ToString）
7. ファイルへの出力（ToFile）
8. VBAオブジェクトへの変換（ToVBObject）

**関連システム・外部連携**：ファイルシステムへのアクセス（CreateFromFile, ToFile）。Web API連携は呼び出し側で実装。

**権限による制御**：特になし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本クラスはUIを持たないライブラリクラス |

## 機能種別

データ構造（JSON） / シリアライズ/デシリアライズ / データ交換

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| iType | EStdJsonType | No | JSONタイプ（Object/Array）デフォルトObject | - |
| sJSON | String | Yes | JSON文字列（CreateFromString時） | 有効なJSON |
| AllowUnquotedKeys | Boolean | No | 引用符なしキー許可（デフォルトFalse） | - |
| AllowSingleQuoteStrings | Boolean | No | シングルクォート文字列許可（デフォルトFalse） | - |
| StoreLargeNumsAsString | Boolean | No | 大きな数値を文字列保存（デフォルトFalse） | - |
| sJSONFile | String | Yes | JSONファイルパス（CreateFromFile時） | 存在するファイル |
| vData | Variant | Yes | VBAデータ（CreateFromVariant時） | - |
| key | String | No | オブジェクトのキー | - |

### 入力データソース

- JSON文字列
- JSONファイル
- VBA配列、Collection、Dictionary

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| JsonType | EStdJsonType | JSONタイプ（Object/Array） |
| Length | Long | 要素数 |
| Item | Variant | キーまたはインデックスによる要素 |
| Exists | Boolean | キー/インデックスの存在確認 |
| ToString | String | JSON文字列 |
| ToVBObject | Object | Dictionary/Collection |

### 出力先

- ToString: JSON文字列
- ToFile: ファイル出力
- ToVBObject: VBA Dictionary/Collection

## 処理フロー

### 処理シーケンス

```
1. Create(iType)
   └─ protInit: iType設定
   └─ children初期化（Dictionary/Collection）

2. CreateFromString(sJSON)
   └─ パーサープロパティ設定
   └─ 先頭文字判定（{または[）
   └─ parseJSONObject / parseJSONArray呼び出し
   └─ 再帰的にネストされたJSONをパース

3. Add(key, value) / Add(value)
   └─ iType判定
      └─ Object: children.add(key, value)
      └─ Array: children.add(value)

4. ToString(pretty, prettyIndent)
   └─ StringBuffer初期化
   └─ iType判定
   └─ 子要素をループ
      └─ stdJSONなら再帰的にToString
      └─ それ以外はsimpleStringify
   └─ 結果文字列を返却

5. ToVBObject()
   └─ iType判定
      └─ Object: Dictionary作成
      └─ Array: Collection作成
   └─ 子要素をコピー（stdJSONは再帰変換）
```

### フローチャート

```mermaid
flowchart TD
    A[Create呼び出し] --> B{iType}
    B -->|Object| C[children = Dictionary]
    B -->|Array| D[children = Collection]
    C --> E[stdJSON返却]
    D --> E

    F[CreateFromString] --> G[パーサー設定]
    G --> H{先頭文字}
    H -->|"{"| I[parseJSONObject]
    H -->|"["| J[parseJSONArray]
    H -->|Other| K[エラー]
    I --> L[再帰パース]
    J --> L
    L --> E

    M[Add呼び出し] --> N{iType}
    N -->|Object| O[children.add(key,value)]
    N -->|Array| P[children.add(value)]
    O --> Q[stdJSON返却（value=stdJSONの場合）]
    P --> Q

    R[ToString] --> S[StringBuffer初期化]
    S --> T{iType}
    T -->|Object| U["{"出力]
    T -->|Array| V["["出力]
    U --> W[子要素ループ]
    V --> W
    W --> X{stdJSON?}
    X -->|Yes| Y[再帰ToString]
    X -->|No| Z[simpleStringify]
    Y --> AA[結合]
    Z --> AA
    AA --> AB[閉じ括弧出力]
    AB --> AC[文字列返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | JSON種別 | Object（{}）とArray（[]）の2種類 | 全操作 |
| BR-002 | Object格納 | DictionaryベースのKey-Value格納 | eJSONObject時 |
| BR-003 | Array格納 | Collectionベースの順序付き格納 | eJSONArray時 |
| BR-004 | ネスト | stdJSONをネストして階層構造を表現 | Add時 |
| BR-005 | 大数値 | StoreLargeNumsAsString=Trueで精度保持 | CreateFromString時 |
| BR-006 | 拡張構文 | 引用符なしキー、シングルクォートを許可可能 | CreateFromString時 |

### EStdJsonType

```
eJSONObject = 0  ' {} - Dictionary形式
eJSONArray = 1   ' [] - Collection形式
```

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | 本クラスはDBアクセスを行わない |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | パースエラー | 先頭が{または[でない | "Expecting '{' or '['" |
| - | ファイルエラー | ファイルが存在しない | VBAランタイムエラー |
| - | 型エラー | 無効なJSON構文 | パース中にエラー発生 |

### リトライ仕様

リトライ仕様なし

## トランザクション仕様

トランザクション管理なし（メモリ内操作のみ）

## パフォーマンス要件

- CreateFromString: O(n)（JSON文字列長に比例）
- Add: O(1)
- ToString: O(n)（要素数に比例）
- StringBufferによる文字列結合最適化

## セキュリティ考慮事項

- 外部JSON入力のバリデーションは呼び出し側の責任
- ファイル入出力時のパス検証を推奨
- 大きな数値の精度損失に注意（StoreLargeNumsAsString使用）

## 備考

- VB_PredeclaredId = True により、stdJSONをインスタンス化せずにファクトリメソッドを呼び出し可能
- Item.VB_UserMemId = 0 により、デフォルトメンバーとして直接アクセス可能（obj("key")形式）
- メソッドチェーンによる直感的なJSON構築が可能
- UseDictionaryLateBinding = True により、Scripting.Dictionaryを遅延バインディングで使用

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、stdJSONの内部データ構造（EStdJsonType, TParser, TThis）を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | stdJSON.cls | `src/stdJSON.cls` | 67-70行目: EStdJsonType enum |
| 1-2 | stdJSON.cls | `src/stdJSON.cls` | 71-75行目: TParser型（パーサーオプション） |
| 1-3 | stdJSON.cls | `src/stdJSON.cls` | 76-81行目: TThis型（全体状態） |
| 1-4 | stdJSON.cls | `src/stdJSON.cls` | 83-87行目: StringBuffer型 |

**読解のコツ**:
- `EStdJsonType`がObject/Arrayを区別
- `TParser`がパースオプション（引用符なしキー等）を保持
- `TThis.children`がDictionary（Object時）またはCollection（Array時）

#### Step 2: ファクトリメソッドを理解する

Create関数群とprotInit関数を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | stdJSON.cls | `src/stdJSON.cls` | 106-109行目: Createメソッド |
| 2-2 | stdJSON.cls | `src/stdJSON.cls` | 126-141行目: CreateFromStringメソッド |
| 2-3 | stdJSON.cls | `src/stdJSON.cls` | 148-155行目: CreateFromFileメソッド |
| 2-4 | stdJSON.cls | `src/stdJSON.cls` | 161-164行目: CreateFromVariantメソッド |
| 2-5 | stdJSON.cls | `src/stdJSON.cls` | 171-184行目: CreateFromParamsメソッド |
| 2-6 | stdJSON.cls | `src/stdJSON.cls` | 190-198行目: protInit初期化処理 |

**主要処理フロー**:
1. **106行目**: `Create` - 空のJSONオブジェクト/配列を生成
2. **126行目**: `CreateFromString` - JSON文字列をパース
3. **133行目**: 先頭文字判定（{または[）
4. **190-198行目**: `protInit` - iTypeに応じてDictionary/Collectionを初期化

#### Step 3: 要素操作を理解する

Add, AddArray, AddObjectメソッドを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | stdJSON.cls | `src/stdJSON.cls` | 266-275行目: Addメソッド |
| 3-2 | stdJSON.cls | `src/stdJSON.cls` | 284-302行目: AddArrayメソッド |
| 3-3 | stdJSON.cls | `src/stdJSON.cls` | 307-319行目: AddObjectメソッド |

**主要処理フロー**:
- **266-275行目**: Add - iTypeに応じてkey-value追加または値追加
- **284-302行目**: AddArray - 配列を作成して追加（チェーン用）
- **307-319行目**: AddObject - オブジェクトを作成して追加（チェーン用）

#### Step 4: シリアライズを理解する

ToString関数を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | stdJSON.cls | `src/stdJSON.cls` | 415-473行目: ToStringメソッド |

**主要処理フロー**:
- **417-421行目**: pretty表示用のインデント計算
- **423行目**: StringBuffer初期化（パフォーマンス最適化）
- **432-462行目**: iTypeに応じた子要素のシリアライズ
- **438-439行目**: ネストされたstdJSONは再帰的にToString
- **441行目**: プリミティブ値はsimpleStringify

### プログラム呼び出し階層図

```
stdJSON.Create(iType)
    │
    └─ stdJSON.protInit(iType)
           └─ This.children = Dictionary or Collection

stdJSON.CreateFromString(sJSON)
    │
    ├─ パーサープロパティ設定
    │
    └─ parseJSONObject(sJSON) or parseJSONArray(sJSON)
           │
           ├─ 再帰的にネストをパース
           └─ stdJSON.Create() → Add()

stdJSON.Add(key, value) / Add(value)
    │
    └─ This.children.add(key, value) or .add(value)

stdJSON.AddArray(key) / AddObject(key)
    │
    ├─ stdJSON.Create(eJSONArray/eJSONObject)
    │
    └─ Add(key, 新しいstdJSON)

stdJSON.ToString(pretty, prettyIndent)
    │
    ├─ StringBuffer_Create()
    │
    └─ 子要素ループ
           │
           ├─ [stdJSON] → 再帰ToString()
           │
           └─ [その他] → simpleStringify()
```

### データフロー図

```
[入力]                      [処理]                          [出力]

Create(iType) ──────────▶ protInit ──────────────────▶ stdJSON
                              │                          (空)
                              └─▶ children初期化

CreateFromString ───────▶ parseJSONObject/Array ─────▶ stdJSON
                              │                          (パース済み)
                              └─▶ 再帰パース

Add(key, value) ────────▶ children.add ──────────────▶ 更新済みstdJSON
                              │
                              └─▶ stdJSONネストも可

ToString(pretty) ───────▶ StringBuffer構築 ──────────▶ JSON文字列
                              │
                              ├─▶ stdJSON再帰
                              └─▶ simpleStringify

ToVBObject() ───────────▶ Dictionary/Collection構築 ─▶ VBAオブジェクト
                              │
                              └─▶ 再帰変換
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| stdJSON.cls | `src/stdJSON.cls` | ソース | JSONオブジェクト操作クラス |
