---
generated_at: 2026-01-15 10:30:00
metrics:
  claims_total: 35
  claims_with_evidence: 33
  claims_without_evidence: 2
confidence_derived: 0.94
---

# 根拠レポート：1-stdArray

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：33 / 35、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件（計算量）**：理論値に基づく推測
  2. **利用シーン（Excelシートからの読み込み）**：直接的なコード根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/stdArray.cls` 81-97行目（TThis型、SortDirection、SortStruct定義）
- E-02: `src/stdArray.cls` 148-163行目（Createファクトリメソッド）
- E-03: `src/stdArray.cls` 234-242行目（protInit初期化処理）
- E-04: `src/stdArray.cls` 428-450行目（Pushメソッド）
- E-05: `src/stdArray.cls` 454-473行目（Popメソッド）
- E-06: `src/stdArray.cls` 518-527行目（Shiftメソッド）
- E-07: `src/stdArray.cls` 532-558行目（Unshiftメソッド）
- E-08: `src/stdArray.cls` 904-923行目（Mapメソッド）
- E-09: `src/stdArray.cls` 1003-1021行目（Filterメソッド）
- E-10: `src/stdArray.cls` 966-998行目（Reduceメソッド）
- E-11: `src/stdArray.cls` 304-344行目（Sortメソッド）
- E-12: `src/stdArray.cls` 354-394行目（Sort_QuickSortメソッド）
- E-13: `src/stdArray.cls` 1行目（VB_PredeclaredId = True）
- E-14: `src/stdArray.cls` イベント宣言部（BeforeAdd, AfterAdd, BeforeRemove, AfterRemove）
- E-15: `src/stdICallable.cls`（コールバックインターフェース定義）
- E-16: `docs/code-to-docs/機能一覧/機能一覧.csv`（機能定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | stdArrayは動的配列クラスである | E-01, E-04 | ○ |
| C-02 | VBAの標準配列の制限を克服する | E-04（ReDim Preserve自動管理） | ○ |
| C-03 | インデックスは1から始まる（1-based） | E-01（TThis.Length初期値1）, E-04 | ○ |
| C-04 | Push操作で要素追加が可能 | E-04 | ○ |
| C-05 | Pop操作で末尾要素削除が可能 | E-05 | ○ |
| C-06 | Shift操作で先頭要素削除が可能 | E-06 | ○ |
| C-07 | Unshift操作で先頭に要素追加が可能 | E-07 | ○ |
| C-08 | Map処理で各要素を変換できる | E-08 | ○ |
| C-09 | Filter処理で条件に合う要素を抽出できる | E-09 | ○ |
| C-10 | Reduce処理で集約計算ができる | E-10 | ○ |
| C-11 | QuickSortアルゴリズムでソートを行う | E-11, E-12 | ○ |
| C-12 | チャンキングによる効率的な配列拡張 | E-03, E-04（ReDim条件） | ○ |
| C-13 | BeforeAddイベントでキャンセル可能 | E-04（bCancel判定）, E-14 | ○ |
| C-14 | AfterAddイベントが発火する | E-04, E-14 | ○ |
| C-15 | BeforeRemoveイベントでキャンセル可能 | E-05, E-14 | ○ |
| C-16 | AfterRemoveイベントが発火する | E-05, E-14 | ○ |
| C-17 | Map/Filterは新しい配列を返却（不変性） | E-08（Clone使用） | ○ |
| C-18 | bSortInPlace=Trueで元配列を直接ソート可能 | E-11 | ○ |
| C-19 | stdICallableインターフェースと連携 | E-08, E-15 | ○ |
| C-20 | VB_PredeclaredIdによりインスタンス化不要 | E-13 | ○ |
| C-21 | CreateFromArrayでVBA配列から生成可能 | E-02付近のコード | ○ |
| C-22 | CreateFromCollectionでCollectionから生成可能 | E-02付近のコード | ○ |
| C-23 | For Each構文に対応 | NewEnumプロパティ（コード内確認） | ○ |
| C-24 | Cloneで配列複製が可能 | E-08（Map内で使用） | ○ |
| C-25 | 入力パラメータの型定義が正確 | E-02, E-04 | ○ |
| C-26 | 出力データの型定義が正確 | E-01（Length: Long） | ○ |
| C-27 | protInit処理の内容が正確 | E-03 | ○ |
| C-28 | ソートアルゴリズムエラーでstdError.Raise | E-11（エラー処理部分） | ○ |
| C-29 | 行番号148がCreateメソッドの開始位置 | E-02 | ○ |
| C-30 | 行番号428-450がPushメソッドの範囲 | E-04 | ○ |
| C-31 | 行番号904-923がMapメソッドの範囲 | E-08 | ○ |
| C-32 | 行番号354-394がQuickSortの範囲 | E-12 | ○ |
| C-33 | DBアクセスを行わない | E-01〜E-12（DB関連コードなし） | ○ |
| C-34 | Push操作の計算量はO(1)平均、O(n)最悪 | **根拠なし**（理論値） | △ |
| C-35 | Excelシートからのデータ読み込みで使用 | **根拠なし**（用途推測） | △ |

## 4) 不足情報（Unknown / Missing）
- **パフォーマンス要件の計算量**
  - 理由：計算量はアルゴリズム理論に基づく推測であり、実測データやベンチマーク結果は存在しない
  - 候補：パフォーマンステスト結果 / ベンチマークコード / 開発者ドキュメント
- **Excelシートからのデータ読み込み利用シーン**
  - 理由：コード内にExcel連携の直接的な実装は含まれていない（汎用ライブラリのため）
  - 候補：サンプルコード / ユースケースドキュメント / テストコード

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全体的に信頼度が高い（0.94）
- **1: 中リスク** - パフォーマンス要件は理論値のため、実運用での検証推奨
- **0: 低リスク** - 行番号の参照はソースコードと整合

## 6) レビュアーチェックリスト（最小）
- [ ] TThis型の構造（81-97行目）がドキュメントの説明と一致するか確認
- [ ] Pushメソッド（428-450行目）のイベント発火順序を確認
- [ ] Mapメソッド（904-923行目）でClone()を使用し不変性を担保していることを確認
- [ ] QuickSort（354-394行目）のピボット選択ロジックを確認
- [ ] パフォーマンス要件の計算量が実運用で問題ないか検証（必要に応じてベンチマーク実施）
