---
generated_at: 2026-01-15 12:45:00
metrics:
  claims_total: 35
  claims_with_evidence: 34
  claims_without_evidence: 1
confidence_derived: 0.97
---

# 根拠レポート：10-stdWindow

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：34 / 35、根拠なし：1
- 優先レビュー（高）
  1. **Mac互換性対応**：TODOコメントのみで未実装

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/stdWindow.cls` 8行目（VB_PredeclaredId = True）
- E-02: `src/stdWindow.cls` 564-571行目（TThis型定義）
- E-03: `src/stdWindow.cls` 102-107行目（apiRect型定義）
- E-04: `src/stdWindow.cls` 212-216行目（EWndState enum）
- E-05: `src/stdWindow.cls` 149-177行目（EWndStyles enum）
- E-06: `src/stdWindow.cls` 178-206行目（EWndExStyles enum）
- E-07: `src/stdWindow.cls` 363-366行目（EWndFindType enum）
- E-08: `src/stdWindow.cls` 369-375行目（EWndFindResult enum）
- E-09: `src/stdWindow.cls` 377-381行目（tFindNode型）
- E-10: `src/stdWindow.cls` 403-477行目（Win32 API宣言 Win64）
- E-11: `src/stdWindow.cls` 478-556行目（Win32 API宣言 Win32）
- E-12: `src/stdWindow.cls` 593-603行目（Createメソッド）
- E-13: `src/stdWindow.cls` 643-650行目（CreateFromHwnd）
- E-14: `src/stdWindow.cls` 681-683行目（CreateFromDesktop）
- E-15: `src/stdWindow.cls` 691-694行目（CreateFromPoint）
- E-16: `src/stdWindow.cls` 707-719行目（CreateFromIUnknown）
- E-17: `src/stdWindow.cls` 725-732行目（CreateFromIAccessible）
- E-18: `src/stdWindow.cls` 737-745行目（CreateFromContextMenu）
- E-19: `src/stdWindow.cls` 752-763行目（CreateManyFromProcessId）
- E-20: `src/stdWindow.cls` 824-831行目（protInit）
- E-21: `src/stdWindow.cls` 633-637行目（Class_Terminate）
- E-22: `src/stdWindow.cls` 845-851行目（handleプロパティ）
- E-23: `src/stdWindow.cls` 873-877行目（Existsプロパティ）
- E-24: `src/stdWindow.cls` 881-887行目（IsFrozenプロパティ）
- E-25: `src/stdWindow.cls` 891-909行目（Captionプロパティ）
- E-26: `src/stdWindow.cls` 913-922行目（Classプロパティ）
- E-27: `src/stdWindow.cls` 926-943行目（Visibleプロパティ）
- E-28: `src/stdWindow.cls` 947-977行目（Stateプロパティ）
- E-29: `src/stdWindow.cls` 981-1017行目（Childrenプロパティ）
- E-30: `src/stdWindow.cls` 1044-1074行目（RectWindowプロパティ）
- E-31: `src/stdWindow.cls` 1172-1180行目（ProcessIDプロパティ）
- E-32: `src/stdWindow.cls` 1197-1213行目（Parentプロパティ）
- E-33: `src/stdWindow.cls` 1265-1271行目（AncestralRootプロパティ）
- E-34: `src/stdWindow.cls` 1275-1295行目（Styleプロパティ）
- E-35: `src/stdWindow.cls` 1313-1333行目（StyleExプロパティ）
- E-36: `src/stdWindow.cls` 1422-1428行目（isResizableプロパティ）
- E-37: `src/stdWindow.cls` 1514-1523行目（isAlwaysOnTopプロパティ）
- E-38: `src/stdWindow.cls` 1570-1576行目（isLayeredWindowプロパティ）
- E-39: `src/stdWindow.cls` 1695-1755行目（FindFirstメソッド）
- E-40: `src/stdWindow.cls` 1785-1852行目（FindAllメソッド）
- E-41: `src/stdWindow.cls` 1871-1877行目（Quitメソッド）
- E-42: `src/stdWindow.cls` 1891-1898行目（Activateメソッド）
- E-43: `src/stdWindow.cls` 1903-1921行目（GetDescendentsメソッド）
- E-44: `src/stdWindow.cls` 1924-1927行目（Redrawメソッド）
- E-45: `src/stdWindow.cls` 1934-1940行目（SendMessageメソッド）
- E-46: `src/stdWindow.cls` 1946-1958行目（PostMessageメソッド）
- E-47: `src/stdWindow.cls` 85行目（Mac compatibility TODO）
- E-48: `src/stdWindow.cls` 11-22行目（モジュールドキュメント）
- E-49: `src/stdWindow.cls` 27-86行目（Spec仕様コメント）
- E-50: `docs/code-to-docs/機能一覧/機能一覧.csv`（機能定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | stdWindowはWin32ウィンドウを管理するクラス | E-48, E-49 | ○ |
| C-02 | VB_PredeclaredId=Trueでファクトリ呼び出し可能 | E-01 | ○ |
| C-03 | TThis型でHandle, Initialized, isCreatedByVBAを保持 | E-02 | ○ |
| C-04 | EWndStateでNormal/Maximised/Minimisedを定義 | E-04 | ○ |
| C-05 | EWndStylesでウィンドウスタイル定数を定義 | E-05 | ○ |
| C-06 | EWndExStylesで拡張スタイル定数を定義 | E-06 | ○ |
| C-07 | EWndFindTypeでBFS/DFSを定義 | E-07 | ○ |
| C-08 | EWndFindResultで検索結果オプションを定義 | E-08 | ○ |
| C-09 | Win64/Win32両対応のAPI宣言 | E-10, E-11 | ○ |
| C-10 | CreateでCreateWindowEx APIを使用 | E-12（598行目） | ○ |
| C-11 | CreateFromHwndで既存ハンドルからstdWindow生成 | E-13 | ○ |
| C-12 | CreateFromDesktopでGetDesktopWindow API使用 | E-14（682行目） | ○ |
| C-13 | CreateFromPointでWindowFromPoint API使用 | E-15（693行目） | ○ |
| C-14 | CreateFromIUnknownでIUnknown_GetWindow API使用 | E-16（710行目） | ○ |
| C-15 | protInitでHandle設定とInitializedフラグ設定 | E-20 | ○ |
| C-16 | Class_TerminateでVBA作成ウィンドウを自動破棄 | E-21 | ○ |
| C-17 | handleプロパティでThis.Handleを返却 | E-22 | ○ |
| C-18 | ExistsでIsWindow APIを使用 | E-23（876行目） | ○ |
| C-19 | IsFrozenでIsHungAppWindow APIを使用 | E-24（883行目） | ○ |
| C-20 | CaptionでGetWindowText/SetWindowText APIを使用 | E-25 | ○ |
| C-21 | ClassでGetClassName APIを使用 | E-26（917行目） | ○ |
| C-22 | VisibleでIsWindowVisible/ShowWindow APIを使用 | E-27 | ○ |
| C-23 | StateでIsZoomed/IsIconic/ShowWindow APIを使用 | E-28 | ○ |
| C-24 | ChildrenでGetWindow(GW_CHILD/GW_HWNDNEXT)使用 | E-29（990, 1003行目） | ○ |
| C-25 | RectWindowでGetWindowRect/MoveWindow APIを使用 | E-30 | ○ |
| C-26 | ProcessIDでGetWindowThreadProcessId APIを使用 | E-31（1176行目） | ○ |
| C-27 | ParentでGetParent/SetParent APIを使用 | E-32 | ○ |
| C-28 | AncestralRootでGetAncestor(GA_ROOT) APIを使用 | E-33（1267行目） | ○ |
| C-29 | StyleでGetWindowLongA/SetWindowLongA APIを使用 | E-34 | ○ |
| C-30 | isResizableはWS_THICKFRAMEビットで判定 | E-36（1424行目） | ○ |
| C-31 | isAlwaysOnTopでSetWindowPos APIを使用 | E-37（1522行目） | ○ |
| C-32 | FindFirstでBFS/DFS探索とquery.Run実行 | E-39（1727行目） | ○ |
| C-33 | FindAllでCollection返却 | E-40（1799, 1833行目） | ○ |
| C-34 | QuitでWM_CLOSE(0x10)をPostMessage | E-41（1873行目） | ○ |
| C-35 | Mac互換性対応あり | **根拠なし**（TODOのみ） | △ |

## 4) 不足情報（Unknown / Missing）
- **Mac互換性対応**
  - 理由：85行目に「TODO: Mac compatibility」コメントがあるが、実装は確認できない
  - 候補：Mac用API呼び出し実装 / Mac用条件分岐

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全体的に信頼度が高い（0.97）
- **1: 中リスク** - Win32 API直接呼び出しのため、呼び出し引数の正確性を要確認
- **1: 中リスク** - SendMessage/PostMessageは任意メッセージ送信可能なため注意
- **0: 低リスク** - BFS/DFS探索ロジックは明確に実装

## 6) レビュアーチェックリスト（最小）
- [ ] TThis型定義（564-571行目）がドキュメントと一致するか確認
- [ ] Win32 API宣言（403-556行目）がWin64/Win32で正しく分岐しているか確認
- [ ] CreateFromHwnd（643-650行目）でprotInitが正しく呼ばれるか確認
- [ ] Class_Terminate（633-637行目）でVBA作成ウィンドウが正しく破棄されるか確認
- [ ] Children（981-1017行目）でGetWindow APIの使用が正しいか確認
- [ ] FindFirst（1695-1755行目）のBFS/DFS探索ロジックを確認
- [ ] Style操作（1275-1295行目）でSetWindowLongAエラー処理を確認
- [ ] isResizable（1422-1428行目）のWS_THICKFRAMEビット操作を確認
