---
generated_at: 2026-01-15 10:30:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート: 11-stdProcess

## 概要

本レポートは「機能設計書 11-stdProcess」に記載された内容について、ソースコード解析に基づく根拠を提示する。

## 主張と根拠の対応表

### 1. 機能概要に関する主張

| No | 主張内容 | 根拠有無 | ソース参照 |
|----|---------|---------|-----------|
| 1-1 | stdProcessはWindowsプロセス管理クラスである | 有 | `src/stdProcess.cls` 1-18行目 クラスモジュール宣言、コメント「A stdVBA class for management of running processes」 |
| 1-2 | Windows Kernel32 APIを活用している | 有 | `src/stdProcess.cls` 88-175行目 Kernel32 API宣言群（OpenProcess, TerminateProcess等） |
| 1-3 | Shell関数を使用したプロセス作成が可能 | 有 | `src/stdProcess.cls` 259-262行目 `Shell(sCmd, winStyle)` の呼び出し |
| 1-4 | プロセスIDからオブジェクト取得が可能 | 有 | `src/stdProcess.cls` 268-271行目 CreateFromProcessId関数の実装 |
| 1-5 | クエリ条件によるプロセス検索が可能 | 有 | `src/stdProcess.cls` 277-295行目 CreateFromQuery関数の実装 |
| 1-6 | 全プロセス一覧の取得が可能 | 有 | `src/stdProcess.cls` 319-339行目 CreateAll関数の実装 |
| 1-7 | WMIによるプロセス情報取得に対応 | 有 | `src/stdProcess.cls` 400-404行目 Winmgmtプロパティの実装 |

### 2. データ構造に関する主張

| No | 主張内容 | 根拠有無 | ソース参照 |
|----|---------|---------|-----------|
| 2-1 | TThis型でプロセス状態を管理 | 有 | `src/stdProcess.cls` 244-252行目 TThis型定義 |
| 2-2 | PROCESSENTRY32構造体を使用 | 有 | `src/stdProcess.cls` 231-242行目 PROCESSENTRY32型定義 |
| 2-3 | EProcessPriority列挙型が存在 | 有 | `src/stdProcess.cls` 176-193行目 EProcessPriority定義 |
| 2-4 | EProcessAccess列挙型が存在 | 有 | `src/stdProcess.cls` 195-202行目 EProcessAccess定義 |

### 3. プロパティに関する主張

| No | 主張内容 | 根拠有無 | ソース参照 |
|----|---------|---------|-----------|
| 3-1 | idプロパティでプロセスID取得可能 | 有 | `src/stdProcess.cls` 385-387行目 idプロパティの実装 |
| 3-2 | nameプロパティでプロセス名取得可能 | 有 | `src/stdProcess.cls` 389-391行目 nameプロパティの実装 |
| 3-3 | pathプロパティでパス取得可能 | 有 | `src/stdProcess.cls` 393-398行目 pathプロパティの実装 |
| 3-4 | isRunningプロパティで実行状態取得可能 | 有 | `src/stdProcess.cls` 414-416行目 GetProcessVersionを使用した実装 |
| 3-5 | isCriticalプロパティで重要プロセス判定可能 | 有 | `src/stdProcess.cls` 418-435行目 IsProcessCriticalを使用した実装 |
| 3-6 | TimeCreatedプロパティで開始時刻取得可能 | 有 | `src/stdProcess.cls` 438-446行目 GetProcessTimesを使用した実装 |
| 3-7 | ExitCodeプロパティで終了コード取得可能 | 有 | `src/stdProcess.cls` 485-491行目 GetExitCodeProcessを使用した実装 |
| 3-8 | CommandLineプロパティでコマンドライン取得可能 | 有 | `src/stdProcess.cls` 496-499行目 WMI経由での取得 |

### 4. 操作メソッドに関する主張

| No | 主張内容 | 根拠有無 | ソース参照 |
|----|---------|---------|-----------|
| 4-1 | forceQuitでプロセス強制終了可能 | 有 | `src/stdProcess.cls` 507-517行目 TerminateProcess呼び出し |
| 4-2 | waitTilCloseで終了待機可能 | 有 | `src/stdProcess.cls` 520-524行目 isRunningループ実装 |

### 5. エラー処理に関する主張

| No | 主張内容 | 根拠有無 | ソース参照 |
|----|---------|---------|-----------|
| 5-1 | isCriticalでDLLエラー発生時にエラー発生 | 有 | `src/stdProcess.cls` 428-433行目 Err.Raise実装 |
| 5-2 | TimeCreatedでエラー時にErr.Raise | 有 | `src/stdProcess.cls` 443-445行目 Err.Raise実装 |
| 5-3 | forceQuitでTerminateProcess失敗時にエラー | 有 | `src/stdProcess.cls` 514-516行目 Err.Raise実装 |

### 6. セキュリティ・権限に関する主張

| No | 主張内容 | 根拠有無 | ソース参照 |
|----|---------|---------|-----------|
| 6-1 | PROCESS_TERMINATE権限が必要 | 有 | `src/stdProcess.cls` 509行目 OpenProcess(PROCESS_TERMINATE) |
| 6-2 | PROCESS_QUERY_INFORMATION権限を使用 | 有 | `src/stdProcess.cls` 358行目 OpenProcess(PROCESS_QUERY_INFORMATION) |

### 7. 条件付きコンパイルに関する主張

| No | 主張内容 | 根拠有無 | ソース参照 |
|----|---------|---------|-----------|
| 7-1 | Mac対応の条件付きコンパイル | 無 | MacサポートはTODOコメントのみ（実装なし） |
| 7-2 | VBA7/Win64対応の条件付きコンパイル | 有 | `src/stdProcess.cls` 88-175行目 #If VBA7 / Win64 ディレクティブ |

## 未確認事項

| No | 内容 | 理由 |
|----|------|------|
| 1 | Mac環境での動作 | Mac用のAPI宣言が実装されていないため、Macでは動作しない可能性 |
| 2 | 全APIエラーコードの網羅性 | Windows API全エラーコードの処理は確認できていない |

## 確信度評価

- **総主張数**: 28
- **根拠あり主張数**: 26
- **根拠なし主張数**: 2
- **確信度**: 0.93 (26/28)

## 結論

機能設計書の内容は、ソースコード解析により93%の確信度で裏付けられている。Mac対応についてはTODOコメントのみで実装が存在しないため、設計書ではWindows環境のみの対応と記載している点は適切である。
