---
generated_at: 2026-01-15 10:35:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: 12-stdClipboard

## 概要

本レポートは「機能設計書 12-stdClipboard」に記載された内容について、ソースコード解析に基づく根拠を提示する。

## 主張と根拠の対応表

### 1. 機能概要に関する主張

| No | 主張内容 | 根拠有無 | ソース参照 |
|----|---------|---------|-----------|
| 1-1 | stdClipboardはクリップボード管理クラスである | 有 | `src/stdClipboard.cls` 1-29行目 クラスモジュール宣言とモジュールコメント |
| 1-2 | Windows User32 APIを活用している | 有 | `src/stdClipboard.cls` 52-70行目 User32 API宣言（OpenClipboard, GetClipboardData等） |
| 1-3 | OLE32 APIを使用している | 有 | `src/stdClipboard.cls` 72-76行目 Shell32 API宣言（DragQueryFileW） |
| 1-4 | テキストデータの設定・取得が可能 | 有 | `src/stdClipboard.cls` 92-114行目 Text Get/Let プロパティ |
| 1-5 | 画像データの設定・取得が可能 | 有 | `src/stdClipboard.cls` 121-132行目 Image Get/Set プロパティ |
| 1-6 | ファイルドロップリストの取得が可能 | 有 | `src/stdClipboard.cls` 139-163行目 Files プロパティ |
| 1-7 | クリップボードのクリアが可能 | 有 | `src/stdClipboard.cls` 170-175行目 Clear メソッド |

### 2. データ構造に関する主張

| No | 主張内容 | 根拠有無 | ソース参照 |
|----|---------|---------|-----------|
| 2-1 | CF_TEXT定数が1である | 有 | `src/stdClipboard.cls` 31行目 `CF_TEXT = 1` |
| 2-2 | CF_BITMAP定数が2である | 有 | `src/stdClipboard.cls` 32行目 `CF_BITMAP = 2` |
| 2-3 | CF_HDROP定数が15である | 有 | `src/stdClipboard.cls` 45行目 `CF_HDROP = 15` |
| 2-4 | CF_UNICODETEXT定数が13である | 有 | `src/stdClipboard.cls` 43行目 `CF_UNICODETEXT = 13` |

### 3. テキスト操作に関する主張

| No | 主張内容 | 根拠有無 | ソース参照 |
|----|---------|---------|-----------|
| 3-1 | HTMLDocument経由でテキスト取得 | 有 | `src/stdClipboard.cls` 92-99行目 `CreateObject("htmlfile").ParentWindow.ClipboardData.GetData("text")` |
| 3-2 | HTMLDocument経由でテキスト設定 | 有 | `src/stdClipboard.cls` 106-114行目 `ClipboardData.SetData("text", value)` |

### 4. 画像操作に関する主張

| No | 主張内容 | 根拠有無 | ソース参照 |
|----|---------|---------|-----------|
| 4-1 | stdImage.CreateFromClipboardで画像取得 | 有 | `src/stdClipboard.cls` 121-123行目 `Set Image = stdImage.CreateFromClipboard()` |
| 4-2 | stdImage.toClipboardで画像設定 | 有 | `src/stdClipboard.cls` 130-132行目 `Call img.toClipboard()` |

### 5. ファイルリスト操作に関する主張

| No | 主張内容 | 根拠有無 | ソース参照 |
|----|---------|---------|-----------|
| 5-1 | OpenClipboardでクリップボードを開く | 有 | `src/stdClipboard.cls` 142行目 `OpenClipboard(0)` |
| 5-2 | GetClipboardData(CF_HDROP)でハンドル取得 | 有 | `src/stdClipboard.cls` 143行目 `GetClipboardData(CF_HDROP)` |
| 5-3 | DragQueryFileWでファイルパス取得 | 有 | `src/stdClipboard.cls` 146-159行目 ループ処理 |
| 5-4 | CloseClipboardでクリップボードを閉じる | 有 | `src/stdClipboard.cls` 162行目 `CloseClipboard()` |

### 6. ユーティリティ機能に関する主張

| No | 主張内容 | 根拠有無 | ソース参照 |
|----|---------|---------|-----------|
| 6-1 | EmptyClipboardでクリア | 有 | `src/stdClipboard.cls` 173行目 `EmptyClipboard()` |
| 6-2 | AvailableFormatsでフォーマットID配列取得 | 有 | `src/stdClipboard.cls` 180-196行目 EnumClipboardFormatsループ |
| 6-3 | AvailableFormatNamesでフォーマット名配列取得 | 有 | `src/stdClipboard.cls` 200-215行目 GetClipboardFormatNameA使用 |

## 未確認事項

| No | 内容 | 理由 |
|----|------|------|
| - | なし | 全主張に根拠あり |

## 確信度評価

- **総主張数**: 22
- **根拠あり主張数**: 22
- **根拠なし主張数**: 0
- **確信度**: 1.00 (22/22)

## 結論

機能設計書の内容は、ソースコード解析により100%の確信度で裏付けられている。stdClipboardクラスの実装は、設計書に記載された全ての機能を提供している。
