---
generated_at: 2026-01-15 10:40:00
metrics:
  claims_total: 24
  claims_with_evidence: 22
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート: 13-stdAcc

## 概要

本レポートは「機能設計書 13-stdAcc」に記載された内容について、ソースコード解析に基づく根拠を提示する。

## 主張と根拠の対応表

### 1. 機能概要に関する主張

| No | 主張内容 | 根拠有無 | ソース参照 |
|----|---------|---------|-----------|
| 1-1 | stdAccはMSAAアクセシビリティクラスである | 有 | `src/stdAcc.cls` モジュールコメント「A stdVBA class for accessing IAccessible interface」 |
| 1-2 | oleacc.dll APIを活用している | 有 | `src/stdAcc.cls` API宣言部 AccessibleObjectFromWindow, AccessibleChildren等 |
| 1-3 | CreateFromHwndでHWNDから取得可能 | 有 | `src/stdAcc.cls` CreateFromHwnd関数 - AccessibleObjectFromWindow呼び出し |
| 1-4 | CreateFromDesktopでデスクトップ取得可能 | 有 | `src/stdAcc.cls` CreateFromDesktop関数 - GetDesktopWindow使用 |
| 1-5 | CreateFromPointで座標から取得可能 | 有 | `src/stdAcc.cls` CreateFromPoint関数 - AccessibleObjectFromPoint呼び出し |
| 1-6 | FindFirst/FindAllで検索可能 | 有 | `src/stdAcc.cls` FindFirst/FindAll関数 - stdICallableによるクエリ評価 |

### 2. データ構造に関する主張

| No | 主張内容 | 根拠有無 | ソース参照 |
|----|---------|---------|-----------|
| 2-1 | EAccRole列挙型が存在 | 有 | `src/stdAcc.cls` EAccRole列挙型定義（ROLE_TITLEBAR=1 等） |
| 2-2 | EAccState列挙型が存在 | 有 | `src/stdAcc.cls` EAccState列挙型定義（STATE_UNAVAILABLE=&H1 等） |
| 2-3 | ROLE_PUSHBUTTON=43 | 有 | `src/stdAcc.cls` EAccRole定義内 `ROLE_PUSHBUTTON = 43` |
| 2-4 | STATE_FOCUSED=&H4 | 有 | `src/stdAcc.cls` EAccState定義内 `STATE_FOCUSED = &H4` |

### 3. プロパティに関する主張

| No | 主張内容 | 根拠有無 | ソース参照 |
|----|---------|---------|-----------|
| 3-1 | Nameプロパティで名前取得可能 | 有 | `src/stdAcc.cls` Name Getプロパティ - IAccessible::get_accName |
| 3-2 | Roleプロパティで役割取得可能 | 有 | `src/stdAcc.cls` Role Getプロパティ - IAccessible::get_accRole |
| 3-3 | Stateプロパティで状態取得可能 | 有 | `src/stdAcc.cls` State Getプロパティ - IAccessible::get_accState |
| 3-4 | Locationプロパティで位置取得可能 | 有 | `src/stdAcc.cls` Location Getプロパティ - IAccessible::accLocation |
| 3-5 | hwndプロパティでハンドル取得可能 | 有 | `src/stdAcc.cls` hwnd Getプロパティ - WindowFromAccessibleObject |
| 3-6 | Childrenプロパティで子要素取得可能 | 有 | `src/stdAcc.cls` Children Getプロパティ - AccessibleChildren API |

### 4. アクション実行に関する主張

| No | 主張内容 | 根拠有無 | ソース参照 |
|----|---------|---------|-----------|
| 4-1 | DoDefaultActionで既定アクション実行可能 | 有 | `src/stdAcc.cls` DoDefaultAction Sub - IAccessible::accDoDefaultAction |
| 4-2 | SetValueで値設定可能 | 有 | `src/stdAcc.cls` SetValue Sub - IAccessible::set_accValue |
| 4-3 | Selectで選択操作可能 | 有 | `src/stdAcc.cls` Select Sub - IAccessible::accSelect |
| 4-4 | Highlightでビジュアル表示可能 | 有 | `src/stdAcc.cls` Highlight Sub - 一時的な描画オーバーレイ |

### 5. セキュリティに関する主張

| No | 主張内容 | 根拠有無 | ソース参照 |
|----|---------|---------|-----------|
| 5-1 | UAC保護アプリへのアクセス制限 | 部分的 | MSAAの仕様によるものでコード内に直接的記述なし |
| 5-2 | セキュリティソフトによるブロック可能性 | 部分的 | 一般的な知識に基づく記述、コード内に直接的記述なし |

### 6. 条件付きコンパイルに関する主張

| No | 主張内容 | 根拠有無 | ソース参照 |
|----|---------|---------|-----------|
| 6-1 | VBA7/Win64対応の条件付きコンパイル | 有 | `src/stdAcc.cls` #If VBA7 / Win64 ディレクティブによるAPI宣言 |
| 6-2 | PredeclaredId属性あり | 有 | `src/stdAcc.cls` `Attribute VB_PredeclaredId = True` |

## 未確認事項

| No | 内容 | 理由 |
|----|------|------|
| 1 | UAC保護アプリへのアクセス制限 | Windows OSレベルの制限でありコード内に実装なし |
| 2 | セキュリティソフトによるブロック | 外部要因でありコード内に実装なし |

## 確信度評価

- **総主張数**: 24
- **根拠あり主張数**: 22
- **根拠なし主張数**: 2
- **確信度**: 0.92 (22/24)

## 結論

機能設計書の内容は、ソースコード解析により92%の確信度で裏付けられている。セキュリティに関する記述はWindowsプラットフォームの一般的な仕様に基づくものであり、ソースコードには直接的な実装は存在しないが、設計書の内容として適切である。
