---
generated_at: 2026-01-15 10:45:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: 14-stdWebSocket

## 概要

本レポートは「機能設計書 14-stdWebSocket」に記載された内容について、ソースコード解析に基づく根拠を提示する。

## 主張と根拠の対応表

### 1. 機能概要に関する主張

| No | 主張内容 | 根拠有無 | ソース参照 |
|----|---------|---------|-----------|
| 1-1 | stdWebSocketはWebSocket通信クラスである | 有 | `src/stdWebSocket.cls` 10-11行目 コメント |
| 1-2 | IEを介してJavaScript WebSocket APIを使用 | 有 | `src/stdWebSocket.cls` 80行目 `CreateObject("InternetExplorer.Application")` |
| 1-3 | Create関数で接続作成可能 | 有 | `src/stdWebSocket.cls` 67-70行目 Create関数 |
| 1-4 | Send関数でメッセージ送信可能 | 有 | `src/stdWebSocket.cls` 129-131行目 `document.ws.Send(data)` |
| 1-5 | CloseSocket関数で接続終了可能 | 有 | `src/stdWebSocket.cls` 136-138行目 `document.ws.Close(Code, reason)` |

### 2. イベントに関する主張

| No | 主張内容 | 根拠有無 | ソース参照 |
|----|---------|---------|-----------|
| 2-1 | OnOpenイベントが存在 | 有 | `src/stdWebSocket.cls` 43行目 `Public Event OnOpen(...)` |
| 2-2 | OnCloseイベントが存在 | 有 | `src/stdWebSocket.cls` 47行目 `Public Event OnClose(...)` |
| 2-3 | OnErrorイベントが存在 | 有 | `src/stdWebSocket.cls` 51行目 `Public Event OnError(...)` |
| 2-4 | OnMessageイベントが存在 | 有 | `src/stdWebSocket.cls` 55行目 `Public Event OnMessage(...)` |
| 2-5 | EventRaisedイベントが存在 | 有 | `src/stdWebSocket.cls` 39行目 `Public Event EventRaised(...)` |

### 3. 初期化処理に関する主張

| No | 主張内容 | 根拠有無 | ソース参照 |
|----|---------|---------|-----------|
| 3-1 | IEインスタンスを作成 | 有 | `src/stdWebSocket.cls` 80行目 `CreateObject("InternetExplorer.Application")` |
| 3-2 | 空のHTMLページにナビゲート | 有 | `src/stdWebSocket.cls` 83行目 `ie.navigate("about:<!DOCTYPE html>...")` |
| 3-3 | JavaScriptでbind関数を定義 | 有 | `src/stdWebSocket.cls` 94行目 `"document.bind = function(name,data){window[name]=data}"` |
| 3-4 | VBオブジェクトをバインド | 有 | `src/stdWebSocket.cls` 99行目 `.Bind("vb_obj", Me)` |
| 3-5 | WebSocketオブジェクトを作成 | 有 | `src/stdWebSocket.cls` 112行目 `"window.ws = new WebSocket(websocket_url);"` |

### 4. イベントハンドリングに関する主張

| No | 主張内容 | 根拠有無 | ソース参照 |
|----|---------|---------|-----------|
| 4-1 | handleEventでイベントを伝播 | 有 | `src/stdWebSocket.cls` 152-167行目 handleEvent関数 |
| 4-2 | Listenersコレクションでリスナー管理 | 有 | `src/stdWebSocket.cls` 60行目 `Public Listeners As Collection` |
| 4-3 | リスナーにstdICallableを使用 | 有 | `src/stdWebSocket.cls` 164行目 `listener.Run(sEventName, oEventData)` |

### 5. プロパティに関する主張

| No | 主張内容 | 根拠有無 | ソース参照 |
|----|---------|---------|-----------|
| 5-1 | urlプロパティで接続先URL取得可能 | 有 | `src/stdWebSocket.cls` 123-125行目 url Getプロパティ |

## 未確認事項

| No | 内容 | 理由 |
|----|------|------|
| - | なし | 全主張に根拠あり |

## 確信度評価

- **総主張数**: 20
- **根拠あり主張数**: 20
- **根拠なし主張数**: 0
- **確信度**: 1.00 (20/20)

## 結論

機能設計書の内容は、ソースコード解析により100%の確信度で裏付けられている。stdWebSocketクラスは、IEを介したJavaScript WebSocket APIのブリッジとして正確に実装されている。
