---
generated_at: 2026-01-15 11:00:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: 17-stdReg

## 概要

本レポートは「機能設計書 17-stdReg」に記載された内容について、ソースコード解析に基づく根拠を提示する。

## 主張と根拠の対応表

### 1. 機能概要に関する主張

| No | 主張内容 | 根拠有無 | ソース参照 |
|----|---------|---------|-----------|
| 1-1 | stdRegはレジストリ操作クラスである | 有 | `src/stdReg.cls` モジュールコメント |
| 1-2 | advapi32.dll APIを活用している | 有 | `src/stdReg.cls` API宣言部 RegOpenKeyExA, RegQueryValueExA等 |
| 1-3 | レジストリキーのオープンが可能 | 有 | `src/stdReg.cls` Create関数、RegOpenKeyExA呼び出し |
| 1-4 | 値の読み取りが可能 | 有 | `src/stdReg.cls` Value プロパティ、RegQueryValueExA |
| 1-5 | 値の書き込みが可能 | 有 | `src/stdReg.cls` CreateValue関数、RegSetValueExA |
| 1-6 | サブキー列挙が可能 | 有 | `src/stdReg.cls` SubKeys プロパティ、RegEnumKeyExA |

### 2. データ構造に関する主張

| No | 主張内容 | 根拠有無 | ソース参照 |
|----|---------|---------|-----------|
| 2-1 | ERegistryRoot列挙型が存在 | 有 | `src/stdReg.cls` HKEY_CLASSES_ROOT, HKEY_CURRENT_USER等 |
| 2-2 | ERegistryAccess列挙型が存在 | 有 | `src/stdReg.cls` KEY_QUERY_VALUE, KEY_SET_VALUE等 |
| 2-3 | ERegistryValueType列挙型が存在 | 有 | `src/stdReg.cls` REG_SZ, REG_DWORD, REG_BINARY等 |
| 2-4 | HKEY_CLASSES_ROOT=&H80000000 | 有 | `src/stdReg.cls` 定数定義 |
| 2-5 | REG_SZ=1 | 有 | `src/stdReg.cls` ERegistryValueType定義 |

### 3. コンストラクタに関する主張

| No | 主張内容 | 根拠有無 | ソース参照 |
|----|---------|---------|-----------|
| 3-1 | Createでレジストリキーオープン可能 | 有 | `src/stdReg.cls` Create関数 |
| 3-2 | パス解析でルートキーを決定 | 有 | `src/stdReg.cls` getPathParts関数 |
| 3-3 | WOW64ビュー指定をサポート | 有 | `src/stdReg.cls` KEY_WOW64_32KEY, KEY_WOW64_64KEY使用 |

### 4. 値操作に関する主張

| No | 主張内容 | 根拠有無 | ソース参照 |
|----|---------|---------|-----------|
| 4-1 | Valueで値取得可能 | 有 | `src/stdReg.cls` Value Get プロパティ |
| 4-2 | RegQueryValueExAでサイズ取得後データ取得 | 有 | `src/stdReg.cls` Value プロパティの2段階呼び出し |
| 4-3 | REG_SZは文字列に変換 | 有 | `src/stdReg.cls` Value プロパティの型変換処理 |
| 4-4 | REG_DWORDはLongに変換 | 有 | `src/stdReg.cls` Value プロパティの型変換処理 |
| 4-5 | CreateValueで値設定可能 | 有 | `src/stdReg.cls` CreateValue関数、RegSetValueExA |

### 5. 列挙操作に関する主張

| No | 主張内容 | 根拠有無 | ソース参照 |
|----|---------|---------|-----------|
| 5-1 | SubKeysでサブキー列挙可能 | 有 | `src/stdReg.cls` SubKeys プロパティ、RegEnumKeyExAループ |
| 5-2 | ValueNamesで値名列挙可能 | 有 | `src/stdReg.cls` ValueNames プロパティ、RegEnumValueAループ |

### 6. 削除・リソース管理に関する主張

| No | 主張内容 | 根拠有無 | ソース参照 |
|----|---------|---------|-----------|
| 6-1 | DeleteKeyでキー削除可能 | 有 | `src/stdReg.cls` DeleteKey関数、RegDeleteKeyExA |
| 6-2 | DeleteValueで値削除可能 | 有 | `src/stdReg.cls` DeleteValue関数、RegDeleteValueA |
| 6-3 | Class_TerminateでRegCloseKey | 有 | `src/stdReg.cls` Class_Terminate、RegCloseKey呼び出し |

## 未確認事項

| No | 内容 | 理由 |
|----|------|------|
| - | なし | 全主張に根拠あり |

## 確信度評価

- **総主張数**: 24
- **根拠あり主張数**: 24
- **根拠なし主張数**: 0
- **確信度**: 1.00 (24/24)

## 結論

機能設計書の内容は、ソースコード解析により100%の確信度で裏付けられている。stdRegクラスは、Windowsレジストリ操作の包括的な機能を提供している。
