---
generated_at: 2026-01-15 11:05:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: 18-stdImage

## 概要

本レポートは「機能設計書 18-stdImage」に記載された内容について、ソースコード解析に基づく根拠を提示する。

## 主張と根拠の対応表

### 1. 機能概要に関する主張

| No | 主張内容 | 根拠有無 | ソース参照 |
|----|---------|---------|-----------|
| 1-1 | stdImageは画像操作クラスである | 有 | `src/stdImage.cls` モジュールコメント |
| 1-2 | GDI+ APIを活用している | 有 | `src/stdImage.cls` GdiplusStartup, GdipLoadImageFromFile等のAPI宣言 |
| 1-3 | 画像ファイル読み込みが可能 | 有 | `src/stdImage.cls` CreateFromFile関数、GdipLoadImageFromFile |
| 1-4 | クリップボードからの取得が可能 | 有 | `src/stdImage.cls` CreateFromClipboard関数 |
| 1-5 | スクリーンショット取得が可能 | 有 | `src/stdImage.cls` CreateFromScreen, CreateFromHwnd関数 |
| 1-6 | 画像保存が可能 | 有 | `src/stdImage.cls` SaveAs関数、GdipSaveImageToFile |

### 2. データ構造に関する主張

| No | 主張内容 | 根拠有無 | ソース参照 |
|----|---------|---------|-----------|
| 2-1 | EStdImageFormat列挙型が存在 | 有 | `src/stdImage.cls` ImagePNG, ImageBMP, ImageJPEG等 |
| 2-2 | GdiplusStartupInput構造体が存在 | 有 | `src/stdImage.cls` 構造体定義 |
| 2-3 | PNG CLSIDが正しい | 有 | `src/stdImage.cls` {557CF406-1A04-11D3-9A73-0000F81EF32E} |

### 3. 初期化・終了処理に関する主張

| No | 主張内容 | 根拠有無 | ソース参照 |
|----|---------|---------|-----------|
| 3-1 | Class_InitializeでGdiplusStartup | 有 | `src/stdImage.cls` Class_Initialize |
| 3-2 | Class_TerminateでGdipDisposeImage | 有 | `src/stdImage.cls` Class_Terminate |
| 3-3 | Class_TerminateでGdiplusShutdown | 有 | `src/stdImage.cls` Class_Terminate |

### 4. 画像読み込みに関する主張

| No | 主張内容 | 根拠有無 | ソース参照 |
|----|---------|---------|-----------|
| 4-1 | CreateFromFileでファイル読み込み可能 | 有 | `src/stdImage.cls` CreateFromFile関数、GdipLoadImageFromFile |
| 4-2 | CreateFromClipboardでクリップボード取得可能 | 有 | `src/stdImage.cls` CreateFromClipboard関数、GetClipboardData(CF_BITMAP) |
| 4-3 | CreateFromScreenでスクリーンショット取得可能 | 有 | `src/stdImage.cls` CreateFromScreen関数、BitBlt |
| 4-4 | CreateFromHwndでウィンドウキャプチャ可能 | 有 | `src/stdImage.cls` CreateFromHwnd関数 |

### 5. 画像保存に関する主張

| No | 主張内容 | 根拠有無 | ソース参照 |
|----|---------|---------|-----------|
| 5-1 | SaveAsで画像保存可能 | 有 | `src/stdImage.cls` SaveAs関数、GdipSaveImageToFile |
| 5-2 | getEncoderCLSIDでエンコーダー取得 | 有 | `src/stdImage.cls` getEncoderCLSID関数 |

### 6. プロパティに関する主張

| No | 主張内容 | 根拠有無 | ソース参照 |
|----|---------|---------|-----------|
| 6-1 | Widthで幅取得可能 | 有 | `src/stdImage.cls` Width Get プロパティ、GdipGetImageWidth |
| 6-2 | Heightで高さ取得可能 | 有 | `src/stdImage.cls` Height Get プロパティ、GdipGetImageHeight |
| 6-3 | HorizontalResolutionで解像度取得可能 | 有 | `src/stdImage.cls` HorizontalResolution Get プロパティ |
| 6-4 | toClipboardでクリップボードに設定可能 | 有 | `src/stdImage.cls` toClipboard関数 |

## 未確認事項

| No | 内容 | 理由 |
|----|------|------|
| - | なし | 全主張に根拠あり |

## 確信度評価

- **総主張数**: 22
- **根拠あり主張数**: 22
- **根拠なし主張数**: 0
- **確信度**: 1.00 (22/22)

## 結論

機能設計書の内容は、ソースコード解析により100%の確信度で裏付けられている。stdImageクラスは、GDI+を活用した包括的な画像処理機能を提供している。
