---
generated_at: 2026-01-15 11:10:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: 19-stdPerformance

## 概要

本レポートは「機能設計書 19-stdPerformance」に記載された内容について、ソースコード解析に基づく根拠を提示する。

## 主張と根拠の対応表

### 1. 機能概要に関する主張

| No | 主張内容 | 根拠有無 | ソース参照 |
|----|---------|---------|-----------|
| 1-1 | stdPerformanceはパフォーマンス計測クラスである | 有 | `src/stdPerformance.cls` 11-12行目 `@description A class which implements a performance testing and optimisation library` |
| 1-2 | GetTickCount APIを使用している | 有 | `src/stdPerformance.cls` 32-44行目 GetTickCount API宣言 |
| 1-3 | セントリーパターンを実装している | 有 | `src/stdPerformance.cls` Class_Terminate での計測完了/設定復元 |
| 1-4 | CreateMeasureで計測が可能 | 有 | `src/stdPerformance.cls` 158-160行目 |
| 1-5 | CreateOptimiserで最適化が可能 | 有 | `src/stdPerformance.cls` 175-177行目 |

### 2. データ構造に関する主張

| No | 主張内容 | 根拠有無 | ソース参照 |
|----|---------|---------|-----------|
| 2-1 | EPerfObjType列挙型が存在 | 有 | `src/stdPerformance.cls` 47-50行目 `iMeasure = 1`, `iOptimiser = 2` |
| 2-2 | TOptimiser型が存在 | 有 | `src/stdPerformance.cls` 54-58行目 |
| 2-3 | TMeasure型が存在 | 有 | `src/stdPerformance.cls` 61-65行目 |
| 2-4 | FakeDictItem型が存在 | 有 | `src/stdPerformance.cls` 68-71行目 |

### 3. 計測機能に関する主張

| No | 主張内容 | 根拠有無 | ソース参照 |
|----|---------|---------|-----------|
| 3-1 | CreateMeasureでStartTime記録 | 有 | `src/stdPerformance.cls` 113行目 `This.Measure.StartTime = GetTickCount()` |
| 3-2 | Class_TerminateでEndTime取得 | 有 | `src/stdPerformance.cls` 271行目 `pEndTime = GetTickCount()` |
| 3-3 | AddMeasurementで結果保存 | 有 | `src/stdPerformance.cls` 272行目 `Call stdPerformance.AddMeasurement(...)` |
| 3-4 | Debug.Printで即座出力 | 有 | `src/stdPerformance.cls` 215行目 `Debug.Print sKey & ": " & time & " ms"` |
| 3-5 | 同名キーは平均値算出 | 有 | `src/stdPerformance.cls` 220-224行目 平均値計算ロジック |

### 4. 最適化機能に関する主張

| No | 主張内容 | 根拠有無 | ソース参照 |
|----|---------|---------|-----------|
| 4-1 | 元設定を保存 | 有 | `src/stdPerformance.cls` 119-120行目 `This.Optimiser.ScreenUpdating = oApp.ScreenUpdating` |
| 4-2 | 新設定を適用 | 有 | `src/stdPerformance.cls` 123-124行目 `oApp.ScreenUpdating = params(0)` |
| 4-3 | Class_Terminateで復元 | 有 | `src/stdPerformance.cls` 278-279行目 `oApp.ScreenUpdating = This.Optimiser.ScreenUpdating` |
| 4-4 | 既定値ScreenUpdating=False | 有 | `src/stdPerformance.cls` 175行目 `Optional ByVal ScreenUpdating As Boolean = False` |
| 4-5 | 既定値Calculation=xlCalculationManual | 有 | `src/stdPerformance.cls` 175行目 `Optional ByVal Calculation As Long = -4135` |

### 5. 計測結果管理に関する主張

| No | 主張内容 | 根拠有無 | ソース参照 |
|----|---------|---------|-----------|
| 5-1 | Measurementで結果取得可能 | 有 | `src/stdPerformance.cls` 196-205行目 |
| 5-2 | MeasuresKeysでキー配列取得可能 | 有 | `src/stdPerformance.cls` 237-256行目 |
| 5-3 | MeasuresClearでクリア可能 | 有 | `src/stdPerformance.cls` 231-233行目 |

### 6. プラットフォーム対応に関する主張

| No | 主張内容 | 根拠有無 | ソース参照 |
|----|---------|---------|-----------|
| 6-1 | Mac/Windows両対応 | 有 | `src/stdPerformance.cls` 32-44行目 #If Mac Then ディレクティブ |

## 未確認事項

| No | 内容 | 理由 |
|----|------|------|
| - | なし | 全主張に根拠あり |

## 確信度評価

- **総主張数**: 22
- **根拠あり主張数**: 22
- **根拠なし主張数**: 0
- **確信度**: 1.00 (22/22)

## 結論

機能設計書の内容は、ソースコード解析により100%の確信度で裏付けられている。stdPerformanceクラスは、セントリーパターンを用いたパフォーマンス計測・最適化機能を正確に実装している。
