---
generated_at: 2026-01-15 11:15:00
metrics:
  claims_total: 25
  claims_with_evidence: 25
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: 20-stdSentry

## 概要

本レポートは「機能設計書 20-stdSentry」に記載された内容について、ソースコード解析に基づく根拠を提示する。

## 主張と根拠の対応表

### 1. 機能概要に関する主張

| No | 主張内容 | 根拠有無 | ソース参照 |
|----|---------|---------|-----------|
| 1-1 | stdSentryはセンチネルパターン実装クラスである | 有 | `src/stdSentry.cls` 30-37行目 `This class is an attempt to make the sentry pattern easier to implement in VBA` |
| 1-2 | RAII（Resource Acquisition Is Initialization）パターンを実現 | 有 | `src/stdSentry.cls` 30-37行目 センチネルパターンのコメント説明 |
| 1-3 | stdICallableインターフェースを実装 | 有 | `src/stdSentry.cls` 85行目 `Implements stdICallable` |
| 1-4 | With...End Withブロックでスコープ管理 | 有 | `src/stdSentry.cls` 50-52行目 使用例 `With ensureScreenUpdating(False) ... End With` |
| 1-5 | Class_Terminateでクリーンアップ実行 | 有 | `src/stdSentry.cls` 331-341行目 `Private Sub Class_Terminate()` |

### 2. データ構造に関する主張

| No | 主張内容 | 根拠有無 | ソース参照 |
|----|---------|---------|-----------|
| 2-1 | TFactory型が存在（OnInit, OnDestroy, passVars） | 有 | `src/stdSentry.cls` 86-90行目 `Private Type TFactory` |
| 2-2 | TInstance型が存在（onDestroy, DestroyArgs, passVars） | 有 | `src/stdSentry.cls` 91-95行目 `Private Type TInstance` |
| 2-3 | TThis型が存在（Factory, Instance） | 有 | `src/stdSentry.cls` 96-99行目 `Private Type TThis` |
| 2-4 | PredeclaredId属性が設定されている | 有 | `src/stdSentry.cls` 8行目 `Attribute VB_PredeclaredId = True` |

### 3. ファクトリ作成に関する主張

| No | 主張内容 | 根拠有無 | ソース参照 |
|----|---------|---------|-----------|
| 3-1 | Create関数でファクトリ作成 | 有 | `src/stdSentry.cls` 118-121行目 `Public Function Create(...)` |
| 3-2 | protInitFactoryでOnInit/OnDestroy/passVars設定 | 有 | `src/stdSentry.cls` 245-251行目 `Public Sub protInitFactory(...)` |
| 3-3 | passVarsのデフォルト値はTrue | 有 | `src/stdSentry.cls` 118行目 `Optional ByVal passVars as boolean = true` |

### 4. 便利メソッドに関する主張

| No | 主張内容 | 根拠有無 | ソース参照 |
|----|---------|---------|-----------|
| 4-1 | CreateOptimiserでアプリケーション設定最適化 | 有 | `src/stdSentry.cls` 135-163行目 `Public Function CreateOptimiser(...)` |
| 4-2 | CreateOptimiserはstdLambdaを必要とする | 有 | `src/stdSentry.cls` 136行目 `if not isObject(stdLambda) then Err.Raise 5` |
| 4-3 | CreateFromObjectPropertyでプロパティの一時変更と復元 | 有 | `src/stdSentry.cls` 177-189行目 `Public Function CreateFromObjectProperty(...)` |
| 4-4 | CreateFromObjectMethodでメソッドペア呼び出し | 有 | `src/stdSentry.cls` 203-208行目 `Public Function CreateFromObjectMethod(...)` |
| 4-5 | CreateFromObjectMethodはstdCallbackを必要とする | 有 | `src/stdSentry.cls` 204行目 `if not isObject(stdCallback) then Err.Raise 5` |
| 4-6 | CreateErrorStackでエラースタック管理 | 有 | `src/stdSentry.cls` 222-225行目 `Public Function CreateErrorStack(...)` |
| 4-7 | CreateErrorStackはstdErrorを必要とする | 有 | `src/stdSentry.cls` 223行目 `if not isObject(stdError) then Err.Raise 5` |
| 4-8 | CreateFromAutomationSecurityで自動化セキュリティ設定 | 有 | `src/stdSentry.cls` 237-239行目 `Public Function CreateFromAutomationSecurity(...)` |

### 5. センチネル実行に関する主張

| No | 主張内容 | 根拠有無 | ソース参照 |
|----|---------|---------|-----------|
| 5-1 | Run関数でセンチネル作成 | 有 | `src/stdSentry.cls` 269-273行目 `Public Function Run(...)` |
| 5-2 | RunはVB_UserMemId = 0属性（既定メンバー） | 有 | `src/stdSentry.cls` 270行目 `Attribute Run.VB_UserMemId = 0` |
| 5-3 | RunExでOnInit実行後にdestroyArgs取得 | 有 | `src/stdSentry.cls` 280行目 `Dim destroyArgs: destroyArgs = This.Factory.OnInit.RunEx(args)` |
| 5-4 | protInitInstanceでインスタンス初期化 | 有 | `src/stdSentry.cls` 258-264行目 `Public Sub protInitInstance(...)` |

### 6. クリーンアップに関する主張

| No | 主張内容 | 根拠有無 | ソース参照 |
|----|---------|---------|-----------|
| 6-1 | Class_TerminateでpassVarsに応じた処理分岐 | 有 | `src/stdSentry.cls` 334-338行目 `if this.Instance.passVars then ... else ...` |
| 6-2 | passVars=TrueならOnDestroy.RunEx(DestroyArgs) | 有 | `src/stdSentry.cls` 335行目 `Call .OnDestroy.RunEx(.DestroyArgs)` |
| 6-3 | passVars=FalseならOnDestroy.Run | 有 | `src/stdSentry.cls` 337行目 `Call .OnDestroy.Run` |

### 7. stdICallable実装に関する主張

| No | 主張内容 | 根拠有無 | ソース参照 |
|----|---------|---------|-----------|
| 7-1 | SendMessageでメタ情報アクセス可能 | 有 | `src/stdSentry.cls` 311-328行目 `Public Function SendMessage(...)` |

## 未確認事項

| No | 内容 | 理由 |
|----|------|------|
| - | なし | 全主張に根拠あり |

## 確信度評価

- **総主張数**: 25
- **根拠あり主張数**: 25
- **根拠なし主張数**: 0
- **確信度**: 1.00 (25/25)

## 結論

機能設計書の内容は、ソースコード解析により100%の確信度で裏付けられている。stdSentryクラスは、stdICallableインターフェースを活用したセンチネルパターン（RAII）を正確に実装しており、リソースの確実な解放や設定の確実な復元を保証する機能を提供している。
