---
generated_at: 2026-01-15 19:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：21-stdTimer.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件の精度保証**：定量的根拠なし
  2. **VBOMセキュリティリスク**：一般的知識に基づく
  3. **SafeTimersとの比較詳細**：コメントのみで検証困難

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/stdTimer.cls` 11-39行目（モジュールコメント）
- E-02: `src/stdTimer.cls` 45行目（Tickイベント宣言）
- E-03: `src/stdTimer.cls` 47-49行目（クラス変数宣言）
- E-04: `src/stdTimer.cls` 56-59行目（Create関数）
- E-05: `src/stdTimer.cls` 65-72行目（protInit関数）
- E-06: `src/stdTimer.cls` 76-90行目（createRemoteWorkbook関数）
- E-07: `src/stdTimer.cls` 97-103行目（injectCode関数）
- E-08: `src/stdTimer.cls` 107-110行目（getVBOM関数）
- E-09: `src/stdTimer.cls` 116-131行目（setVBOM関数）
- E-10: `src/stdTimer.cls` 136-168行目（getTimerCode関数）
- E-11: `src/stdTimer.cls` 171-174行目（Class_Terminate）
- E-12: `src/stdTimer.cls` 179-182行目（SheetChangeイベント）
- E-13: `docs/code-to-docs/機能一覧/機能一覧.csv` 22行目（機能説明）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | VBAで指定間隔でのTickイベント発生とコールバック実行を実現 | E-02, E-12 | ○ |
| C-02 | リモートワークブックを使用した独自アーキテクチャ | E-01 (29-38行目), E-06 | ○ |
| C-03 | ミリ秒単位の精度でタイマーイベントを発生 | E-04, E-10 (155行目) | ○ |
| C-04 | VBOM（Visual Basic Object Model）の有効化確認と自動有効化 | E-05 (67行目), E-08, E-09 | ○ |
| C-05 | 新しいExcelアプリケーションインスタンスの作成 | E-06 (78行目) | ○ |
| C-06 | タイマーコードの動的注入 | E-07, E-10 | ○ |
| C-07 | WorksheetChangeイベントを介したTickイベントの発火 | E-10 (154行目), E-12 | ○ |
| C-08 | stdICallableインターフェースを実装したコールバック連携 | E-03 (49行目), E-12 (181行目) | ○ |
| C-09 | Windows/Mac両環境でのSleep API呼び出し | E-10 (138-150行目) | ○ |
| C-10 | クラス終了時のリモートワークブック自動クリーンアップ | E-11 | ○ |
| C-11 | MsgBoxやInputBox表示中はTickイベントが発生しない | E-01 (19行目) | ○ |
| C-12 | デバッグ中はタイマーイベントは発生しない | E-01 (25行目) | ○ |
| C-13 | Edit/Pointモード中もイベントは発火する | E-01 (20行目) | ○ |
| C-14 | COMイベントを使用するため、イベントは同期的に処理される | E-01 (22行目) | ○ |
| C-15 | SafeTimersプロジェクトからインスピレーション | E-01 (11-12行目) | ○ |
| C-16 | DEBUG_MODE定数でデバッグ時に表示可能 | E-06 (80-85行目) | ○ |
| C-17 | iMillisecondsパラメータは正の整数値が必要 | E-04 | ○ |
| C-18 | 完全な精度は保証されない | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の「完全な精度は保証されない」について定量的なベンチマークデータなし
  - 候補：パフォーマンステスト結果 / サンプルコードでの実測値 / ライブラリREADME

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コードコメントと一致する記述が多く、信頼性は高い
- 1: 中リスク - VBOMセキュリティに関する記述は一般的知識に基づく
- 0: 低リスク - 処理フローはコード構造と整合している

## 6) レビュアーチェックリスト（最小）
- [ ] VBOMの自動有効化がセキュリティポリシーに適合するか確認
- [ ] Mac環境でのSleep実装（usleep）が正しく動作するか検証
- [ ] リモートワークブックのメモリ使用量への影響を確認
- [ ] SafeTimersとの具体的な機能差異が業務要件に適合するか検討
