---
generated_at: 2026-01-15 19:12:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：23-stdUIElement.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **MVVM/MVCパターンの実装補助**：一般的な説明のみで具体的実装例なし
  2. **パフォーマンス要件（MouseMove）**：具体的なフィルタリング実装なし
  3. **BindGlobalsの詳細**：SendMessageの動作詳細未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/stdUIElement.cls` 12-27行目（EUIElementEvent列挙体）
- E-02: `src/stdUIElement.cls` 28-51行目（EUIElementType列挙体）
- E-03: `src/stdUIElement.cls` 52-59行目（TThis型定義）
- E-04: `src/stdUIElement.cls` 62-76行目（WithEvents変数宣言）
- E-05: `src/stdUIElement.cls` 79-81行目（CaptionSupport/ValueSupportコメント）
- E-06: `src/stdUIElement.cls` 89-93行目（CreateFromControl関数）
- E-07: `src/stdUIElement.cls` 107-142行目（CreateFromType関数）
- E-08: `src/stdUIElement.cls` 146-176行目（プロパティ定義）
- E-09: `src/stdUIElement.cls` 180-218行目（Value Get/Let/Set）
- E-10: `src/stdUIElement.cls` 206-218行目（Caption Get/Let）
- E-11: `src/stdUIElement.cls` 222-266行目（Left/Top/Width/Height）
- E-12: `src/stdUIElement.cls` 281-360行目（protInit関数）
- E-13: `src/stdUIElement.cls` 364-370行目（getGUID関数）
- E-14: `src/stdUIElement.cls` 375-378行目（BindGlobals関数）
- E-15: `src/stdUIElement.cls` 383-404行目（protUIElementEventLookup関数）
- E-16: `src/stdUIElement.cls` 423-439行目（Clickイベントハンドラ）
- E-17: `src/stdUIElement.cls` 448-457行目（Changeイベントハンドラ）
- E-18: `src/stdUIElement.cls` 463-503行目（Keyboardイベントハンドラ）
- E-19: `src/stdUIElement.cls` 509-571行目（Mouseイベントハンドラ）
- E-20: `src/stdUIElement.cls` 573-578行目（callEventCB関数）
- E-21: `docs/code-to-docs/機能一覧/機能一覧.csv` 24行目（機能説明）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MSFormsコントロールのラッパークラス | E-02, E-12 | ○ |
| C-02 | イベントルーティングと統一的なコントロール操作 | E-16, E-17, E-20 | ○ |
| C-03 | EUIElementEvent列挙体でサポートイベントを定義 | E-01 | ○ |
| C-04 | EUIElementType列挙体でサポートコントロールを定義 | E-02 | ○ |
| C-05 | TThis型で内部状態を管理 | E-03 | ○ |
| C-06 | WithEvents変数でイベントシンクを実現 | E-04 | ○ |
| C-07 | CreateFromControlで既存コントロールをラップ | E-06 | ○ |
| C-08 | CreateFromTypeで新規コントロールを作成 | E-07 | ○ |
| C-09 | protInitでコントロールタイプを自動判定 | E-12 (285-359行目) | ○ |
| C-10 | GUIDを用いた一意識別 | E-13, E-03 (58行目) | ○ |
| C-11 | UUID v4形式のGUID生成 | E-13 (365行目) | ○ |
| C-12 | callEventCBで(el, event, params)形式の呼び出し | E-20 | ○ |
| C-13 | Captionサポートは特定コントロールのみ | E-05 (79行目), E-10 | ○ |
| C-14 | Valueサポートは特定コントロールのみ | E-05 (80行目), E-09 | ○ |
| C-15 | CheckBoxのLeft位置補正ロジック | E-11 (231行目) | ○ |
| C-16 | ScrollBar/SpinButtonはClickイベント未サポート | E-16 (422行目コメント) | ○ |
| C-17 | Image/TextBoxはMouseDownでMouseClickを補完 | E-19 (520-527行目) | ○ |
| C-18 | BindGlobalsでEUIElementEvent定数を注入 | E-14, E-15 | ○ |
| C-19 | protUIElementEventLookupで名前→値マッピングを提供 | E-15 | ○ |
| C-20 | DblClickイベントをサポート | E-19 (557-568行目) | ○ |
| C-21 | AddControlイベントをサポート（親コントロール） | E-16 (442-444行目) | ○ |
| C-22 | MVVM/MVCパターンの実装補助として使用可能 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- MVVM/MVCパターン実装の具体的なサンプルコード
  - 候補：サンプルプロジェクト / ドキュメント / テストコード
- MouseMoveイベントのフィルタリング実装例
  - 候補：サンプルコード / ベストプラクティスガイド

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - イベントハンドラの実装パターンは一貫している
- 1: 中リスク - BindGlobalsの内部動作（SendMessage）の詳細確認が必要
- 0: 低リスク - コントロールタイプ判定ロジックは網羅的

## 6) レビュアーチェックリスト（最小）
- [ ] 全てのEUIElementTypeに対応するprotInitのTypeOf判定が実装されているか確認
- [ ] DblClickイベントでSpinButton/ScrollBar/Imageのサポートが「TODO」のままか確認（569-571行目）
- [ ] CheckBoxのLeft補正ロジックが意図通りか検証
- [ ] BindGlobalsのSendMessage("bindGlobal")がstdICallable側で正しく処理されるか確認
- [ ] MouseMoveの高頻度イベント発生がパフォーマンスに与える影響を評価
