---
generated_at: 2026-01-15 19:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：24-stdRibbon.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **キオスクアプリケーション構築**：一般的な利用シーン記述で具体例なし
  2. **Mac環境でのMinimizeRibbon動作**：MacScript使用の検証必要
  3. **RibbonNotVisibleのWordサポート**：メカニズム未確認のコメントあり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/stdRibbon.cls` 11行目（コンパイラ定数）
- E-02: `src/stdRibbon.cls` 13-24行目（ERibbonState列挙体）
- E-03: `src/stdRibbon.cls` 26-31行目（リボン状態コメント）
- E-04: `src/stdRibbon.cls` 33-94行目（State Property Get）
- E-05: `src/stdRibbon.cls` 47-57行目（Excel固有状態取得）
- E-06: `src/stdRibbon.cls` 59-70行目（Word固有状態取得）
- E-07: `src/stdRibbon.cls` 76-93行目（状態優先順位判定）
- E-08: `src/stdRibbon.cls` 95-177行目（State Property Let）
- E-09: `src/stdRibbon.cls` 101-135行目（リセット処理）
- E-10: `src/stdRibbon.cls` 145-176行目（状態変更処理）
- E-11: `src/stdRibbon.cls` 118-119行目（Excel4Macro使用）
- E-12: `src/stdRibbon.cls` 126-134行目（Mac MinimizeRibbon処理）
- E-13: `docs/code-to-docs/機能一覧/機能一覧.csv` 25行目（機能説明）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | リボンUI状態を管理するクラス | E-02, E-04, E-08 | ○ |
| C-02 | ERibbonState列挙体で状態を定義 | E-02 | ○ |
| C-03 | RibbonFullScreenMode（HideRibbon） | E-02 (15行目), E-09 (120-121行目) | ○ |
| C-04 | RibbonShowTabsOnly（MinimizeRibbon） | E-02 (16行目), E-09 (122-134行目) | ○ |
| C-05 | RibbonAlwaysShowRibbon状態 | E-02 (17行目), E-07 (91-92行目) | ○ |
| C-06 | RibbonNotVisible状態 | E-02 (18行目), E-05 (51行目) | ○ |
| C-07 | RibbonProtectedViewMode状態 | E-02 (19行目), E-07 (77-78行目) | ○ |
| C-08 | ExcelApplicationDisplayFullScreenMode | E-02 (20行目), E-05 (50行目) | ○ |
| C-09 | WordViewFullScreenMode | E-02 (21行目), E-06 (61行目) | ○ |
| C-10 | WordViewReadMode | E-02 (22行目), E-06 (62行目) | ○ |
| C-11 | 状態優先順位（ProtectedView最優先） | E-07 | ○ |
| C-12 | 段階的リセット（RibbonAlwaysShowRibbon経由） | E-09, E-08 (142行目) | ○ |
| C-13 | ProtectedViewへの変更は不可 | E-10 (148-149行目) | ○ |
| C-14 | Excel4Macro使用（Show.ToolBar） | E-11 | ○ |
| C-15 | Mac環境でMinimizeRibbon非同期 | E-12 (126-134行目) | ○ |
| C-16 | MacScript("delay 0")で待機 | E-12 (132行目) | ○ |
| C-17 | DoEventsで状態変更反映を待機 | E-08 (136行目) | ○ |
| C-18 | キオスクアプリケーション構築に有用 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- キオスクアプリケーション構築の具体的なサンプルコード
  - 候補：サンプルプロジェクト / ドキュメント / ブログ記事
- RibbonNotVisibleのWordサポートメカニズム
  - E-10 (160行目): "A mechanism for Word is yet to be discovered"

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ERibbonState列挙体と実装が一致している
- 1: 中リスク - Mac環境でのMinimizeRibbon動作検証が必要
- 1: 中リスク - RibbonNotVisibleのWordサポートが未完成

## 6) レビュアーチェックリスト（最小）
- [ ] Mac環境でMinimizeRibbonが正しく動作するか検証
- [ ] Excel4Macro("Show.ToolBar")が最新のExcelバージョンで動作するか確認
- [ ] ProtectedViewからの復帰（Edit呼び出し）が適切に動作するか検証
- [ ] 再帰呼び出し（142行目）が無限ループにならないか確認
- [ ] 状態変更失敗時のエラー（139行目）がユーザーに適切に通知されるか確認
