---
generated_at: 2026-01-15 19:18:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：25-stdHTTPAuthenticators.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **OAuth/Bearer Token対応**：一般的な利用シーン記述で具体的実装なし
  2. **DigestAuthenticatorの未完成**：エラーを発生させる状態
  3. **stdHTTPとの連携詳細**：stdHTTP側のAuthenticator呼び出しメカニズム未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/stdHTTPAuthenticators.bas` 1行目（モジュール宣言）
- E-02: `src/stdHTTPAuthenticators.bas` 4-8行目（DigestAuthInfo型）
- E-03: `src/stdHTTPAuthenticators.bas` 10-24行目（WindowsAuthenticator）
- E-04: `src/stdHTTPAuthenticators.bas` 26-41行目（HttpBasicAuthenticator）
- E-05: `src/stdHTTPAuthenticators.bas` 43-56行目（TokenAuthenticator）
- E-06: `src/stdHTTPAuthenticators.bas` 59-86行目（DigestAuthenticator）
- E-07: `src/stdHTTPAuthenticators.bas` 16-18行目（WindowsAuthenticator使用例コメント）
- E-08: `src/stdHTTPAuthenticators.bas` 34-36行目（HttpBasicAuthenticator使用例コメント）
- E-09: `src/stdHTTPAuthenticators.bas` 51-53行目（TokenAuthenticator使用例コメント）
- E-10: `docs/code-to-docs/機能一覧/機能一覧.csv` 26行目（機能説明）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HTTP通信における各種認証方式をサポート | E-03, E-04, E-05 | ○ |
| C-02 | stdHTTPクラスと連携 | E-07, E-08, E-09 | ○ |
| C-03 | DigestAuthInfo型でDigest認証情報を格納 | E-02 | ○ |
| C-04 | WindowsAuthenticatorはAutoLogonPolicy_Alwaysを設定 | E-03 (20-23行目) | ○ |
| C-05 | HttpBasicAuthenticatorはSetCredentialsを使用 | E-04 (39-40行目) | ○ |
| C-06 | Basic認証はHTTPSでの使用を推奨 | E-04 (37行目コメント) | ○ |
| C-07 | TokenAuthenticatorはSetHeaderを使用 | E-05 (55行目) | ○ |
| C-08 | DigestAuthenticatorは開発中でエラーを発生 | E-06 (73行目) | ○ |
| C-09 | DigestAuthenticatorでキャッシュ機構を計画 | E-06 (74行目) | ○ |
| C-10 | stdCallback.Bindで資格情報を事前結合 | E-08, E-09 | ○ |
| C-11 | AutoLogonPolicy定数（Always=0, OnlyIfBypassProxy=1, Never=2） | E-03 (20-22行目) | ○ |
| C-12 | SetCredentialsType_ForServer = 0 | E-04 (39行目) | ○ |
| C-13 | 標準モジュール（.bas）として実装 | E-01, E-10 | ○ |
| C-14 | PRIVATE-TOKENヘッダーの使用例 | E-09 (52行目) | ○ |
| C-15 | OAuth/Bearer Token対応 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- OAuth/Bearer Tokenの具体的な実装サンプル
  - 候補：TokenAuthenticatorでAuthorization: Bearerヘッダーを設定する例
- stdHTTP側のAuthenticator呼び出しメカニズムの詳細
  - 候補：stdHTTP.cls のソースコード確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 実装済み認証方式（Windows、Basic、Token）は機能的
- 2: 高リスク - DigestAuthenticatorは未完成でエラーを発生させる
- 1: 中リスク - Basic認証のセキュリティ警告が十分に伝わるか確認必要

## 6) レビュアーチェックリスト（最小）
- [ ] stdHTTP側でAuthenticatorがどのタイミングで呼び出されるか確認
- [ ] Basic認証使用時のHTTPS強制チェックが必要か検討
- [ ] DigestAuthenticatorの完成ロードマップを確認
- [ ] AutoLogonPolicy_OnlyIfBypassProxyの使用シーンを確認
- [ ] TokenAuthenticatorでBearer Tokenを設定する例をドキュメントに追加検討
