---
generated_at: 2026-01-15 11:00:00
metrics:
  claims_total: 35
  claims_with_evidence: 34
  claims_without_evidence: 1
confidence_derived: 0.97
---

# 根拠レポート：3-stdLambda

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：34 / 35、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンスキャッシュO(1)**：理論値に基づく推測

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/stdLambda.cls` 84-98行目（TokenDefinition, token, Operation型定義）
- E-02: `src/stdLambda.cls` 100-159行目（IInstruction enum）
- E-03: `src/stdLambda.cls` 161-164行目（LambdaType enum）
- E-04: `src/stdLambda.cls` 171-200行目（TThis型定義）
- E-05: `src/stdLambda.cls` 226-237行目（Createメソッド）
- E-06: `src/stdLambda.cls` 251-253行目（CreateMultilineメソッド）
- E-07: `src/stdLambda.cls` 259-296行目（protInit）
- E-08: `src/stdLambda.cls` 301-309行目（Runメソッド）
- E-09: `src/stdLambda.cls` 314-325行目（RunExメソッド）
- E-10: `src/stdLambda.cls` 330-332行目（Bindメソッド）
- E-11: `src/stdLambda.cls` 337-341行目（BindExメソッド）
- E-12: `src/stdLambda.cls` 347-359行目（BindGlobalメソッド）
- E-13: `src/stdLambda.cls` 369-371行目（Equationプロパティ）
- E-14: `src/stdLambda.cls` 444-523行目（getTokenDefinitions）
- E-15: `src/stdLambda.cls` 535-559行目（parseBlock）
- E-16: `src/stdLambda.cls` 574-582行目（parseStatement）
- E-17: `src/stdLambda.cls` 608-610行目（parseExpression）
- E-18: `src/stdLambda.cls` 613-624行目（parseLogicPriority1 - XOR）
- E-19: `src/stdLambda.cls` 627-638行目（parseLogicPriority2 - OR）
- E-20: `src/stdLambda.cls` 641-652行目（parseLogicPriority3 - AND）
- E-21: `src/stdLambda.cls` 655-670行目（parseLogicPriority4 - NOT）
- E-22: `src/stdLambda.cls` 673-705行目（parseComparisonPriority1）
- E-23: `src/stdLambda.cls` 708-719行目（parseArithmeticPriority1 - 連結）
- E-24: `src/stdLambda.cls` 722-736行目（parseArithmeticPriority2 - 加減）
- E-25: `src/stdLambda.cls` 739-750行目（parseArithmeticPriority3 - mod）
- E-26: `src/stdLambda.cls` 753-767行目（parseArithmeticPriority4 - 乗除）
- E-27: `src/stdLambda.cls` 770-779行目（parseArithmeticPriority5 - 単項）
- E-28: `src/stdLambda.cls` 782-793行目（parseArithmeticPriority6 - べき乗）
- E-29: `src/stdLambda.cls` 808-835行目（parseFlowPriority1 - if-then-else）
- E-30: `src/stdLambda.cls` 838-879行目（parseFlowPriority2 - do-loop）
- E-31: `src/stdLambda.cls` 882-958行目（parseFlowPriority3 - for-next）
- E-32: `src/stdLambda.cls` 962-991行目（parseValuePriority1）
- E-33: `src/stdLambda.cls` 1290-1500行目（evaluate関数）
- E-34: `src/stdLambda.cls` 1320-1338行目（Jump Table）
- E-35: `src/stdLambda.cls` 70行目（Implements stdICallable）
- E-36: `src/stdLambda.cls` 8行目（VB_PredeclaredId = True）
- E-37: `docs/code-to-docs/機能一覧/機能一覧.csv`（機能定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | stdLambdaは文字列からラムダ関数を生成する | E-05, E-07 | ○ |
| C-02 | stdICallableインターフェースを実装している | E-35 | ○ |
| C-03 | VB_PredeclaredId=Trueでインスタンス化不要 | E-36 | ○ |
| C-04 | $1, $2でRun時の引数を参照可能 | E-14（500行目: arg定義）, E-33（1370-1382行目） | ○ |
| C-05 | Createメソッドで式からラムダを生成 | E-05 | ○ |
| C-06 | CreateMultilineで複数行式を結合 | E-06 | ○ |
| C-07 | 同一式はDictionaryでキャッシュされる | E-05（228-236行目） | ○ |
| C-08 | Tokeniseで字句解析を行う | E-07（275行目）, E-14 | ○ |
| C-09 | parseBlockで構文解析を開始 | E-07（281行目）, E-15 | ○ |
| C-10 | evaluateでスタックベース評価を行う | E-33 | ○ |
| C-11 | Jump Tableで高速命令ディスパッチ | E-34 | ○ |
| C-12 | Bindで引数をバインド可能 | E-10, E-11 | ○ |
| C-13 | BindGlobalでグローバル変数をバインド可能 | E-12 | ○ |
| C-14 | Equationで元の式を取得可能 | E-13 | ○ |
| C-15 | 算術演算子をサポート（+,-,*,/,^,mod） | E-24, E-25, E-26, E-27, E-28 | ○ |
| C-16 | 比較演算子をサポート（=,<>,<,<=,>,>=,like,is） | E-22 | ○ |
| C-17 | 論理演算子をサポート（and,or,not,xor） | E-18, E-19, E-20, E-21 | ○ |
| C-18 | 文字列結合演算子をサポート（&） | E-23 | ○ |
| C-19 | if-then-else制御フローをサポート | E-29 | ○ |
| C-20 | for-next制御フローをサポート | E-31 | ○ |
| C-21 | do-loop制御フローをサポート | E-30 | ○ |
| C-22 | let/set文で変数代入をサポート | E-14（465-466行目）, E-16（575行目） | ○ |
| C-23 | fun文で関数定義をサポート | E-14（494行目） | ○ |
| C-24 | IInstruction enumで命令セットを定義 | E-02 | ○ |
| C-25 | LambdaType enumでラムダ種別を定義 | E-03 | ○ |
| C-26 | TThis型で内部状態を保持 | E-04 | ○ |
| C-27 | TokenDefinition型でトークン定義を保持 | E-01 | ○ |
| C-28 | Operation型で操作を保持 | E-01 | ○ |
| C-29 | プロパティアクセス$1.Propertyをサポート | E-14（504-506行目） | ○ |
| C-30 | メソッド呼び出し$1.Method(args)をサポート | E-14（505行目） | ○ |
| C-31 | bSandboxExtrasで追加関数を制限可能 | E-07（272行目） | ○ |
| C-32 | BoundLambdaは元ラムダへの参照を保持 | E-07（285-288行目）, E-04（174-177行目） | ○ |
| C-33 | 演算子優先度はVBA標準に従う | E-17〜E-32（parseXxxPriority関数群） | ○ |
| C-34 | Mac環境ではrtcCallByNameに制限あり | E-35の直前（73-80行目: #If Not Mac） | ○ |
| C-35 | パフォーマンスキャッシュでO(1)取得可能 | **根拠なし**（Dictionaryルックアップの理論値） | △ |

## 4) 不足情報（Unknown / Missing）
- **パフォーマンスキャッシュO(1)取得**
  - 理由：DictionaryのルックアップがハッシュベースでほぼO(1)という理論値
  - 候補：ベンチマークコード / パフォーマンステスト結果

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全体的に信頼度が非常に高い（0.97）
- **0: 低リスク** - パーサー構造が明確で、演算子優先度の実装が確認可能
- **0: 低リスク** - Jump Tableによる命令ディスパッチはコード内で明示的に実装
- **1: 中リスク** - 式の複雑さによってはパース時間が増加する可能性

## 6) レビュアーチェックリスト（最小）
- [ ] IInstruction enum（100-159行目）が仮想マシン命令セットとして正しく定義されているか確認
- [ ] Createメソッド（226-237行目）のキャッシュ機構が正しく動作するか確認
- [ ] parseExpression（608-610行目）から始まる再帰下降パーサーの構造を確認
- [ ] evaluate関数（1290-1500行目）のスタック操作とJump Tableを確認
- [ ] 演算子優先度がparseXxxPriority関数の呼び出し順序で正しく表現されているか確認
- [ ] Mac環境での制限事項（73-80行目）を確認
