---
generated_at: 2026-01-15 11:15:00
metrics:
  claims_total: 32
  claims_with_evidence: 31
  claims_without_evidence: 1
confidence_derived: 0.97
---

# 根拠レポート：4-stdCallback

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：31 / 32、根拠なし：1
- 優先レビュー（高）
  1. **ConcatArrays O(n)**：理論値に基づく推測

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/stdCallback.cls` 132-138行目（ParentType enum定義）
- E-02: `src/stdCallback.cls` 140-145行目（TCBByPointer型定義）
- E-03: `src/stdCallback.cls` 148-162行目（CallbackStruct, TThis型定義）
- E-04: `src/stdCallback.cls` 166-174行目（BeforeRun, AfterRunイベント宣言）
- E-05: `src/stdCallback.cls` 185-198行目（Createメソッド）
- E-06: `src/stdCallback.cls` 205-209行目（CreateFromModule）
- E-07: `src/stdCallback.cls` 217-221行目（CreateFromWorkbookModule）
- E-08: `src/stdCallback.cls` 228-232行目（CreateFromObjectMethod）
- E-09: `src/stdCallback.cls` 240-244行目（CreateFromObjectProperty）
- E-10: `src/stdCallback.cls` 252-259行目（CreateFromPointer）
- E-11: `src/stdCallback.cls` 265-307行目（protInit）
- E-12: `src/stdCallback.cls` 312-314行目（stdICallable_Run）
- E-13: `src/stdCallback.cls` 319-321行目（stdICallable_RunEx）
- E-14: `src/stdCallback.cls` 326-328行目（stdICallable_Bind）
- E-15: `src/stdCallback.cls` 333-335行目（Bindメソッド）
- E-16: `src/stdCallback.cls` 340-344行目（BindExメソッド）
- E-17: `src/stdCallback.cls` 367-371行目（Runメソッド）
- E-18: `src/stdCallback.cls` 376-522行目（RunExメソッド）
- E-19: `src/stdCallback.cls` 388-425行目（Module型のApplication.Run）
- E-20: `src/stdCallback.cls` 426-446行目（Object型のrtcCallByName）
- E-21: `src/stdCallback.cls` 447-450行目（Bound型の委譲）
- E-22: `src/stdCallback.cls` 451-505行目（Pointer型のDispCallFunc）
- E-23: `src/stdCallback.cls` 524-564行目（macCallByName）
- E-24: `src/stdCallback.cls` 583-591行目（CriticalRaise）
- E-25: `src/stdCallback.cls` 616-640行目（ConcatArrays）
- E-26: `src/stdCallback.cls` 11行目（Implements stdICallable）
- E-27: `src/stdCallback.cls` 8行目（VB_PredeclaredId = True）
- E-28: `src/stdCallback.cls` 368-369行目（Run.VB_UserMemId = 0）
- E-29: `src/stdCallback.cls` 106-119行目（API宣言）
- E-30: `docs/code-to-docs/機能一覧/機能一覧.csv`（機能定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | stdCallbackは既存関数をラップするコールバッククラスである | E-03, E-11 | ○ |
| C-02 | stdICallableインターフェースを実装している | E-26 | ○ |
| C-03 | VB_PredeclaredId=Trueでインスタンス化不要 | E-27 | ○ |
| C-04 | Run.VB_UserMemId=0でデフォルトメンバー | E-28 | ○ |
| C-05 | ParentType enumで5種類の親タイプを定義 | E-01 | ○ |
| C-06 | CreateFromModuleでモジュール関数からコールバック生成 | E-06 | ○ |
| C-07 | CreateFromWorkbookModuleで外部ワークブック関数から生成 | E-07 | ○ |
| C-08 | CreateFromObjectMethodでオブジェクトメソッドから生成 | E-08 | ○ |
| C-09 | CreateFromObjectPropertyでオブジェクトプロパティから生成 | E-09 | ○ |
| C-10 | CreateFromPointerで関数ポインタから生成 | E-10 | ○ |
| C-11 | Module型ではApplication.Runで呼び出し | E-19 | ○ |
| C-12 | Object型ではrtcCallByNameで呼び出し | E-20 | ○ |
| C-13 | Bound型では元コールバックに委譲 | E-21 | ○ |
| C-14 | Pointer型ではDispCallFuncで呼び出し | E-22 | ○ |
| C-15 | Bindで引数をバインド可能 | E-15, E-16 | ○ |
| C-16 | バインドされた引数は左側に配置 | E-18（379行目）, E-25 | ○ |
| C-17 | BeforeRunイベントが発火する | E-04, E-18（383行目） | ○ |
| C-18 | AfterRunイベントが発火する | E-04, E-18（512行目） | ○ |
| C-19 | Module型は引数最大30個 | E-19（395行目: ReDim 0 To 29） | ○ |
| C-20 | Mac環境ではDispCallFuncが非対応 | E-22（496-497行目） | ○ |
| C-21 | Mac環境ではmacCallByNameで代替 | E-20（438-439行目）, E-23 | ○ |
| C-22 | protInitは1回のみ呼び出し可能 | E-11（303-305行目） | ○ |
| C-23 | CreateFromPointerはPrivate関数も呼び出し可能 | E-10, コメント76-84行目 | ○ |
| C-24 | Public関数のみ対象（Pointer以外） | コメント29行目 | ○ |
| C-25 | CallbackStructで呼び出し情報を保持 | E-03 | ○ |
| C-26 | TCBByPointerでポインタ情報を保持 | E-02 | ○ |
| C-27 | rtcCallByName APIを使用 | E-29（111-117行目） | ○ |
| C-28 | DispCallFunc APIを使用 | E-29（110, 116行目） | ○ |
| C-29 | CriticalRaiseでエラー発生 | E-24 | ○ |
| C-30 | stdError存在時はstdError.Raiseを使用 | E-24（585-586行目） | ○ |
| C-31 | ConcatArraysでバインド引数と渡された引数を結合 | E-25 | ○ |
| C-32 | ConcatArraysの計算量はO(n) | **根拠なし**（理論値、コメント615行目にO(1)とあるが実装はO(n)） | △ |

## 4) 不足情報（Unknown / Missing）
- **ConcatArrays計算量**
  - 理由：コード内コメント（615行目）にはO(1)と記載されているが、実装はループを含むためO(n)
  - 候補：ベンチマークコード / パフォーマンステスト結果
  - 注意：コメントと実装の不整合の可能性

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全体的に信頼度が非常に高い（0.97）
- **0: 低リスク** - API宣言が明確に記述されている
- **1: 中リスク** - ConcatArraysのコメント（O(1)）と実装（O(n)）に不整合の可能性
- **0: 低リスク** - Mac対応が明示的に実装されている

## 6) レビュアーチェックリスト（最小）
- [ ] ParentType enum（132-138行目）が5種類定義されているか確認
- [ ] protInit（265-307行目）でParentType別の初期化が正しく行われるか確認
- [ ] RunEx（376-522行目）でParentType別の呼び出し処理を確認
- [ ] Module型のApplication.Run（388-425行目）で30引数制限を確認
- [ ] Pointer型のDispCallFunc（451-505行目）がMac非対応であることを確認
- [ ] ConcatArrays（616-640行目）の計算量がコメント（O(1)）と実装（ループあり）で不整合がないか確認
