---
generated_at: 2026-01-15 11:45:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-stdRefArray

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/stdRefArray.cls` 24-30行目（Mac用CopyMemory API宣言）
- E-02: `src/stdRefArray.cls` 31-38行目（Windows用CopyMemory API宣言）
- E-03: `src/stdRefArray.cls` 40行目（VT_BYREF定数 = &H4000）
- E-04: `src/stdRefArray.cls` 41-45行目（PTR_SIZE定義 Win64=8, Win32=4）
- E-05: `src/stdRefArray.cls` 49行目（Public Data As Variant）
- E-06: `src/stdRefArray.cls` 51-58行目（GetDataプロパティ）
- E-07: `src/stdRefArray.cls` 52行目（VB_UserMemId = 0）
- E-08: `src/stdRefArray.cls` 63-66行目（Createメソッド）
- E-09: `src/stdRefArray.cls` 71-82行目（protInit）
- E-10: `src/stdRefArray.cls` 72行目（IsArrayチェック）
- E-11: `src/stdRefArray.cls` 74行目（VarPtrArr呼び出し）
- E-12: `src/stdRefArray.cls` 77行目（VT_BYREFフラグ設定）
- E-13: `src/stdRefArray.cls` 78行目（CopyMemoryでヘッダー更新）
- E-14: `src/stdRefArray.cls` 80行目（エラー "Array required"）
- E-15: `src/stdRefArray.cls` 87-101行目（VarPtrArr関数）
- E-16: `src/stdRefArray.cls` 92行目（vtArrByRef定数）
- E-17: `src/stdRefArray.cls` 96行目（pArrayOffset = 8）
- E-18: `src/stdRefArray.cls` 99行目（エラー "Array required"）
- E-19: `src/stdRefArray.cls` 8行目（VB_PredeclaredId = True）
- E-20: `src/stdRefArray.cls` 11-13行目（モジュールドキュメント）
- E-21: `docs/code-to-docs/機能一覧/機能一覧.csv`（機能定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | stdRefArrayはVBA配列を参照渡しでラップする | E-20, E-05 | ○ |
| C-02 | CopyMemory APIはWindows/Macで異なる | E-01, E-02 | ○ |
| C-03 | VT_BYREFは&H4000 | E-03 | ○ |
| C-04 | PTR_SIZEはWin64で8、Win32で4 | E-04 | ○ |
| C-05 | DataプロパティはPublic | E-05 | ○ |
| C-06 | GetDataはデフォルトメンバー | E-07 | ○ |
| C-07 | GetDataでVariant全体をCopyMemory | E-06 | ○ |
| C-08 | Win64で24バイト、Win32で16バイトコピー | E-06（54行目、56行目） | ○ |
| C-09 | CreateはByRefでデータを受け取る | E-08（63行目） | ○ |
| C-10 | protInitでIsArrayチェックを行う | E-10 | ○ |
| C-11 | 配列以外でエラー発生（protInit） | E-14 | ○ |
| C-12 | VarPtrArrでポインタを取得 | E-11, E-15 | ○ |
| C-13 | VT_BYREFフラグをVarTypeにOR設定 | E-12 | ○ |
| C-14 | CopyMemoryでVariantヘッダーを更新 | E-13 | ○ |
| C-15 | VarPtrArrでvbArray+VT_BYREFをチェック | E-16 | ○ |
| C-16 | ポインタオフセットは8バイト | E-17 | ○ |
| C-17 | VarPtrArrで配列以外はエラー | E-18 | ○ |
| C-18 | VB_PredeclaredId=Trueでファクトリ呼び出し可能 | E-19 | ○ |
| C-19 | Windows用はkernel32のRtlMoveMemory | E-02（34, 36行目） | ○ |
| C-20 | Mac用はlibc.dylibのmemmove | E-01（27, 29行目） | ○ |
| C-21 | Create処理はO(1)（コピーなし） | E-08, E-09（ポインタ操作のみ） | ○ |
| C-22 | Data参照はO(1)（ポインタ逆参照のみ） | E-05（VBAランタイムの動作） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（シンプルなクラスのため、全情報がソースコード内に存在）

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全項目に根拠あり（1.00）
- **1: 中リスク** - 低レベルメモリ操作のため、ポインタ操作の正確性を要確認
- **1: 中リスク** - 元配列が解放された後の参照は未定義動作となる可能性

## 6) レビュアーチェックリスト（最小）
- [ ] CopyMemory API宣言（24-38行目）がWindows/Macで正しく分岐しているか確認
- [ ] VT_BYREF定数（40行目）が&H4000であることを確認
- [ ] PTR_SIZE定義（41-45行目）がWin64/Win32で正しいか確認
- [ ] protInit（71-82行目）でIsArrayチェックとポインタ設定が正しいか確認
- [ ] VarPtrArr（87-101行目）でポインタオフセット(8)が正しいか確認
- [ ] GetData（51-58行目）のCopyMemoryサイズ（24/16）が正しいか確認
