---
generated_at: 2026-01-15 12:00:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：7-stdQuadTree

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **計算量O(log n + k)**：理論値に基づく推測

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/stdQuadTree.cls` 30-34行目（XY型定義）
- E-02: `src/stdQuadTree.cls` 35-38行目（AABB型定義）
- E-03: `src/stdQuadTree.cls` 40-45行目（BranchIndex enum）
- E-04: `src/stdQuadTree.cls` 46-48行目（BranchInfo型定義）
- E-05: `src/stdQuadTree.cls` 49-52行目（LeafInfo型定義）
- E-06: `src/stdQuadTree.cls` 53-56行目（QuadTreeType enum）
- E-07: `src/stdQuadTree.cls` 60-77行目（TThis型定義）
- E-08: `src/stdQuadTree.cls` 88-91行目（Createメソッド）
- E-09: `src/stdQuadTree.cls` 102-111行目（CreateFromBoundsメソッド）
- E-10: `src/stdQuadTree.cls` 122-125行目（CreateChildメソッド）
- E-11: `src/stdQuadTree.cls` 135-151行目（protInit）
- E-12: `src/stdQuadTree.cls` 159-196行目（insertPoint）
- E-13: `src/stdQuadTree.cls` 161行目（境界チェック）
- E-14: `src/stdQuadTree.cls` 167行目（容量チェック）
- E-15: `src/stdQuadTree.cls` 178行目（SubDivide呼び出し）
- E-16: `src/stdQuadTree.cls` 186-191行目（子ノードへの再帰挿入）
- E-17: `src/stdQuadTree.cls` 203-206行目（queryRange）
- E-18: `src/stdQuadTree.cls` 214-222行目（queryRangeBounds）
- E-19: `src/stdQuadTree.cls` 232-249行目（pQueryRange）
- E-20: `src/stdQuadTree.cls` 252-286行目（SubDivide）
- E-21: `src/stdQuadTree.cls` 256-262行目（4象限生成）
- E-22: `src/stdQuadTree.cls` 267-282行目（既存点の再挿入）
- E-23: `src/stdQuadTree.cls` 305-309行目（AABB_Create）
- E-24: `src/stdQuadTree.cls` 325-331行目（AABB_containsPoint）
- E-25: `src/stdQuadTree.cls` 338-344行目（AABB_containsXY）
- E-26: `src/stdQuadTree.cls` 351-361行目（AABB_intersects）
- E-27: `src/stdQuadTree.cls` 8行目（VB_PredeclaredId = True）
- E-28: `src/stdQuadTree.cls` 24-25行目（devNoteコメント）
- E-29: `docs/code-to-docs/機能一覧/機能一覧.csv`（機能定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | stdQuadTreeは2次元空間データのQuadtree実装 | E-01〜E-07 | ○ |
| C-02 | XY型は点座標とメタデータを保持 | E-01 | ○ |
| C-03 | AABB型は中心座標とhalfDimensionで境界を表現 | E-02 | ○ |
| C-04 | QuadTreeTypeはLeafとBranchを区別 | E-06 | ○ |
| C-05 | BranchIndexで4象限（NW,NE,SW,SE）を定義 | E-03 | ○ |
| C-06 | capacityBeforeSubdivisionのデフォルトは4 | E-08（88行目） | ○ |
| C-07 | minimumHalfDimensionのデフォルトは0.00001 | E-08（88行目） | ○ |
| C-08 | Createは中心座標とhalfDimensionから生成 | E-08 | ○ |
| C-09 | CreateFromBoundsはmin/maxから境界計算 | E-09 | ○ |
| C-10 | protInitでLeafノードとして初期化 | E-11（137行目） | ○ |
| C-11 | insertPointで境界チェックを実行 | E-13 | ○ |
| C-12 | 境界外の点はFalse返却 | E-12（161行目） | ○ |
| C-13 | 容量超過時にSubDivideを呼び出し | E-15 | ○ |
| C-14 | Branchノードでは子ノードに再帰挿入 | E-16 | ○ |
| C-15 | SubDivideで4象限に分割 | E-21 | ○ |
| C-16 | SubDivideで既存点を子ノードに再配置 | E-22 | ○ |
| C-17 | SubDivide後に既存点配列を解放 | E-20（285行目） | ○ |
| C-18 | queryRangeはAABBを作成して検索 | E-17 | ○ |
| C-19 | pQueryRangeで交差チェック | E-19（234行目） | ○ |
| C-20 | LeafノードではAABB_containsPointで判定 | E-19（238行目） | ○ |
| C-21 | Branchノードでは子ノードを再帰検索 | E-19（245-247行目） | ○ |
| C-22 | AABB_containsPointは境界包含判定 | E-24 | ○ |
| C-23 | AABB_containsXYは座標包含判定 | E-25 | ○ |
| C-24 | AABB_intersectsは交差判定 | E-26 | ○ |
| C-25 | VB_PredeclaredId=Trueでファクトリ呼び出し可能 | E-27 | ○ |
| C-26 | SubDivideで挿入できない場合はエラー発生 | E-20（281行目） | ○ |
| C-27 | Loose QuadtreeやGridの代替手法をdevNoteで言及 | E-28 | ○ |
| C-28 | queryRangeの計算量はO(log n + k) | **根拠なし**（理論値） | △ |

## 4) 不足情報（Unknown / Missing）
- **計算量O(log n + k)**
  - 理由：Quadtreeアルゴリズムの理論的計算量であり、実測データは存在しない
  - 候補：ベンチマークコード / パフォーマンステスト結果

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全体的に信頼度が高い（0.96）
- **1: 中リスク** - 同一座標の重複点が多い場合のスタックオーバーフロー
- **0: 低リスク** - AABB操作の実装が明確

## 6) レビュアーチェックリスト（最小）
- [ ] XY, AABB, TThis型定義（30-77行目）がドキュメントと一致するか確認
- [ ] insertPoint（159-196行目）の境界チェックとノード種別判定を確認
- [ ] SubDivide（252-286行目）で4象限生成と点の再配置を確認
- [ ] pQueryRange（232-249行目）の交差チェックと再帰検索を確認
- [ ] AABB_intersects（351-361行目）の交差判定ロジックを確認
- [ ] minimumHalfDimensionによる無限分割防止を確認（167-168行目）
