---
generated_at: 2026-01-15 12:15:00
metrics:
  claims_total: 30
  claims_with_evidence: 29
  claims_without_evidence: 1
confidence_derived: 0.97
---

# 根拠レポート：8-stdJSON

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：29 / 30、根拠なし：1
- 優先レビュー（高）
  1. **CreateFromString計算量O(n)**：理論値に基づく推測

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/stdJSON.cls` 67-70行目（EStdJsonType enum）
- E-02: `src/stdJSON.cls` 71-75行目（TParser型）
- E-03: `src/stdJSON.cls` 76-81行目（TThis型）
- E-04: `src/stdJSON.cls` 83-87行目（StringBuffer型）
- E-05: `src/stdJSON.cls` 106-109行目（Createメソッド）
- E-06: `src/stdJSON.cls` 126-141行目（CreateFromString）
- E-07: `src/stdJSON.cls` 128-130行目（パーサープロパティ設定）
- E-08: `src/stdJSON.cls` 133-140行目（先頭文字判定）
- E-09: `src/stdJSON.cls` 148-155行目（CreateFromFile）
- E-10: `src/stdJSON.cls` 161-164行目（CreateFromVariant）
- E-11: `src/stdJSON.cls` 171-184行目（CreateFromParams）
- E-12: `src/stdJSON.cls` 190-198行目（protInit）
- E-13: `src/stdJSON.cls` 204-260行目（protInitFromVariant）
- E-14: `src/stdJSON.cls` 266-275行目（Addメソッド）
- E-15: `src/stdJSON.cls` 284-302行目（AddArray）
- E-16: `src/stdJSON.cls` 307-319行目（AddObject）
- E-17: `src/stdJSON.cls` 323-325行目（JsonTypeプロパティ）
- E-18: `src/stdJSON.cls` 329-331行目（Lengthプロパティ）
- E-19: `src/stdJSON.cls` 336-360行目（Itemプロパティ）
- E-20: `src/stdJSON.cls` 337行目（Item.VB_UserMemId = 0）
- E-21: `src/stdJSON.cls` 365-372行目（Existsプロパティ）
- E-22: `src/stdJSON.cls` 377-393行目（ChildrenInfo）
- E-23: `src/stdJSON.cls` 415-473行目（ToString）
- E-24: `src/stdJSON.cls` 478-483行目（ToFile）
- E-25: `src/stdJSON.cls` 487-500行目（ToVBObject）
- E-26: `src/stdJSON.cls` 8行目（VB_PredeclaredId = True）
- E-27: `src/stdJSON.cls` 65行目（UseDictionaryLateBinding = True）
- E-28: `docs/code-to-docs/機能一覧/機能一覧.csv`（機能定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | stdJSONはJSONデータを生成・解析・操作するクラス | E-05, E-06, E-23 | ○ |
| C-02 | EStdJsonTypeでObject/Arrayを区別 | E-01 | ○ |
| C-03 | TParser型でパーサーオプションを保持 | E-02 | ○ |
| C-04 | TThis.childrenがDictionary（Object）またはCollection（Array） | E-03, E-12 | ○ |
| C-05 | StringBuffer型で文字列結合最適化 | E-04, E-23（423行目） | ○ |
| C-06 | Createで空のJSONオブジェクト/配列を生成 | E-05 | ○ |
| C-07 | CreateFromStringでJSON文字列をパース | E-06 | ○ |
| C-08 | 先頭文字が{または[でない場合はエラー | E-08（139行目） | ○ |
| C-09 | AllowUnquotedKeysオプションをサポート | E-02, E-07 | ○ |
| C-10 | AllowSingleQuoteStringsオプションをサポート | E-02, E-07 | ○ |
| C-11 | StoreLargeNumsAsStringオプションをサポート | E-02, E-07 | ○ |
| C-12 | CreateFromFileでファイルからJSON読み込み | E-09 | ○ |
| C-13 | CreateFromVariantでVBA変数から変換 | E-10, E-13 | ○ |
| C-14 | CreateFromParamsでパラメータからJSON構築 | E-11 | ○ |
| C-15 | protInitでiTypeに応じてDictionary/Collectionを初期化 | E-12（193-197行目） | ○ |
| C-16 | Addで要素を追加（Object: key-value, Array: value） | E-14 | ○ |
| C-17 | AddArrayで配列を作成して追加 | E-15 | ○ |
| C-18 | AddObjectでオブジェクトを作成して追加 | E-16 | ○ |
| C-19 | メソッドチェーンによるJSON構築が可能 | E-14-E-16（戻り値stdJSON） | ○ |
| C-20 | JsonTypeプロパティでJSON種別を取得 | E-17 | ○ |
| C-21 | Lengthプロパティで要素数を取得 | E-18 | ○ |
| C-22 | Itemプロパティでキー/インデックスアクセス | E-19 | ○ |
| C-23 | Item.VB_UserMemId=0でデフォルトメンバー | E-20 | ○ |
| C-24 | Existsプロパティでキー/インデックス存在確認 | E-21 | ○ |
| C-25 | ToStringでJSON文字列にシリアライズ | E-23 | ○ |
| C-26 | ToStringはprettyオプションで整形出力可能 | E-23（417-421行目） | ○ |
| C-27 | ToFileでファイルに出力 | E-24 | ○ |
| C-28 | ToVBObjectでDictionary/Collectionに変換 | E-25 | ○ |
| C-29 | VB_PredeclaredId=Trueでファクトリ呼び出し可能 | E-26 | ○ |
| C-30 | CreateFromStringの計算量はO(n) | **根拠なし**（理論値） | △ |

## 4) 不足情報（Unknown / Missing）
- **CreateFromString計算量O(n)**
  - 理由：パース処理の理論的計算量であり、実測データは存在しない
  - 候補：ベンチマークコード / パフォーマンステスト結果

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全体的に信頼度が高い（0.97）
- **0: 低リスク** - ファクトリメソッドの実装が明確
- **0: 低リスク** - StringBufferによる最適化が実装されている

## 6) レビュアーチェックリスト（最小）
- [ ] EStdJsonType enum（67-70行目）が正しく定義されているか確認
- [ ] protInit（190-198行目）でiTypeに応じた初期化を確認
- [ ] CreateFromString（126-141行目）の先頭文字判定を確認
- [ ] Add（266-275行目）でObject/Arrayの分岐を確認
- [ ] ToString（415-473行目）のシリアライズロジックを確認
- [ ] StringBuffer使用による文字列結合最適化を確認
