---
generated_at: 2026-01-15 12:30:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：9-stdRegex

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **ReDoS攻撃リスク**：セキュリティ考慮事項として記載したが、コード上の対策は確認できず

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/stdRegex.cls` 89-97行目（TThis型定義）
- E-02: `src/stdRegex.cls` 8行目（VB_PredeclaredId = True）
- E-03: `src/stdRegex.cls` 109-130行目（Createメソッド）
- E-04: `src/stdRegex.cls` 116行目（Static cache Dictionary）
- E-05: `src/stdRegex.cls` 117行目（キャッシュキー生成）
- E-06: `src/stdRegex.cls` 142-226行目（protInit）
- E-07: `src/stdRegex.cls` 156-161行目（NamesMatcher初期化）
- E-08: `src/stdRegex.cls` 159行目（名前付きキャプチャ検出パターン）
- E-09: `src/stdRegex.cls` 164-169行目（NamesReplacer初期化）
- E-10: `src/stdRegex.cls` 173-178行目（OptionIgnoreWhiteSpace）
- E-11: `src/stdRegex.cls` 181-186行目（OptionIgnoreComment）
- E-12: `src/stdRegex.cls` 191-196行目（OptionSingleLineMode）
- E-13: `src/stdRegex.cls` 203-204行目（VBScript.RegExp生成）
- E-14: `src/stdRegex.cls` 207-223行目（フラグ処理ループ）
- E-15: `src/stdRegex.cls` 210-211行目（iフラグ: ignoreCase）
- E-16: `src/stdRegex.cls` 212-213行目（gフラグ: Global）
- E-17: `src/stdRegex.cls` 214-215行目（mフラグ: MultiLine）
- E-18: `src/stdRegex.cls` 216-217行目（xフラグ: 空白除去）
- E-19: `src/stdRegex.cls` 218-219行目（cフラグ: コメント除去）
- E-20: `src/stdRegex.cls` 220-221行目（sフラグ: SingleLine）
- E-21: `src/stdRegex.cls` 286-293行目（Testメソッド）
- E-22: `src/stdRegex.cls` 322-354行目（Matchメソッド）
- E-23: `src/stdRegex.cls` 380-427行目（MatchAllメソッド）
- E-24: `src/stdRegex.cls` 387-395行目（Global一時設定・復元）
- E-25: `src/stdRegex.cls` 455-474行目（Replaceメソッド）
- E-26: `src/stdRegex.cls` 468行目（$name→$n変換）
- E-27: `src/stdRegex.cls` 498-517行目（Listメソッド）
- E-28: `src/stdRegex.cls` 525-553行目（ListArrメソッド）
- E-29: `src/stdRegex.cls` 564-591行目（FormatFromMatch）
- E-30: `src/stdRegex.cls` 599-601行目（SaveEscape）
- E-31: `src/stdRegex.cls` 607-609行目（LoadEscape）
- E-32: `src/stdRegex.cls` 613-618行目（CriticalRaise）
- E-33: `src/stdRegex.cls` 11-22行目（モジュールドキュメント）
- E-34: `src/stdRegex.cls` 24-64行目（Spec仕様コメント）
- E-35: `docs/code-to-docs/機能一覧/機能一覧.csv`（機能定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | stdRegexはVBScript.RegExpをラップする | E-13, E-33 | ○ |
| C-02 | 名前付きキャプチャグループをサポート | E-08, E-34（47行目） | ○ |
| C-03 | TThis型でpattern, flags, namesDict, regexを保持 | E-01 | ○ |
| C-04 | VB_PredeclaredId=Trueでファクトリ呼び出し可能 | E-02 | ○ |
| C-05 | CreateでStatic Dictionaryキャッシュを使用 | E-04 | ○ |
| C-06 | キャッシュキーはpattern & "&" & flags | E-05 | ○ |
| C-07 | protInitで名前付きキャプチャを検出 | E-07, E-08 | ○ |
| C-08 | NamesMatcherパターンは非キャプチャグループを除外 | E-08（159行目） | ○ |
| C-09 | NamesReplacerで名前構文を除去 | E-09 | ○ |
| C-10 | iフラグでignoreCase=True | E-15 | ○ |
| C-11 | gフラグでGlobal=True | E-16 | ○ |
| C-12 | mフラグでMultiLine=True | E-17 | ○ |
| C-13 | xフラグで空白を除去 | E-10, E-18 | ○ |
| C-14 | cフラグでコメント(#以降)を除去 | E-11, E-19 | ○ |
| C-15 | sフラグで`.`を`(?:.\|\s)`に置換 | E-12, E-20 | ○ |
| C-16 | TestはVBScript.RegExp.Testを呼び出し | E-21（292行目） | ○ |
| C-17 | MatchはDictionaryを返却 | E-22（335行目） | ○ |
| C-18 | Match結果に$COUNT, $RAWを含む | E-22（339-340行目） | ○ |
| C-19 | Match結果に名前付きキーを設定 | E-22（347行目） | ○ |
| C-20 | MatchAllでGlobalを一時的にTrueに設定 | E-24（387-388行目） | ○ |
| C-21 | MatchAllでGlobalを元に戻す | E-24（395行目） | ○ |
| C-22 | MatchAllはCollectionを返却 | E-23（399行目） | ○ |
| C-23 | Replaceで$nameを$nに変換 | E-26 | ○ |
| C-24 | ListはMatchAllを呼び出してフォーマット | E-27（506, 512行目） | ○ |
| C-25 | ListArrは2次元配列を返却 | E-28（538行目） | ○ |
| C-26 | FormatFromMatchで\r, \nをエスケープ | E-29（575-576行目） | ○ |
| C-27 | SaveEscape/LoadEscapeでGUIDプレースホルダー使用 | E-30, E-31 | ○ |
| C-28 | ReDoS攻撃への対策あり | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **ReDoS攻撃対策**
  - 理由：セキュリティ考慮事項として言及したが、コード上での入力バリデーションや対策は確認できない
  - 候補：入力パターンのバリデーション / タイムアウト機構 / パターン複雑度制限

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全体的に信頼度が高い（0.96）
- **0: 低リスク** - VBScript.RegExpへの委譲が明確
- **1: 中リスク** - 名前付きキャプチャの正規表現パターンが複雑
- **0: 低リスク** - キャッシュ機構による性能最適化が実装済み

## 6) レビュアーチェックリスト（最小）
- [ ] TThis型定義（89-97行目）がドキュメントと一致するか確認
- [ ] Createのキャッシュ機構（116-126行目）が正しく動作するか確認
- [ ] NamesMatcher正規表現（159行目）が名前付きキャプチャを正しく検出するか確認
- [ ] フラグ処理ループ（207-223行目）で各フラグが正しく処理されるか確認
- [ ] Match/MatchAll（322-427行目）で名前付きキーが正しく設定されるか確認
- [ ] Replace（455-474行目）で$name→$n変換が正しく行われるか確認
- [ ] FormatFromMatch（564-591行目）のエスケープ処理を確認
