# 画面遷移図

## 概要

本プロジェクト（stdVBA）はVBA標準ライブラリであり、ユーザーインターフェース（UI）を持つ画面は存在しません。

stdVBAは以下の特徴を持つライブラリプロジェクトです：

- VBAアプリケーション開発のための汎用ライブラリ集
- stdArray、stdRegex、stdLambda等のユーティリティクラスを提供
- エンドユーザー向けの画面UIは含まれていない
- 他のVBAプロジェクトから参照されて使用される

## 画面遷移図

```mermaid
graph TD
    subgraph "stdVBA プロジェクト"
        A[画面なし]
        A --> |"本プロジェクトはライブラリのため"| B[UIコンポーネントは存在しない]
    end

    subgraph "プロジェクト構成"
        C[src/] --> D[stdArray.cls]
        C --> E[stdRegex.cls]
        C --> F[stdLambda.cls]
        C --> G[stdCallback.cls]
        C --> H[その他クラスモジュール]
    end
```

## 補足

このプロジェクトにはUserForm（`.frm`/`.frx`ファイル）が含まれておらず、画面遷移の概念は適用されません。

利用者はこのライブラリを自身のVBAプロジェクトにインポートして使用します。
