# 画面設計書 1-（画面なし）

## 概要

本ドキュメントは、stdVBAプロジェクトにおける画面設計に関する説明書です。本プロジェクトはVBA標準ライブラリであり、ユーザーインターフェース（UI）を持つ画面は存在しません。

### 本画面の処理概要

本プロジェクト（stdVBA）は、VBA（Visual Basic for Applications）アプリケーション開発のための汎用ライブラリ集であり、エンドユーザー向けの画面UIコンポーネントを含んでいません。そのため、画面設計書として記載すべき画面は存在しません。

**業務上の目的・背景**：stdVBAは、VBA開発者がより効率的にコードを書けるよう支援するためのライブラリです。stdArray、stdLambda、stdRegex、stdCallback等の汎用的なユーティリティクラスを提供し、VBAの標準機能を拡張します。このライブラリ自体は画面を持たず、他のVBAプロジェクトから参照されて使用されることを想定しています。画面UIを必要とする業務アプリケーションの「部品」として機能するため、本プロジェクト単体での画面設計は該当しません。

**画面へのアクセス方法**：該当なし。本プロジェクトはライブラリであり、直接アクセスする画面は存在しません。利用者は自身のVBAプロジェクトにstdVBAのクラスモジュールをインポートして使用します。

**主要な操作・処理内容**：
1. 本プロジェクト自体には操作可能な画面UIが存在しない
2. 提供されるクラスモジュール（stdArray、stdLambda等）は、他のVBAアプリケーションから呼び出されて使用される
3. ライブラリの利用は、VBAコードからのプログラム的な呼び出しによって行われる

**画面遷移**：該当なし。画面UIが存在しないため、画面遷移の概念は適用されません。

**権限による表示制御**：該当なし。画面UIが存在しないため、権限による表示制御の概念は適用されません。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | 該当なし | 本プロジェクトは画面UIを持たないライブラリのため、画面機能マッピングは該当しない |

## 画面種別

該当なし（ライブラリプロジェクト）

## URL/ルーティング

該当なし（VBAライブラリのため、URL/ルーティングの概念は適用されない）

## 入出力項目

該当なし（画面UIが存在しないため、入出力項目の定義は不要）

## 表示項目

該当なし（画面UIが存在しないため、表示項目の定義は不要）

## イベント仕様

該当なし（画面UIが存在しないため、UIイベントの定義は不要）

## データベース更新仕様

### 操作別データベース影響一覧

該当なし（本プロジェクトは汎用ライブラリであり、特定のデータベースへのアクセスは含まれていない）

### テーブル別更新項目詳細

該当なし

## メッセージ仕様

該当なし（画面UIが存在しないため、ユーザー向けメッセージの定義は不要）

## 例外処理

本ライブラリ内の各クラスモジュールは、個別に例外処理を実装しています。例外処理の詳細は各クラスの仕様を参照してください。

## 備考

- 本プロジェクト（stdVBA）はGitHubで公開されているオープンソースライブラリです
- VBA7（64ビット）とレガシーVBA（32ビット）の両方に対応しています
- MacとWindowsの両環境で動作するよう条件付きコンパイルが使用されています
- UserForm（`.frm`/`.frx`ファイル）はプロジェクトに含まれていません

---

## コードリーディングガイド

本プロジェクトは画面UIを持たないライブラリですが、プロジェクト構造を理解するための参照ガイドを以下に示します。

### 推奨読解順序

#### Step 1: プロジェクト構造を理解する

まず、プロジェクト全体の構成と主要なクラスモジュールを把握することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | stdICallable.cls | `src/stdICallable.cls` | コールバック機能の共通インターフェース定義を理解する |
| 1-2 | stdArray.cls | `src/stdArray.cls` | 配列操作の中核クラス。map、filter、reduceなどの関数型プログラミングパターンを確認 |
| 1-3 | stdLambda.cls | `src/stdLambda.cls` | ラムダ式パーサーの実装。VBAでの関数型プログラミングの基盤 |

**読解のコツ**: VBAクラスモジュールは、ファイル先頭に`VERSION 1.0 CLASS`から始まるヘッダーがあり、`Attribute VB_Name`でクラス名が定義されています。`Private Type TThis`パターンでカプセル化されたプライベート変数を確認してください。

#### Step 2: 主要クラスの実装を理解する

処理の実装詳細を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | stdArray.cls | `src/stdArray.cls` | 行1-100：クラス定義、API宣言、内部型定義 |
| 2-2 | stdLambda.cls | `src/stdLambda.cls` | 行1-100：インターフェース実装、トークン定義、演算定義 |
| 2-3 | stdCallback.cls | `src/stdCallback.cls` | コールバック機構の実装詳細 |

**主要処理フロー**:
1. **stdArray.cls 行1-9**: クラスヘッダーとVB属性定義
2. **stdArray.cls 行73-79**: 条件付きコンパイルによるプラットフォーム対応（Mac/Windows、32/64ビット）
3. **stdArray.cls 行81-97**: 内部データ構造の定義（SortDirection、SortStruct、TThis型）

#### Step 3: ユーティリティクラスを理解する

その他の主要なユーティリティクラスを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | stdRegex.cls | `src/stdRegex.cls` | 正規表現処理のラッパークラス |
| 3-2 | stdJSON.cls | `src/stdJSON.cls` | JSON解析・生成機能 |
| 3-3 | stdHTTP.cls | `src/stdHTTP.cls` | HTTP通信機能 |

### プログラム呼び出し階層図

```
[利用者のVBAプロジェクト]
    │
    ├─ stdArray
    │      ├─ stdICallable (インターフェース)
    │      └─ stdLambda (フィルタ・マップ処理)
    │
    ├─ stdLambda
    │      └─ stdICallable (インターフェース実装)
    │
    ├─ stdCallback
    │      └─ stdICallable (インターフェース実装)
    │
    └─ その他クラス（stdRegex、stdJSON等）
```

### データフロー図

```
[入力]                      [処理]                          [出力]

VBAアプリケーション ───▶ stdVBAクラスモジュール ───▶ 処理結果
   (データ・関数)           (stdArray, stdLambda等)      (変換されたデータ)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| stdArray.cls | `src/stdArray.cls` | ソース | 配列操作ユーティリティクラス |
| stdLambda.cls | `src/stdLambda.cls` | ソース | ラムダ式評価クラス |
| stdCallback.cls | `src/stdCallback.cls` | ソース | コールバック機能クラス |
| stdICallable.cls | `src/stdICallable.cls` | ソース | 呼び出し可能インターフェース |
| stdRegex.cls | `src/stdRegex.cls` | ソース | 正規表現ユーティリティクラス |
| stdJSON.cls | `src/stdJSON.cls` | ソース | JSON処理クラス |
| stdHTTP.cls | `src/stdHTTP.cls` | ソース | HTTP通信クラス |
| stdWindow.cls | `src/stdWindow.cls` | ソース | ウィンドウ操作クラス |
| stdProcess.cls | `src/stdProcess.cls` | ソース | プロセス操作クラス |
| stdClipboard.cls | `src/stdClipboard.cls` | ソース | クリップボード操作クラス |
| stdTimer.cls | `src/stdTimer.cls` | ソース | タイマー機能クラス |
| stdReg.cls | `src/stdReg.cls` | ソース | レジストリ操作クラス |
| ClassTemplate.cls | `Templates/ClassTemplate.cls` | テンプレート | 新規クラス作成用テンプレート |
