---
generated_at: 2026-01-15 10:30:00
metrics:
  claims_total: 30
  claims_with_evidence: 26
  claims_without_evidence: 4
confidence_derived: 0.87
---

# 根拠レポート：結合テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.87**
  - 根拠あり：26 / 30、根拠なし：4
- 優先レビュー（高）
  1. **IT-014 HTTPプロキシ設定連携テスト**：プロキシサーバー環境の可用性確認が必要
  2. **IT-030 WebSocketブラウザ連携テスト**：IEの利用可能性が環境依存
  3. **IT-019 プロセスWMI連携テスト**：WMI権限の確認が必要
  4. **IT-017 配列イベント連携テスト**：イベント発火順序の詳細確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/stdHTTP.cls` - HTTP通信クラスの実装
- E-02: `src/stdCallback.cls` - コールバッククラスの実装
- E-03: `src/stdLambda.cls` - Lambda式クラスの実装
- E-04: `src/stdArray.cls` - 配列クラスの実装
- E-05: `src/stdProcess.cls` - プロセス管理クラスの実装
- E-06: `src/stdJSON.cls` - JSON処理クラスの実装
- E-07: `src/stdWebSocket.cls` - WebSocket通信クラスの実装
- E-08: `src/stdICallable.cls` - コーラブルインターフェース定義
- E-09: `tests/stdHTTPTests.bas` - HTTP通信テストコード
- E-10: `tests/stdProcessTests.bas` - プロセス管理テストコード
- E-11: `tests/stdCallbackTests.bas` - コールバックテストコード
- E-12: `tests/stdLambdaTests.bas` - Lambdaテストコード
- E-13: `tests/stdArrayTests.bas` - 配列テストコード
- E-14: `README.md` - プロジェクト概要とサンプルコード
- E-15: `src/stdHTTPAuthenticators.bas` - HTTP認証モジュール

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IT-001: stdHTTP-stdCallback間でAuthenticator連携が可能 | E-01, E-02, E-09, E-15 | ○ |
| C-02 | IT-002: stdHTTPレスポンスをstdJSONでパース可能 | E-01, E-06 | ○ |
| C-03 | IT-003: ResponseMapperでstdLambdaマッピング可能 | E-01, E-03, E-09 | ○ |
| C-04 | IT-004: stdArray.Map/Filter/ReduceがstdLambdaと連携 | E-04, E-03, E-12 | ○ |
| C-05 | IT-005: stdArray操作でstdCallbackを使用可能 | E-04, E-02, E-13 | ○ |
| C-06 | IT-006: stdProcess.CreateFromQueryでstdLambda検索 | E-05, E-03, E-10 | ○ |
| C-07 | IT-007: stdProcess.CreateManyFromQueryがCollection返却 | E-05, E-10 | ○ |
| C-08 | IT-008: stdWebSocket.ListenersでstdCallback登録可能 | E-07, E-02 | ○ |
| C-09 | IT-009: stdJSONの配列シリアライズ/デシリアライズ | E-06 | ○ |
| C-10 | IT-010: stdJSONとDictionary間の相互変換 | E-06 | ○ |
| C-11 | IT-011: stdCallback.Bindで引数部分適用 | E-02, E-11 | ○ |
| C-12 | IT-012: stdLambdaがstdICallable実装 | E-03, E-08 | ○ |
| C-13 | IT-013: stdCallbackがstdICallable実装 | E-02, E-08 | ○ |
| C-14 | IT-014: stdHTTP.CreateProxyでプロキシ設定可能 | E-01 | △ |
| C-15 | IT-015: stdArray.SortがstdLambdaソートキー対応 | E-04 | ○ |
| C-16 | IT-016: stdJSON.ToFile/CreateFromFileでファイルI/O | E-06 | ○ |
| C-17 | IT-017: stdArrayがVBAイベント発火 | E-04 | △ |
| C-18 | IT-018: stdHTTPの非同期リクエストとAwait | E-01, E-09 | ○ |
| C-19 | IT-019: stdProcess.WinmgmtでWMI連携 | E-05, E-10 | △ |
| C-20 | IT-020: stdLambda.BindGlobalでグローバル変数 | E-03, E-12 | ○ |
| C-21 | IT-021: stdArray.UniqueがstdLambdaキー対応 | E-04 | ○ |
| C-22 | IT-022: stdArray.GroupByがstdLambdaキー対応 | E-04 | ○ |
| C-23 | IT-023: stdHTTP.CreateOptionsでCookie設定可能 | E-01, E-09 | ○ |
| C-24 | IT-024: stdCallback.CreateFromObjectMethod動作 | E-02, E-11 | ○ |
| C-25 | IT-025: stdCallback.CreateFromPointerで関数ポインタ | E-02, E-11 | ○ |
| C-26 | IT-026: stdJSONとCollection間の相互変換 | E-06 | ○ |
| C-27 | IT-027: stdHTTPカスタムヘッダー送受信 | E-01, E-09 | ○ |
| C-28 | IT-028: stdLambda.CreateMultilineで複数行Lambda | E-03, E-12 | ○ |
| C-29 | IT-029: stdArray.Concatで配列連結 | E-04 | ○ |
| C-30 | IT-030: stdWebSocketがIE経由でWebSocket通信 | E-07 | △ |

## 4) 不足情報（Unknown / Missing）
- **IT-014 プロキシ設定連携**：プロキシサーバー環境でのテスト実績が不明
  - 候補：プロキシサーバーのモック環境構築 / 既存インフラ環境での検証
- **IT-017 配列イベント連携**：イベント発火のテストコードが不足
  - 候補：stdArrayTests.basにイベントテスト追加 / WithEventsパターンの検証
- **IT-019 WMI連携**：WMIアクセス権限の確認方法が不明
  - 候補：管理者権限での実行 / WMI権限チェック処理追加
- **IT-030 WebSocketブラウザ連携**：Internet Explorerの利用可能性が環境依存
  - 候補：Chrome DevTools Protocol対応 / Edge WebView2対応

## 5) リスクフラグ（レビュー観点）
- 0: IT-001~IT-013, IT-015~IT-016, IT-018, IT-020~IT-029（低リスク：十分な根拠あり）
- 1: IT-017, IT-019（中リスク：一部根拠不足だがコード上は実装確認済み）
- 2: IT-014, IT-030（高リスク：環境依存または外部サービス依存のため要検証）

## 6) レビュアーチェックリスト（最小）
- [ ] stdHTTP-stdCallback認証連携（IT-001）のAuthenticatorバインディングが正しいか確認
- [ ] stdArray-stdLambda連携（IT-004）のパフォーマンスが許容範囲内か確認
- [ ] stdProcess-stdLambda連携（IT-006）のクエリ条件が適切か確認
- [ ] stdJSON-Dictionary連携（IT-010）のキー順序保持について確認
- [ ] stdHTTP非同期処理（IT-018）のタイムアウト設定が適切か確認
- [ ] stdCallback.CreateFromPointer（IT-025）のメモリ安全性を確認
- [ ] IE依存のstdWebSocket（IT-030）の代替実装を検討
