---
generated_at: 2026-01-15 18:52:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：通知一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. なし（すべての主張に根拠あり）

### 重要な注記
本プロジェクト（stdVBA）はVBA標準ライブラリであり、**エンドユーザー向けの通知機能（メール、SMS、プッシュ通知等）は含まれていません**。

本通知一覧では、代わりにVBAの**イベントベースの内部通知機構（イベントハンドリング）**を「通知」として記載しています。これらは：
- クラス内部で発火するVBAイベント（`Public Event`）
- Win32 APIを使用したウィンドウメッセージ送信機能
- コールバックリスナー機構

を含みます。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/stdCallback.cls` 行166-174（BeforeRun/AfterRunイベント定義）
- E-02: `src/stdWebSocket.cls` 行36-56（WebSocketイベント定義）
- E-03: `src/stdWebSocket.cls` 行60（Listenersコレクション）
- E-04: `src/stdWebSocket.cls` 行148-167（handleEventメソッド）
- E-05: `src/stdTimer.cls` 行45（Tickイベント定義）
- E-06: `src/stdTimer.cls` 行176-182（SheetChangeイベントフック）
- E-07: `src/stdClipboard.cls` 行613-633（SendPaste/SendCopy関数）
- E-08: `src/WIP/stdExcelLibraries/stdXLEvents.cls` 行10-21（Excel選択イベント定義）
- E-09: `src/WIP/stdTable/stdXLEvents.cls`（テーブル用イベント定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BeforeRunイベントはstdCallbackで定義されている | E-01 | ○ |
| C-02 | AfterRunイベントはstdCallbackで定義されている | E-01 | ○ |
| C-03 | EventRaisedイベントはstdWebSocketで定義されている | E-02 | ○ |
| C-04 | OnOpenイベントはstdWebSocketで定義されている | E-02 | ○ |
| C-05 | OnCloseイベントはstdWebSocketで定義されている | E-02 | ○ |
| C-06 | OnErrorイベントはstdWebSocketで定義されている | E-02 | ○ |
| C-07 | OnMessageイベントはstdWebSocketで定義されている | E-02 | ○ |
| C-08 | TickイベントはstdTimerで定義されている | E-05 | ○ |
| C-09 | SelectionChangeイベントはstdXLEventsで定義されている | E-08 | ○ |
| C-10 | RangeSelectionChangeイベントはstdXLEventsで定義されている | E-08 | ○ |
| C-11 | RangeSelectedイベントはstdXLEventsで定義されている | E-08 | ○ |
| C-12 | RangeDeselectedイベントはstdXLEventsで定義されている | E-08 | ○ |
| C-13 | ShapeSelectionChangeイベントはstdXLEventsで定義されている | E-08 | ○ |
| C-14 | ShapeSelectedイベントはstdXLEventsで定義されている | E-08 | ○ |
| C-15 | ShapeDeselectedイベントはstdXLEventsで定義されている | E-08 | ○ |
| C-16 | ChartSelectedイベントはstdXLEventsで定義されている | E-08 | ○ |
| C-17 | ChartDeselectedイベントはstdXLEventsで定義されている | E-08 | ○ |
| C-18 | SendPaste機能はstdClipboardで定義されている | E-07 | ○ |
| C-19 | SendCopy機能はstdClipboardで定義されている | E-07 | ○ |
| C-20 | ListenersコレクションはstdWebSocketで定義されている | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- **エンドユーザー向け通知機能は存在しない**：本プロジェクトはVBAライブラリのため、メール送信、SMS、プッシュ通知等のエンドユーザー向け通知機能は実装されていません。
- WIP（開発中）フォルダのイベントは将来変更される可能性があります。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - すべての通知（イベント）はソースコードで直接確認可能
- **0: 低リスク** - WIP配下のファイル（stdXLEvents等）は開発中のため、本番利用前に再確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 本プロジェクトがVBAライブラリであり、エンドユーザー向け通知機能が不要であることを確認
- [ ] 各イベント定義がソースコードの該当行に存在することを確認
- [ ] WIP配下のイベントが本番環境で使用される場合、安定性を確認
- [ ] stdWebSocketのイベントハンドリング機構（handleEventメソッド）の動作を確認
- [ ] stdTimerのTickイベントがRemote Workbook経由で動作することを理解
