# 通知設計書 11-RangeSelected

## 概要

本ドキュメントは、stdXLEventsクラスにおけるRangeSelectedイベントの設計について記載する。このイベントは、Excel上でセル範囲（Range）が選択された際に発火するイベント通知機能を提供する。

### 本通知の処理概要

RangeSelectedイベントは、stdXLEventsクラス内でExcelのセル範囲選択操作を監視し、新しいRangeが選択されたタイミングで自動的に発火する機能である。CommandBarsのOnUpdateイベントをトリガーとして選択状態の変更を検知し、Range型オブジェクトが新規に選択された場合にイベントを発行する。

**業務上の目的・背景**：VBAマクロ開発において、ユーザーのセル選択操作に応じた処理を実装する際、標準のWorksheet_SelectionChangeイベントでは対応できないシートを跨いだ監視や、より柔軟なイベントハンドリングが必要となる場合がある。本イベントはアプリケーション全体でのRange選択を監視し、選択変更時に適切な処理を実行できる基盤を提供する。

**通知の送信タイミング**：CommandBars.OnUpdateイベントが発火し、現在の選択オブジェクトがRange型であり、かつ前回の選択状態と異なる場合に送信される。具体的には、ユーザーがマウスやキーボードでセル範囲を選択した際、または VBAコードによってSelection/Activateが実行された際に発火する。

**通知の受信者**：stdXLEventsクラスのインスタンスに対してWithEventsキーワードで接続しているVBAモジュールが受信者となる。イベントハンドラを実装したクラスモジュールまたは標準モジュールで処理を受け取る。

**通知内容の概要**：選択されたRangeオブジェクト（Target）が引数として渡される。これにより受信側は選択されたセル範囲のアドレス、値、書式などすべてのプロパティにアクセス可能となる。

**期待されるアクション**：受信者は渡されたRangeオブジェクトに基づき、選択されたセルの強調表示、データ検証、コンテキストに応じたUI更新、関連データの表示、入力補助機能の提供などのアクションを実行することが期待される。

## 通知種別

イベント（VBA Publicイベント）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 中 |
| リトライ | 無 |

### 送信先決定ロジック

WithEventsキーワードでstdXLEventsインスタンスを保持しているすべてのVBAオブジェクトに対して、VBAのイベント発火機構によって自動的に通知される。

## 通知テンプレート

### イベント通知の場合

| 項目 | 内容 |
|-----|------|
| イベント名 | RangeSelected |
| 引数 | Target As Range |
| スコープ | Public |

### イベントシグネチャ

```vb
Public Event RangeSelected(Target As Range)
```

### 添付ファイル

該当なし（VBAイベントのため添付ファイルは存在しない）

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| Target | 選択されたセル範囲 | Selection（Range型） | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| ユーザー操作 | CommandBars.OnUpdate | 選択がRange型で、かつ前回と異なる場合 | ユーザーによるセル選択操作時 |
| VBAコード | Selection変更 | 選択がRange型で、かつ前回と異なる場合 | VBAコードによる選択変更時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 選択オブジェクトがRange以外 | Shape、Chart等が選択された場合は発火しない |
| 前回の選択と同一 | 選択内容が変更されていない場合は発火しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[CommandBars.OnUpdate発火] --> B[getSelection関数で現在選択を取得]
    B --> C{前回選択と異なる?}
    C -->|No| D[処理終了]
    C -->|Yes| E[SelectionChangeイベント発火]
    E --> F{現在選択がRange型?}
    F -->|No| G{前回選択がRange型?}
    F -->|Yes| H{前回選択がRange型?}
    G -->|No| D
    G -->|Yes| I[RangeDeselectedイベント発火]
    H -->|Yes| J[RangeDeselectedイベント発火]
    H -->|No| K[RangeSelectedイベント発火]
    J --> K
    I --> D
    K --> D
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（メモリ内オブジェクトを使用）

### 内部データ構造

| 構造名 | 用途 | 備考 |
|--------|------|------|
| SelectionInfo | 選択状態の管理 | UDT構造体 |

#### SelectionInfo構造体

| フィールド | 型 | 用途 |
|-----------|-----|------|
| iType | ESelectionType | 選択オブジェクトの種別 |
| oObj | Object | 選択オブジェクト参照 |
| oWB | Workbook | 所属ブック |
| oWS | Worksheet | 所属シート |
| sID | String | オブジェクト識別子 |
| sPath | String | オブジェクトパス |
| vMeta | Variant | メタデータ |

### 更新テーブル一覧

該当なし（状態はメモリ内変数で管理）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| オブジェクト参照エラー | Selectionがnothingの場合 | イベント発火をスキップ |
| 型変換エラー | 予期しない選択オブジェクト型 | ESelectionType.EmptySelectionとして処理 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（Excelアプリケーション起動中は常時有効）

## セキュリティ考慮事項

- イベントはVBAプロセス内で完結するため、外部への情報漏洩リスクは低い
- Rangeオブジェクトを通じてセル内容にアクセス可能なため、イベントハンドラ実装時は機密データの取り扱いに注意

## 備考

- stdXLEventsクラスは現在WIP（Work In Progress）ステータスのため、APIが変更される可能性がある
- CommandBars.OnUpdateイベントに依存しているため、Excelのバージョンによって動作が異なる可能性がある

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、選択状態を管理するためのデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | stdXLEvents.cls | `src/WIP/stdExcelLibraries/stdXLEvents.cls` | 行27-76のESelectionType列挙型とSelectionInfo構造体定義を確認 |

**読解のコツ**: VBAの列挙型（Enum）とユーザー定義型（Type）の記法を理解し、選択可能なオブジェクトの種類を把握する。

#### Step 2: エントリーポイントを理解する

処理の起点となるイベントハンドラを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | stdXLEvents.cls | `src/WIP/stdExcelLibraries/stdXLEvents.cls` | 行80-148のcbs_OnUpdate()プロシージャがメインエントリーポイント |

**主要処理フロー**:
1. **行81**: Static変数oldSelectionで前回選択を保持
2. **行82**: getSelection()で現在の選択状態を取得
3. **行83**: selectionsAreDifferent()で変更有無を判定
4. **行86-97**: Range関連イベントの処理ブロック
5. **行93**: RangeSelectedイベントの発火

#### Step 3: 選択状態取得処理を理解する

選択オブジェクトの情報取得ロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | stdXLEvents.cls | `src/WIP/stdExcelLibraries/stdXLEvents.cls` | 行156-163のgetSelection()関数 |

**主要処理フロー**:
- **行157-158**: 選択オブジェクトの所属Workbook/Worksheetを取得
- **行159**: 現在のSelectionオブジェクトを保存
- **行160-162**: オブジェクトID、パス、型を取得

#### Step 4: 選択比較ロジックを理解する

前回選択との比較ロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | stdXLEvents.cls | `src/WIP/stdExcelLibraries/stdXLEvents.cls` | 行237-254のselectionsAreDifferent()関数 |

**主要処理フロー**:
- **行238**: 型の比較
- **行239-240**: Workbook/Worksheetの比較
- **行243**: パスの比較で最終判定

#### Step 5: イベント宣言を確認する

イベントの定義と引数を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | stdXLEvents.cls | `src/WIP/stdExcelLibraries/stdXLEvents.cls` | 行13のRangeSelectedイベント宣言 |

### プログラム呼び出し階層図

```
cbs_OnUpdate (CommandBarsイベントハンドラ)
    │
    ├─ getSelection()
    │      ├─ getObjAncestor() ... Workbook/Worksheet取得
    │      ├─ getObjID() ... オブジェクトID取得
    │      ├─ getObjPath() ... オブジェクトパス取得
    │      └─ getObjType() ... オブジェクト型判定
    │
    ├─ selectionsAreDifferent()
    │      └─ 型、ブック、シート、パスの比較
    │
    └─ RaiseEvent RangeSelected(newSelection.oObj)
```

### データフロー図

```
[入力]                    [処理]                        [出力]

CommandBars.OnUpdate ───> cbs_OnUpdate()
                              │
Application.Selection ────────┼──> getSelection() ───> SelectionInfo構造体
                              │
oldSelection (Static) ────────┼──> selectionsAreDifferent()
                              │
                              v
                    RaiseEvent RangeSelected ───> Target (Range) ───> イベントハンドラ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| stdXLEvents.cls | `src/WIP/stdExcelLibraries/stdXLEvents.cls` | ソース | RangeSelectedイベントを含むイベント管理クラス |
| stdXLEvents.cls | `src/WIP/stdTable/stdXLEvents.cls` | ソース | 別バージョンのstdXLEvents（参考用） |
