# 通知設計書 13-ShapeSelectionChange

## 概要

本ドキュメントは、stdXLEventsクラスにおけるShapeSelectionChangeイベントの設計について記載する。このイベントは、Excel上でShape（図形）の選択状態が変更された際に発火するイベント通知機能を提供する。

### 本通知の処理概要

ShapeSelectionChangeイベントは、stdXLEventsクラス内でExcelのShape選択状態を監視し、選択されているShapeのセットが変更されたタイミングで自動的に発火する機能である。CommandBarsのOnUpdateイベントをトリガーとして選択状態の変更を検知し、Shape、ShapeRange、またはChartAreaの選択状態が変更された場合にイベントを発行する。旧選択と新選択のShapeコレクションを引数として渡すことで、どのShapeが選択/選択解除されたかを特定可能にする。

**業務上の目的・背景**：VBAマクロ開発において、ユーザーのShape選択操作に応じた処理を実装する際、標準イベントでは対応できない複数Shape選択の監視や、選択前後の比較が必要となる場合がある。本イベントは旧選択と新選択の両方を提供することで、選択状態の差分を検出し、適切な処理を実行できる基盤を提供する。

**通知の送信タイミング**：CommandBars.OnUpdateイベントが発火し、現在の選択オブジェクトがShape、ShapeRange、またはChartArea型であり、かつ前回の選択状態と異なる場合に送信される。具体的には、ユーザーがマウスやキーボードでShapeを選択/選択解除した際、または VBAコードによって選択が変更された際に発火する。

**通知の受信者**：stdXLEventsクラスのインスタンスに対してWithEventsキーワードで接続しているVBAモジュールが受信者となる。イベントハンドラを実装したクラスモジュールまたは標準モジュールで処理を受け取る。

**通知内容の概要**：旧選択のShapeコレクション（cOld）と新選択のShapeコレクション（cNew）が引数として渡される。これにより受信側は選択状態の変化を詳細に把握し、追加された Shape や削除されたShapeを特定可能となる。

**期待されるアクション**：受信者は渡されたコレクションを比較し、選択状態に応じたプロパティパネルの更新、選択Shapeの強調表示、コンテキストメニューの構成変更、選択Shapeに対する一括操作の有効化などのアクションを実行することが期待される。

## 通知種別

イベント（VBA Publicイベント）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 中 |
| リトライ | 無 |

### 送信先決定ロジック

WithEventsキーワードでstdXLEventsインスタンスを保持しているすべてのVBAオブジェクトに対して、VBAのイベント発火機構によって自動的に通知される。

## 通知テンプレート

### イベント通知の場合

| 項目 | 内容 |
|-----|------|
| イベント名 | ShapeSelectionChange |
| 引数 | cOld As Collection, cNew As Collection |
| スコープ | Public |

### イベントシグネチャ

```vb
Public Event ShapeSelectionChange(cOld As Collection, cNew As Collection)
```

### 添付ファイル

該当なし（VBAイベントのため添付ファイルは存在しない）

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| cOld | 旧選択のShapeコレクション | getShapesCol(oldSelection) | Yes |
| cNew | 新選択のShapeコレクション | getShapesCol(newSelection) | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| ユーザー操作 | CommandBars.OnUpdate | 選択がShape/ShapeRange/ChartArea型で、かつ前回と異なる場合 | ユーザーによるShape選択操作時 |
| VBAコード | Selection変更 | 選択がShape/ShapeRange/ChartArea型で、かつ前回と異なる場合 | VBAコードによる選択変更時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 選択オブジェクトがShape関連以外 | Range、OLEObject等が選択された場合は発火しない |
| 前回の選択と同一 | 選択内容が変更されていない場合は発火しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[CommandBars.OnUpdate発火] --> B[getSelection関数で現在選択を取得]
    B --> C{前回選択と異なる?}
    C -->|No| D[処理終了]
    C -->|Yes| E[SelectionChangeイベント発火]
    E --> F{Shape関連の選択変更?}
    F -->|No| G[Shape関連イベントスキップ]
    F -->|Yes| H[getShapesColで旧新コレクション作成]
    G --> D
    H --> I[ShapeSelectionChangeイベント発火]
    I --> J[個別Shape/Chart選択イベント処理]
    J --> D
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（メモリ内オブジェクトを使用）

### 内部データ構造

| 構造名 | 用途 | 備考 |
|--------|------|------|
| SelectionInfo | 選択状態の管理 | UDT構造体 |
| Collection | Shapeコレクション | VBA標準Collection |

#### SelectionInfo構造体

| フィールド | 型 | 用途 |
|-----------|-----|------|
| iType | ESelectionType | 選択オブジェクトの種別（Shape/ShapeRange/ChartArea） |
| oObj | Object | 選択オブジェクト参照 |
| oWB | Workbook | 所属ブック |
| oWS | Worksheet | 所属シート |
| sID | String | オブジェクト識別子 |
| sPath | String | オブジェクトパス |
| vMeta | Variant | メタデータ |

### 更新テーブル一覧

該当なし（状態はメモリ内変数で管理）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| オブジェクト参照エラー | Selectionがnothingの場合 | イベント発火をスキップ |
| 型変換エラー | 予期しない選択オブジェクト型 | 空のCollectionを返す |
| ShapeRangeアクセスエラー | ShapeRangeプロパティが無効な場合 | イベント発火をスキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（Excelアプリケーション起動中は常時有効）

## セキュリティ考慮事項

- イベントはVBAプロセス内で完結するため、外部への情報漏洩リスクは低い
- Shapeオブジェクトを通じてシート内容にアクセス可能なため、イベントハンドラ実装時は取り扱いに注意

## 備考

- stdXLEventsクラスは現在WIP（Work In Progress）ステータスのため、APIが変更される可能性がある
- Shape、ShapeRange、ChartArea選択時にそれぞれ発火する
- getShapesCol関数により、選択タイプに関係なくShapeのCollectionとして統一された形式で提供される
- CommandBars.OnUpdateイベントに依存しているため、Excelのバージョンによって動作が異なる可能性がある

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、選択状態を管理するためのデータ構造とShape関連の型を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | stdXLEvents.cls | `src/WIP/stdExcelLibraries/stdXLEvents.cls` | 行27-66のESelectionType列挙型でShape/ShapeRange/ChartAreaを確認 |
| 1-2 | stdXLEvents.cls | `src/WIP/stdExcelLibraries/stdXLEvents.cls` | 行67-76のSelectionInfo構造体定義を確認 |

**読解のコツ**: ESelectionType列挙型でShape=59、ShapeRange=60、ChartArea=73であることを把握する。

#### Step 2: エントリーポイントを理解する

処理の起点となるイベントハンドラを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | stdXLEvents.cls | `src/WIP/stdExcelLibraries/stdXLEvents.cls` | 行80-148のcbs_OnUpdate()プロシージャがメインエントリーポイント |

**主要処理フロー**:
1. **行81**: Static変数oldSelectionで前回選択を保持
2. **行82**: getSelection()で現在の選択状態を取得
3. **行83**: selectionsAreDifferent()で変更有無を判定
4. **行99-110**: Shape関連イベントの処理ブロック
5. **行101,115,134**: ShapeSelectionChangeイベントの発火箇所

#### Step 3: Shape選択イベント処理を理解する

Shape選択変更時の処理ロジックを詳細に理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | stdXLEvents.cls | `src/WIP/stdExcelLibraries/stdXLEvents.cls` | 行99-130のShape/ShapeRange関連処理ブロック |
| 3-2 | stdXLEvents.cls | `src/WIP/stdExcelLibraries/stdXLEvents.cls` | 行132-143のChartArea関連処理ブロック |

**主要処理フロー**:
- **行100**: oldSelection.iType = Shape OR newSelection.iType = Shape の条件判定
- **行101**: getShapesColで旧新コレクションを取得してイベント発火
- **行114**: ShapeRange選択の条件判定
- **行115**: ShapeRange用のイベント発火
- **行133**: ChartArea選択の条件判定
- **行134**: ChartArea用のイベント発火

#### Step 4: getShapesCol関数を理解する

Shapeコレクション作成ロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | stdXLEvents.cls | `src/WIP/stdExcelLibraries/stdXLEvents.cls` | 行180-190のgetShapesCol()関数 |

**主要処理フロー**:
- **行181**: 新規Collectionを作成
- **行182-189**: SelectionInfoのiTypeに応じてShapeをCollectionに追加
  - Shape型: 単一Shapeを追加
  - ShapeRange型: 各Shapeをループで追加

#### Step 5: イベント宣言を確認する

イベントの定義と引数を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | stdXLEvents.cls | `src/WIP/stdExcelLibraries/stdXLEvents.cls` | 行16のShapeSelectionChangeイベント宣言 |

### プログラム呼び出し階層図

```
cbs_OnUpdate (CommandBarsイベントハンドラ)
    │
    ├─ getSelection()
    │      ├─ getObjAncestor() ... Workbook/Worksheet取得
    │      ├─ getObjID() ... オブジェクトID取得
    │      ├─ getObjPath() ... オブジェクトパス取得
    │      └─ getObjType() ... オブジェクト型判定 (Shape/ShapeRange/ChartArea)
    │
    ├─ selectionsAreDifferent()
    │      └─ 型、ブック、シート、パスの比較
    │
    ├─ getShapesCol(oldSelection) ───> cOld Collection
    │
    ├─ getShapesCol(newSelection) ───> cNew Collection
    │
    └─ RaiseEvent ShapeSelectionChange(cOld, cNew)
```

### データフロー図

```
[入力]                    [処理]                        [出力]

CommandBars.OnUpdate ───> cbs_OnUpdate()
                              │
Application.Selection ────────┼──> getSelection() ───> newSelection (SelectionInfo)
                              │
oldSelection (Static) ────────┼──> selectionsAreDifferent()
                              │
                              ├──> getShapesCol(oldSelection) ───> cOld (Collection)
                              │
                              ├──> getShapesCol(newSelection) ───> cNew (Collection)
                              │
                              v
                    RaiseEvent ShapeSelectionChange ───> (cOld, cNew) ───> イベントハンドラ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| stdXLEvents.cls | `src/WIP/stdExcelLibraries/stdXLEvents.cls` | ソース | ShapeSelectionChangeイベントを含むイベント管理クラス |
| stdXLEvents.cls | `src/WIP/stdTable/stdXLEvents.cls` | ソース | 別バージョンのstdXLEvents（参考用） |
