# 通知設計書 17-ChartDeselected

## 概要

本ドキュメントは、stdXLEventsクラスにおけるChartDeselectedイベントの設計について記載する。このイベントは、Excel上でChart（グラフ）型のShapeの選択が解除された際に発火するイベント通知機能を提供する。

### 本通知の処理概要

ChartDeselectedイベントは、stdXLEventsクラス内でExcelのShape選択状態を監視し、Chart型（msoChart）のShapeの選択が解除されたタイミングで自動的に発火する機能である。CommandBarsのOnUpdateイベントをトリガーとして選択状態の変更を検知し、RaiseShapeEventプロシージャを通じてShapeの種類を判別した上でイベントを発行する。Shape.Type = MsoShapeType.msoChartの場合にChartDeselectedイベントが発火し、それ以外のShapeの場合はShapeDeselectedイベントが発火する。

**業務上の目的・背景**：VBAマクロ開発において、ユーザーがグラフの選択を解除した際に、グラフ編集モードの終了、グラフプロパティパネルの非表示化、データソースハイライトの解除、一時的なグラフ設定のリセットなどの処理が必要となる場合がある。本イベントはChart型Shape選択解除を個別に検知し、グラフ専用のクリーンアップ処理を実行できる基盤を提供する。

**通知の送信タイミング**：CommandBars.OnUpdateイベントが発火し、前回選択されていたShape、ShapeRange、またはChartAreaが選択解除され、かつ対象ShapeがChart型（msoChart）の場合に送信される。RaiseShapeEventプロシージャがbSelected=Falseで呼び出され、Shape.Type = msoChartの判定が行われる。Chart型の場合にChartDeselectedイベントが発火する。

**通知の受信者**：stdXLEventsクラスのインスタンスに対してWithEventsキーワードで接続しているVBAモジュールが受信者となる。イベントハンドラを実装したクラスモジュールまたは標準モジュールで処理を受け取る。

**通知内容の概要**：選択が解除されたChart型のShapeオブジェクト（Target）が引数として渡される。これにより受信側は選択解除されたグラフの種類、データソース、設定などすべてのプロパティにアクセス可能となる。

**期待されるアクション**：受信者は渡されたShapeオブジェクト（Chart型）に基づき、グラフプロパティパネルの非表示化、グラフ編集モードの終了、データソースハイライトの解除、一時データのクリア、リソースの解放などのアクションを実行することが期待される。

## 通知種別

イベント（VBA Publicイベント）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 中 |
| リトライ | 無 |

### 送信先決定ロジック

WithEventsキーワードでstdXLEventsインスタンスを保持しているすべてのVBAオブジェクトに対して、VBAのイベント発火機構によって自動的に通知される。

## 通知テンプレート

### イベント通知の場合

| 項目 | 内容 |
|-----|------|
| イベント名 | ChartDeselected |
| 引数 | Target As Shape |
| スコープ | Public |

### イベントシグネチャ

```vb
Public Event ChartDeselected(Target As Shape)
```

### 添付ファイル

該当なし（VBAイベントのため添付ファイルは存在しない）

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| Target | 選択が解除されたChart型Shape | oldSelection.oObj.ShapeRange(1) または Chart親Shape | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| ユーザー操作 | CommandBars.OnUpdate | 前回Chart型Shape選択 | ユーザーによる選択変更操作時 |
| VBAコード | Selection変更 | 前回Chart型Shape選択 | VBAコードによる選択変更時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| Chart型でないShape | 通常のShapeの場合はShapeDeselectedが発火 |
| 前回選択オブジェクトがShape関連以外 | Range、OLEObject等が選択されていた場合は発火しない |
| 前回の選択と同一 | 選択内容が変更されていない場合は発火しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[CommandBars.OnUpdate発火] --> B[getSelection関数で現在選択を取得]
    B --> C{前回選択と異なる?}
    C -->|No| D[処理終了]
    C -->|Yes| E[SelectionChangeイベント発火]
    E --> F{前回選択がShape関連?}
    F -->|No| G[Shape関連イベントスキップ]
    F -->|Yes| H[RaiseShapeEvent呼び出し bSelected=False]
    G --> D
    H --> I{shp.Type = msoChart?}
    I -->|No| J[ShapeDeselectedイベント発火]
    I -->|Yes| K[ChartDeselectedイベント発火]
    J --> L[新選択の処理へ]
    K --> L
    L --> D
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（メモリ内オブジェクトを使用）

### 内部データ構造

| 構造名 | 用途 | 備考 |
|--------|------|------|
| SelectionInfo | 選択状態の管理 | UDT構造体 |
| MsoShapeType | Shape種類の判定 | Excel定義列挙型（msoChart = 3） |

#### SelectionInfo構造体

| フィールド | 型 | 用途 |
|-----------|-----|------|
| iType | ESelectionType | 選択オブジェクトの種別 |
| oObj | Object | 選択オブジェクト参照 |
| oWB | Workbook | 所属ブック |
| oWS | Worksheet | 所属シート |
| sID | String | オブジェクト識別子 |
| sPath | String | オブジェクトパス |
| vMeta | Variant | メタデータ |

### 更新テーブル一覧

該当なし（状態はメモリ内変数で管理）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| オブジェクト参照エラー | ShapeがNothingの場合 | イベント発火をスキップ |
| 型アクセスエラー | Shape.Typeプロパティへのアクセス失敗 | イベント発火をスキップ |
| Chart親参照エラー | ChartArea選択解除時のparent.parent.ShapeRange(1)アクセス失敗 | イベント発火をスキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（Excelアプリケーション起動中は常時有効）

## セキュリティ考慮事項

- イベントはVBAプロセス内で完結するため、外部への情報漏洩リスクは低い
- Shapeオブジェクトを通じてChartデータにアクセス可能なため、イベントハンドラ実装時は取り扱いに注意

## 備考

- stdXLEventsクラスは現在WIP（Work In Progress）ステータスのため、APIが変更される可能性がある
- Chart型でないShapeの場合はChartDeselectedではなくShapeDeselectedが発火する
- ChartArea選択解除時は、parent.parent.ShapeRange(1)でChart型Shapeを取得してイベントを発火する
- ChartDeselectedはChartSelectedより先に発火する（Chart間での選択変更時）
- CommandBars.OnUpdateイベントに依存しているため、Excelのバージョンによって動作が異なる可能性がある

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、Shape型とMsoShapeType列挙型を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | stdXLEvents.cls | `src/WIP/stdExcelLibraries/stdXLEvents.cls` | 行27-66のESelectionType列挙型でChartArea等を確認 |
| 1-2 | （Excel参照） | Microsoft Excel Object Library | MsoShapeType.msoChart = 3の定義を確認 |

**読解のコツ**: MsoShapeType.msoChart = 3であることを理解し、Chart型Shapeの判別方法を把握する。

#### Step 2: エントリーポイントを理解する

処理の起点となるイベントハンドラを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | stdXLEvents.cls | `src/WIP/stdExcelLibraries/stdXLEvents.cls` | 行80-148のcbs_OnUpdate()プロシージャがメインエントリーポイント |

**主要処理フロー**:
1. **行81**: Static変数oldSelectionで前回選択を保持
2. **行82**: getSelection()で現在の選択状態を取得
3. **行83**: selectionsAreDifferent()で変更有無を判定
4. **行132-143**: ChartArea関連イベントの処理ブロック
5. **行137,141**: RaiseShapeEvent呼び出し（bSelected=False、ChartArea経由）

#### Step 3: RaiseShapeEventプロシージャを理解する

Shape/Chart振り分けロジックを詳細に理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | stdXLEvents.cls | `src/WIP/stdExcelLibraries/stdXLEvents.cls` | 行164-178のRaiseShapeEvent()プロシージャ |

**主要処理フロー**:
- **行165**: shp.Type = MsoShapeType.msoChart の条件判定
- **行166-170**: Chart型の場合の処理
- **行169**: ChartDeselectedイベントの発火（bSelected=Falseの場合）

#### Step 4: イベント宣言を確認する

イベントの定義と引数を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | stdXLEvents.cls | `src/WIP/stdExcelLibraries/stdXLEvents.cls` | 行21のChartDeselectedイベント宣言 |

### プログラム呼び出し階層図

```
cbs_OnUpdate (CommandBarsイベントハンドラ)
    │
    ├─ getSelection()
    │      ├─ getObjAncestor() ... Workbook/Worksheet取得
    │      ├─ getObjID() ... オブジェクトID取得
    │      ├─ getObjPath() ... オブジェクトパス取得
    │      └─ getObjType() ... オブジェクト型判定
    │
    ├─ selectionsAreDifferent()
    │
    └─ RaiseShapeEvent(oldSelection.oObj.ShapeRange(1), bSelected=False)
           │
           ├─ shp.Type = msoChart ───> RaiseEvent ChartDeselected(shp)
           │
           └─ shp.Type <> msoChart ───> ShapeDeselectedイベント
```

### データフロー図

```
[入力]                    [処理]                        [出力]

CommandBars.OnUpdate ───> cbs_OnUpdate()
                              │
Application.Selection ────────┼──> getSelection() ───> newSelection (SelectionInfo)
                              │
oldSelection (Static) ────────┼──> selectionsAreDifferent()
                              │
                              v
                    oldSelection.oObj.ShapeRange(1) または
                    oldSelection.oObj.parent.parent.ShapeRange(1) [ChartAreaの場合]
                              │
                              v
                    RaiseShapeEvent(shp, False)
                              │
                              ├─ Type = msoChart ───> ChartDeselected ───> Target (Shape) ───> イベントハンドラ
                              │                                           [旧選択Chart]
                              └─ Type <> msoChart ───> ShapeDeselected
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| stdXLEvents.cls | `src/WIP/stdExcelLibraries/stdXLEvents.cls` | ソース | ChartDeselectedイベントを含むイベント管理クラス |
| stdXLEvents.cls | `src/WIP/stdTable/stdXLEvents.cls` | ソース | 別バージョンのstdXLEvents（参考用） |
