# 通知設計書 19-SendCopy

## 概要

本ドキュメントは、stdClipboardクラスにおけるSendCopyメソッドの設計について記載する。このメソッドは、指定したウィンドウハンドルに対してWM_COPYメッセージを送信し、コピーイベントを発火させる機能を提供する。

### 本通知の処理概要

SendCopyは、stdClipboardクラスが提供するメソッドで、Windows APIのSendMessageを使用して指定されたウィンドウに対してWM_COPY（0x301）メッセージを送信する機能である。これにより、対象ウィンドウにコピー操作を実行させることができる。VBAからウィンドウハンドル（hWnd）を指定して呼び出すことで、外部アプリケーションやコントロールに対してプログラム的にコピー操作をトリガーできる。

**業務上の目的・背景**：VBAマクロ開発において、特定のウィンドウやコントロールから選択されたデータをクリップボードにコピーさせる必要がある場合がある。例えば、外部アプリケーションからのデータ取得、UI自動化テスト、データ連携処理などのシナリオで使用される。本メソッドはウィンドウハンドルを指定してコピー操作を実行できる基盤を提供する。

**通知の送信タイミング**：VBAコードからSendCopyメソッドが明示的に呼び出された時点で即座にWM_COPYメッセージが送信される。同期的に実行されるため、メッセージ送信が完了するまで呼び出し元に制御が戻らない。

**通知の受信者**：引数で指定されたウィンドウハンドル（hWnd）に対応するウィンドウが受信者となる。対象ウィンドウはWM_COPYメッセージを受け取り、そのウィンドウのメッセージハンドラが処理を実行する。

**通知内容の概要**：WM_COPY（0x301）メッセージがウィンドウに送信される。wParamとlParamは共に0が設定される。対象ウィンドウはこのメッセージを受信すると、選択されているデータをクリップボードにコピーする処理を実行する。

**期待されるアクション**：受信ウィンドウは標準的なコピー処理を実行することが期待される。具体的には、現在選択されているデータをクリップボードにコピーする。

## 通知種別

Windowsメッセージ送信（WM_COPY）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（SendMessage使用） |
| 優先度 | 即時 |
| リトライ | 無 |

### 送信先決定ロジック

呼び出し元が明示的に指定したウィンドウハンドル（hWnd）に対して直接メッセージを送信する。ウィンドウハンドルの妥当性検証は行われない。

## 通知テンプレート

### Windowsメッセージの場合

| 項目 | 内容 |
|-----|------|
| メッセージID | WM_COPY（0x301） |
| wParam | 0 |
| lParam | 0 |

### メソッドシグネチャ

```vb
' VBA7 (64ビット) の場合
Public Sub SendCopy(ByVal hwnd As LongPtr)

' VBA6 (32ビット) の場合
Public Sub SendCopy(ByVal hwnd As Long)
```

### 添付ファイル

該当なし（Windowsメッセージのため添付ファイルは存在しない）

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| hwnd | 送信先ウィンドウハンドル | 呼び出し元が指定 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| VBAコード | SendCopyメソッド呼び出し | hWndが指定されていること | 明示的なメソッド呼び出し |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| なし | 条件なしで常に送信される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[VBAコードからSendCopy呼び出し] --> B[WM_COPY定数を設定 0x301]
    B --> C[SendMessage API呼び出し]
    C --> D[対象ウィンドウでコピー処理実行]
    D --> E[選択データがクリップボードにコピー]
    E --> F[処理完了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（Windows APIを直接使用）

### Windows API依存

| API名 | 用途 | DLL |
|-------|------|-----|
| SendMessage | ウィンドウへのメッセージ送信 | user32.dll |

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 無効なウィンドウハンドル | hWndが無効な場合 | SendMessageは失敗するが、エラーは発生しない |
| ウィンドウが応答しない | 対象ウィンドウがハングしている場合 | SendMessageがブロックされる可能性あり |
| 選択なし | 対象ウィンドウで何も選択されていない場合 | コピー操作は実行されるが、クリップボードは更新されない |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（プログラムから呼び出し可能な時間は常時）

## セキュリティ考慮事項

- 任意のウィンドウハンドルを指定できるため、意図しないウィンドウからコピー操作を実行する可能性がある
- 対象ウィンドウの選択データがクリップボードにコピーされるため、機密データの取り扱いに注意
- SendMessageは同期的に実行されるため、対象ウィンドウの応答によってはVBAがブロックされる可能性がある

## 備考

- WM_COPYメッセージに対応していないウィンドウでは、コピー操作は実行されない
- 32ビット/64ビットVBAの両方に対応（条件付きコンパイル使用）
- SendCopyはSendPasteと対をなすメソッドで、クリップボード操作の自動化に使用される
- 対象ウィンドウがフォーカスを持っていなくてもメッセージは送信される
- コピー後のクリップボード内容はstdClipboard.textやstdClipboard.valueで取得可能

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: Windows APIの宣言を理解する

まず、SendMessage APIの宣言を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | stdClipboard.cls | `src/stdClipboard.cls` | 行124（VBA7用SendMessage宣言）または行160（VBA6用） |

**読解のコツ**: VBA7とVBA6で条件付きコンパイルが使用されており、64ビット環境ではLongPtr型、32ビット環境ではLong型が使用される。

#### Step 2: SendCopyメソッドを理解する

メソッドの実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | stdClipboard.cls | `src/stdClipboard.cls` | 行624-633のSendCopyメソッド実装 |

**主要処理フロー**:
1. **行627-630**: 条件付きコンパイルでVBA7/VBA6を切り分け
2. **行631**: WM_COPY定数（0x301）を定義
3. **行632**: SendMessage APIを呼び出してWM_COPYを送信

#### Step 3: WM_COPY定数を確認する

WindowsメッセージIDの定義を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | stdClipboard.cls | `src/stdClipboard.cls` | 行631のWM_COPY定数定義（0x301） |

#### Step 4: 関連メソッドを確認する

SendPasteメソッドとの関連を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | stdClipboard.cls | `src/stdClipboard.cls` | 行615-622のSendPasteメソッド（対となるメソッド） |

### プログラム呼び出し階層図

```
VBAコード（呼び出し元）
    │
    └─ stdClipboard.SendCopy(hwnd)
           │
           └─ SendMessage(hwnd, WM_COPY, 0, 0)
                  │
                  └─ 対象ウィンドウのWndProc
                         │
                         └─ コピー処理実行
                                │
                                └─ クリップボードにデータ格納
```

### データフロー図

```
[入力]                    [処理]                        [出力]

VBAコード ───> SendCopy(hwnd)
                    │
                    v
              WM_COPY = 0x301
                    │
                    v
              SendMessage API ───> ウィンドウメッセージキュー
                                        │
                                        v
                                   対象ウィンドウ
                                        │
                                        v
                                   選択データをクリップボードにコピー
                                        │
                                        v
                                   クリップボード（システム共有）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| stdClipboard.cls | `src/stdClipboard.cls` | ソース | SendCopyメソッドを含むクリップボード管理クラス |
