# 通知設計書 20-Listeners

## 概要

本ドキュメントは、stdWebSocketクラスにおけるListenersプロパティの設計について記載する。このプロパティは、WebSocketイベントに対するコールバックリスナーを格納するCollectionを提供し、イベント駆動型のWebSocket通信を実現する機能を提供する。

### 本通知の処理概要

Listenersは、stdWebSocketクラスが提供するPublicなCollectionプロパティで、WebSocketイベント（OnOpen、OnClose、OnError、OnMessage）発生時に呼び出されるコールバックオブジェクト（stdICallable実装オブジェクト）を格納する。handleEventプロシージャ内でイベントが発生すると、Listenersコレクション内のすべてのリスナーに対してRunメソッドが呼び出され、イベント名とイベントデータが渡される。これにより、WithEventsを使用せずにイベントハンドリングが可能となる。

**業務上の目的・背景**：VBAのWithEventsには制限があり、クラスモジュール内でのみ使用可能である。Listenersパターンを使用することで、標準モジュールからもイベントを購読でき、動的なイベントハンドラの追加・削除が可能となる。また、複数のリスナーを登録することで、同一イベントに対して複数の処理を実行できる柔軟性を提供する。

**通知の送信タイミング**：WebSocketのonopen、onclose、onerror、onmessageイベントがJavaScript側で発火し、handleEventプロシージャが呼び出された時点で、Listeners内のすべてのコールバックに対して通知が送信される。

**通知の受信者**：ListenersコレクションにAddされたstdICallableインターフェースを実装するオブジェクトが受信者となる。各リスナーのRunメソッドがイベント名とイベントデータを引数として呼び出される。

**通知内容の概要**：イベント名（"Open"/"Close"/"Error"/"Message"）とイベントデータ（JavaScriptのイベントオブジェクト）がリスナーに渡される。イベントデータにはWebSocket接続の状態やメッセージ内容などの情報が含まれる。

**期待されるアクション**：各リスナーはイベント名に応じた処理を実行することが期待される。例えば、OnOpenでは接続完了通知、OnMessageではメッセージの解析と処理、OnErrorではエラーログの記録などが考えられる。

## 通知種別

コールバック（stdICallable.Run呼び出し）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 中 |
| リトライ | 無 |

### 送信先決定ロジック

ListenersコレクションにAddされたすべてのオブジェクトに対して、For Eachループで順次Runメソッドを呼び出す。登録順に実行される。

## 通知テンプレート

### コールバックの場合

| 項目 | 内容 |
|-----|------|
| プロパティ名 | Listeners |
| 型 | Collection |
| 格納要素 | stdICallable実装オブジェクト |
| スコープ | Public |

### プロパティ宣言

```vb
Public Listeners As Collection 'Collection<stdICallable>
```

### コールバック呼び出しシグネチャ

```vb
listener.Run(sEventName, oEventData)
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| sEventName | イベント名（"Open"/"Close"/"Error"/"Message"） | handleEventの引数 | Yes |
| oEventData | イベントデータオブジェクト | handleEventの引数（JavaScriptイベント） | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| WebSocketイベント | ws.onopen | Listenersにオブジェクトが登録されていること | 接続開設時 |
| WebSocketイベント | ws.onclose | Listenersにオブジェクトが登録されていること | 接続終了時 |
| WebSocketイベント | ws.onerror | Listenersにオブジェクトが登録されていること | エラー発生時 |
| WebSocketイベント | ws.onmessage | Listenersにオブジェクトが登録されていること | メッセージ受信時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| Listenersが空 | 登録されたリスナーがない場合はループがスキップされる |
| リスナー実行エラー | On Error Resume Nextにより個別エラーは無視される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[WebSocketイベント発火 JavaScript] --> B[handleEventプロシージャ呼び出し]
    B --> C[VBAイベント発火 EventRaised/OnXxx]
    C --> D[For Each listener In Listeners]
    D --> E{リスナーあり?}
    E -->|No| F[処理終了]
    E -->|Yes| G[listener.Run sEventName, oEventData]
    G --> H[次のリスナーへ]
    H --> D
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（メモリ内オブジェクトを使用）

### 内部データ構造

| 構造名 | 用途 | 備考 |
|--------|------|------|
| Listeners | リスナーコレクション | VBA標準Collection |
| stdICallable | コールバックインターフェース | stdVBAライブラリ標準 |

#### Listenersコレクション構造

| 要素 | 型 | 説明 |
|------|-----|------|
| 各要素 | stdICallable | Runメソッドを持つコールバックオブジェクト |

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| リスナー実行エラー | listener.Runでエラー発生 | On Error Resume Nextで無視して次へ |
| Runメソッド未実装 | stdICallable非準拠オブジェクト | エラーは無視される |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（WebSocket接続が維持されている間は常時）

## セキュリティ考慮事項

- Listenersは任意のオブジェクトを登録できるため、悪意のあるコードが登録される可能性がある
- WebSocketメッセージには機密データが含まれる可能性があるため、リスナー内での取り扱いに注意
- On Error Resume Nextによりエラーが隠蔽されるため、デバッグ時は注意が必要

## 備考

- ListenersはprotInitプロシージャ内でNew Collectionとして初期化される
- VBAのイベント（OnOpen等）と併用可能で、両方が呼び出される
- リスナーの追加は`ws.Listeners.Add callback`で行う
- リスナーの削除はCollectionのRemoveメソッドを使用
- stdCallbackクラスのCreateFromObjectMethodを使用してリスナーを作成することが推奨される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: Listenersプロパティ宣言を理解する

まず、Listenersプロパティの宣言を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | stdWebSocket.cls | `src/stdWebSocket.cls` | 行60のListeners宣言 |

**読解のコツ**: Public Listenersとして宣言されており、stdICallableオブジェクトを格納するCollectionとして使用される。

#### Step 2: 初期化処理を理解する

Listenersの初期化を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | stdWebSocket.cls | `src/stdWebSocket.cls` | 行78-119のprotInitプロシージャ |
| 2-2 | stdWebSocket.cls | `src/stdWebSocket.cls` | 行108のListeners初期化 |

**主要処理フロー**:
1. **行108**: `Set Listeners = New Collection`でListenersを初期化

#### Step 3: handleEventプロシージャを理解する

リスナー呼び出しのメインロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | stdWebSocket.cls | `src/stdWebSocket.cls` | 行148-167のhandleEventプロシージャ |

**主要処理フロー**:
- **行153**: RaiseEvent EventRaisedでVBAイベント発火
- **行154-159**: Select Caseでイベント種類別にVBAイベント発火
- **行161**: On Error Resume Nextでエラー無視開始
- **行162-165**: For Each loopでListeners内の各リスナーにRunを呼び出し
- **行166**: On Error GoTo 0でエラー処理終了

#### Step 4: WebSocket JavaScript連携を理解する

JavaScriptとVBAの連携を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | stdWebSocket.cls | `src/stdWebSocket.cls` | 行111-118のJavaScript WebSocket設定 |

**主要処理フロー**:
- **行112-117**: JavaScriptのWebSocketイベントハンドラからVBAのhandleEventを呼び出す設定

### プログラム呼び出し階層図

```
JavaScript WebSocket
    │
    ├─ ws.onopen/onclose/onerror/onmessage
    │      │
    │      └─ vb_obj.handleEvent(sEventName, event)
    │             │
    │             ├─ RaiseEvent EventRaised(...)
    │             │
    │             ├─ RaiseEvent OnOpen/OnClose/OnError/OnMessage(...)
    │             │
    │             └─ For Each listener In Listeners
    │                    │
    │                    └─ listener.Run(sEventName, oEventData)
    │
    └─ VBAコード
           │
           └─ ws.Listeners.Add callback
```

### データフロー図

```
[入力]                      [処理]                        [出力]

WebSocketサーバー
      │
      v
JavaScript WebSocket ───> イベント発火 (onopen等)
                               │
                               v
                         vb_obj.handleEvent
                               │
                               ├───> RaiseEvent (VBAイベント) ───> WithEventsハンドラ
                               │
                               └───> Listeners.Run ───> 各stdICallableリスナー
                                          │
                                          v
                                    sEventName + oEventData
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| stdWebSocket.cls | `src/stdWebSocket.cls` | ソース | Listenersプロパティを含むWebSocket管理クラス |
| stdCallback.cls | `src/stdCallback.cls` | ソース | stdICallable実装クラス（リスナー作成に使用） |
| stdWebSocket.cls | `src/WIP/stdWebSocket/stdWebSocket.cls` | ソース | 別バージョンのstdWebSocket（参考用） |
