---
generated_at: 2026-01-15 10:48:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：10-RangeSelectionChange通知設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **WIPステータスの確認**：開発中の機能のため動作の安定性確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/WIP/stdExcelLibraries/stdXLEvents.cls` 行12（RangeSelectionChangeイベント宣言）
- E-02: `src/WIP/stdExcelLibraries/stdXLEvents.cls` 行88（RaiseEvent RangeSelectionChange呼び出し）
- E-03: `src/WIP/stdExcelLibraries/stdXLEvents.cls` 行13-14（RangeSelected/Deselectedイベント宣言）
- E-04: `src/WIP/stdExcelLibraries/stdXLEvents.cls` 行86-97（Range関連イベント発火処理）
- E-05: `src/WIP/stdExcelLibraries/stdXLEvents.cls` 行56（ESelectionType.Range定義）
- E-06: `src/WIP/stdExcelLibraries/stdXLEvents.cls` 行260（getObjTypeでのRange判定）
- E-07: `docs/code-to-docs/通知一覧/通知一覧.csv` 行11（RangeSelectionChange通知定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | RangeSelectionChangeイベントは行12で宣言されている | E-01 | ○ |
| C-02 | イベントはcbs_OnUpdate内行88で発火する | E-02 | ○ |
| C-03 | rOldRange/rNewRangeはRange型の引数 | E-01 | ○ |
| C-04 | 旧or新がRangeの場合に発火する | E-04（行87条件） | ○ |
| C-05 | IIf関数で条件付きRange/Nothing渡し | E-02, E-04 | ○ |
| C-06 | SelectionChangeの後に発火する | E-04（行84, 88の順序） | ○ |
| C-07 | RangeSelected/RangeDeselectedも併せて発火 | E-03, E-04（行89-96） | ○ |
| C-08 | ESelectionType.Rangeで型判定 | E-05 | ○ |
| C-09 | getObjTypeでTypeNameによる判定 | E-06 | ○ |
| C-10 | 通知一覧.csvに記載がある | E-07 | ○ |
| C-11 | WIPディレクトリに配置されている | ファイルパス確認 | ○ |
| C-12 | Range以外同士の変更では発火しない | E-04（行87条件） | ○ |
| C-13 | Range→Shape、Shape→Rangeでも発火 | E-04（Or条件） | ○ |
| C-14 | 本番環境での動作安定性 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-14について、WIPディレクトリに配置されており、本番環境での動作安定性が未確認
  - 候補：実行環境でのテスト / ユニットテスト / ベータテスト結果

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - WIP（開発中）の機能のため、APIが変更される可能性あり

## 6) レビュアーチェックリスト（最小）
- [ ] イベント宣言（行12）の引数型を確認
- [ ] Range関連イベント発火処理（行86-97）の条件分岐を確認
- [ ] IIf関数によるNothing渡しの動作を確認
- [ ] WIPステータスと本番利用の適合性を確認
