---
generated_at: 2026-01-15 19:42:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：13-ShapeSelectionChange

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **業務上の目的・背景の詳細**：ソースコードコメントに明示的記載なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/WIP/stdExcelLibraries/stdXLEvents.cls` 行16（ShapeSelectionChangeイベント宣言）
- E-02: `src/WIP/stdExcelLibraries/stdXLEvents.cls` 行80-148（cbs_OnUpdateプロシージャ）
- E-03: `src/WIP/stdExcelLibraries/stdXLEvents.cls` 行99-110（Shape関連イベント処理ブロック）
- E-04: `src/WIP/stdExcelLibraries/stdXLEvents.cls` 行101（ShapeSelectionChange発火箇所1）
- E-05: `src/WIP/stdExcelLibraries/stdXLEvents.cls` 行115（ShapeSelectionChange発火箇所2）
- E-06: `src/WIP/stdExcelLibraries/stdXLEvents.cls` 行134（ShapeSelectionChange発火箇所3）
- E-07: `src/WIP/stdExcelLibraries/stdXLEvents.cls` 行180-190（getShapesCol関数）
- E-08: `src/WIP/stdExcelLibraries/stdXLEvents.cls` 行23-24（CommandBars WithEvents宣言）
- E-09: `src/WIP/stdExcelLibraries/stdXLEvents.cls` 行27-66（ESelectionType列挙型）
- E-10: `src/WIP/stdExcelLibraries/stdXLEvents.cls` 行67-76（SelectionInfo構造体）
- E-11: `docs/code-to-docs/通知一覧/通知一覧.csv` 行14（通知一覧でのShapeSelectionChange定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ShapeSelectionChangeイベントはShape選択変更時に発火する | E-01, E-04, E-05, E-06 | ○ |
| C-02 | イベント引数はcOld As Collection, cNew As Collection | E-01 | ○ |
| C-03 | CommandBars.OnUpdateがトリガーとなる | E-02, E-08 | ○ |
| C-04 | Shape、ShapeRange、ChartArea選択時に発火 | E-03, E-04, E-05, E-06 | ○ |
| C-05 | SelectionInfo構造体で選択状態を管理 | E-10 | ○ |
| C-06 | ESelectionTypeでShape関連型を判定 | E-03, E-09 | ○ |
| C-07 | getShapesCol関数でCollectionを作成 | E-07 | ○ |
| C-08 | イベントはPublicスコープ | E-01 | ○ |
| C-09 | 送信方式は同期 | E-04, E-05, E-06 | ○ |
| C-10 | リトライ機構は存在しない | E-02 | ○ |
| C-11 | Shape型の場合は単一Shapeを追加 | E-07（行183-184） | ○ |
| C-12 | ShapeRange型の場合はループで追加 | E-07（行185-188） | ○ |
| C-13 | Static変数で前回選択を保持 | E-02（行81） | ○ |
| C-14 | WIPステータスである | E-11 | ○ |
| C-15 | 3箇所で発火される（Shape/ShapeRange/ChartArea） | E-04, E-05, E-06 | ○ |
| C-16 | 業務上の目的は選択差分の検出 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-16の業務上の目的・背景について、ソースコード内のコメントやドキュメントに明示的な記載がない
  - 候補：README.md / 開発者ドキュメント / コミットメッセージ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - イベントの基本動作に関する主張はすべてソースコードで確認済み
- 1: 中リスク - 業務目的の記述は推測に基づく部分がある
- 0: 低リスク - getShapesCol関数の動作はソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 行16のイベント宣言が設計書の記載と一致しているか確認
- [ ] 行101,115,134の各RaiseEvent呼び出しが設計書のフロー図と整合しているか確認
- [ ] getShapesCol関数の動作が設計書の記載と一致しているか確認
- [ ] 業務目的・背景の記述が妥当か確認（開発者へのヒアリング推奨）
