---
generated_at: 2026-01-15 10:32:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：2-AfterRun通知設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **イベントハンドラテンプレートの動作確認**：実際のVBA環境での動作テストが必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/stdCallback.cls` 行174（AfterRunイベント宣言）
- E-02: `src/stdCallback.cls` 行512（RaiseEvent AfterRun呼び出し）
- E-03: `src/stdCallback.cls` 行171-173（イベントコメント・パラメータ説明）
- E-04: `src/stdCallback.cls` 行376-522（RunExメソッド全体）
- E-05: `src/stdCallback.cls` 行386-509（コールバックタイプ別実行処理）
- E-06: `docs/code-to-docs/通知一覧/通知一覧.csv` 行3（AfterRun通知定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AfterRunイベントはstdCallback.cls行174で宣言されている | E-01 | ○ |
| C-02 | イベントはコールバック実行後に発火する | E-02 | ○ |
| C-03 | callback引数はstdCallbackオブジェクト自身 | E-01, E-03 | ○ |
| C-04 | result引数はByRefで渡される戻り値 | E-01, E-03 | ○ |
| C-05 | イベントは行512のRaiseEventで発火 | E-02 | ○ |
| C-06 | 送信方式は同期（RaiseEvent） | E-02 | ○ |
| C-07 | コールバックの戻り値はvRet変数に格納される | E-04, E-05 | ○ |
| C-08 | Moduleタイプの場合Application.Runが使用される | E-05（行409-425） | ○ |
| C-09 | ObjectタイプはrtcCallByNameが使用される | E-05（行426-446） | ○ |
| C-10 | PointerタイプはDispCallFuncが使用される | E-05（行451-505） | ○ |
| C-11 | result変更で戻り値を変更可能 | E-01（ByRef宣言） | ○ |
| C-12 | BeforeRunイベントと対になっている | E-04（行383, 512） | ○ |
| C-13 | 通知一覧.csvに記載がある | E-06 | ○ |
| C-14 | 行515でCopyVariantにより戻り値が設定される | E-04 | ○ |
| C-15 | イベントハンドラテンプレートが正常動作する | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-15のイベントハンドラテンプレートについて、実際のVBA環境での動作確認が行われていない
  - 候補：VBAプロジェクトでの実行テスト / ユニットテストコード / サンプルコード

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分の主張がソースコードで直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] イベント宣言（行174）の引数型が正しいか確認
- [ ] RaiseEvent呼び出し（行512）の位置がコールバック実行後であるか確認
- [ ] result変更による戻り値への影響範囲を確認
