---
generated_at: 2026-01-15 20:05:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：20-Listeners

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **業務上の目的・背景の詳細**：ソースコードコメントに明示的記載なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/stdWebSocket.cls` 行60（Listenerプロパティ宣言）
- E-02: `src/stdWebSocket.cls` 行78-119（protInitプロシージャ）
- E-03: `src/stdWebSocket.cls` 行108（Listeners初期化 Set Listeners = New Collection）
- E-04: `src/stdWebSocket.cls` 行148-167（handleEventプロシージャ）
- E-05: `src/stdWebSocket.cls` 行161（On Error Resume Next）
- E-06: `src/stdWebSocket.cls` 行162-165（リスナー呼び出しループ）
- E-07: `src/stdWebSocket.cls` 行163（listener.Run呼び出し）
- E-08: `src/stdWebSocket.cls` 行111-118（JavaScript WebSocket設定）
- E-09: `src/stdWebSocket.cls` 行153-159（VBAイベント発火）
- E-10: `docs/code-to-docs/通知一覧/通知一覧.csv` 行21（通知一覧でのListeners定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ListenersはPublic Collection型プロパティ | E-01 | ○ |
| C-02 | stdICallable実装オブジェクトを格納 | E-01（コメント）, E-07 | ○ |
| C-03 | protInit内でNew Collectionで初期化 | E-02, E-03 | ○ |
| C-04 | handleEventでリスナーを呼び出す | E-04, E-06, E-07 | ○ |
| C-05 | For Eachでループ処理 | E-06 | ○ |
| C-06 | listener.Run(sEventName, oEventData)で呼び出し | E-07 | ○ |
| C-07 | On Error Resume Nextでエラーを無視 | E-05 | ○ |
| C-08 | VBAイベント（OnOpen等）と併用可能 | E-09 | ○ |
| C-09 | JavaScriptからhandleEventが呼び出される | E-08 | ○ |
| C-10 | 4種類のイベント（Open/Close/Error/Message） | E-09 | ○ |
| C-11 | リトライ機構は存在しない | E-04, E-06 | ○ |
| C-12 | 登録順に実行される | E-06（For Each順序） | ○ |
| C-13 | Listenersが空の場合はループがスキップ | E-06 | ○ |
| C-14 | 業務上の目的はWithEvents制限の回避 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-14の業務上の目的・背景について、ソースコード内のコメントやドキュメントに明示的な記載がない
  - 候補：README.md / 開発者ドキュメント / コミットメッセージ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Listenersの実装はソースコードで完全に確認済み
- 0: 低リスク - handleEventのリスナー呼び出しロジックは単純
- 1: 中リスク - stdICallableインターフェースの仕様は別ファイル参照が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 行60のListeners宣言が設計書の記載と一致しているか確認
- [ ] 行108の初期化処理が設計書の記載と一致しているか確認
- [ ] 行162-165のリスナー呼び出しループが設計書のフロー図と整合しているか確認
- [ ] stdICallableインターフェースの仕様を確認
- [ ] 業務目的・背景の記述が妥当か確認（開発者へのヒアリング推奨）
