---
generated_at: 2026-01-15 10:34:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：3-EventRaised通知設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **Internet Explorerの動作環境**：IE非推奨に伴う動作確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/stdWebSocket.cls` 行39（EventRaisedイベント宣言）
- E-02: `src/stdWebSocket.cls` 行153（RaiseEvent EventRaised呼び出し）
- E-03: `src/stdWebSocket.cls` 行36-38（イベントコメント・パラメータ説明）
- E-04: `src/stdWebSocket.cls` 行152-167（handleEventメソッド全体）
- E-05: `src/stdWebSocket.cls` 行57-60（内部変数宣言）
- E-06: `src/stdWebSocket.cls` 行78-119（protInitメソッド）
- E-07: `src/stdWebSocket.cls` 行111-118（JavaScriptイベントハンドラ設定）
- E-08: `docs/code-to-docs/通知一覧/通知一覧.csv` 行4（EventRaised通知定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | EventRaisedイベントはstdWebSocket.cls行39で宣言されている | E-01 | ○ |
| C-02 | イベントはhandleEventメソッド内行153で発火する | E-02 | ○ |
| C-03 | sEventName引数はイベント名を表す | E-01, E-03 | ○ |
| C-04 | eventData引数はJavaScriptイベントオブジェクト | E-01, E-03 | ○ |
| C-05 | 4種類のイベント（Open, Close, Error, Message）で発火する | E-04, E-07 | ○ |
| C-06 | EventRaisedは個別イベントより先に発火する | E-04（行153が先） | ○ |
| C-07 | Listenersコレクションにも通知される | E-04（行161-166） | ○ |
| C-08 | Internet Explorerを内部で使用している | E-06（行80） | ○ |
| C-09 | protInitでWebSocketが作成される | E-06, E-07 | ○ |
| C-10 | ie, document, pURL, Listeners変数が存在する | E-05 | ○ |
| C-11 | JavaScriptでイベントハンドラが設定される | E-07 | ○ |
| C-12 | vb_objとしてVBAオブジェクトがバインドされる | E-06（行99） | ○ |
| C-13 | 通知一覧.csvに記載がある | E-08 | ○ |
| C-14 | Select CaseでOnOpen/OnClose/OnError/OnMessageに分岐 | E-04（行154-159） | ○ |
| C-15 | Listeners内のlistener.Runが呼ばれる | E-04（行164） | ○ |
| C-16 | IE非推奨環境でも正常動作する | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-16について、Internet Explorerが非推奨となった環境での動作確認が行われていない
  - 候補：Windows 11での動作テスト / Edge IEモードでのテスト / 代替実装の検討

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - Internet Explorer依存のため、将来的な互換性に懸念あり

## 6) レビュアーチェックリスト（最小）
- [ ] イベント宣言（行39）の引数型が正しいか確認
- [ ] handleEventメソッド（行152-167）の処理順序を確認
- [ ] JavaScript側のイベントハンドラ設定（行111-118）を確認
- [ ] 実行環境でInternet Explorerが利用可能か確認
